/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.text.MessageFormat;
import org.eclipse.titan.common.product.ProductIdentity;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.core.ProductIdentityHelper;

public class ModuleVersionAttribute
extends ExtensionAttribute {
    private final Identifier versionToken;
    private final boolean isTemplate;
    private ProductIdentity versionNumber;

    public ModuleVersionAttribute(Identifier id, boolean template) {
        this.versionToken = id;
        this.isTemplate = template;
    }

    public final ProductIdentity getVersionNumber() {
        return this.versionNumber;
    }

    public final void parse() {
        String versionString = this.versionToken.getTtcnName();
        if (this.isTemplate) {
            if (!"RnXnn".equals(versionString)) {
                this.getLocation().reportSemanticError("Version template must be exactly <RnXnn>");
            }
            this.versionNumber = new ProductIdentity();
            return;
        }
        this.versionNumber = ProductIdentityHelper.getProductIdentity(versionString, this.getLocation());
    }

    public static String versionString(int major, int minor, int patch) {
        int[] one = new int[]{minor + "A".codePointAt(0)};
        String rev = new String(one, 0, 1);
        return MessageFormat.format("R{0}{1}{2}", major, rev, patch == Integer.MAX_VALUE ? "" : Integer.valueOf(patch));
    }

    public final String toString() {
        if (this.versionNumber == null) {
            return "<erroneous version number>";
        }
        return this.versionNumber.toString();
    }

    @Override
    public ExtensionAttribute.ExtensionAttribute_type getAttributeType() {
        return ExtensionAttribute.ExtensionAttribute_type.VERSION;
    }
}

