/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IIdentifierContainer;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class WithAttributesPath
implements ILocateableNode,
IIncrementallyUpdateable,
IIdentifierContainer,
IVisitableNode {
    private MultipleWithAttributes attributes;
    private WeakReference<WithAttributesPath> attributeParent;
    private CompilationTimeStamp lastTimeGlobalChecked;
    private CompilationTimeStamp lastTimeChecked;
    private CompilationTimeStamp lastTimeRealAttributesCalculated;
    private List<SingleWithAttribute> realAttributeCache = new ArrayList<SingleWithAttribute>();
    private boolean steppedOverEncode = false;
    private boolean hadGlobalVariants = false;

    public void setWithAttributes(MultipleWithAttributes attributes) {
        this.attributes = attributes;
    }

    public MultipleWithAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributeParent(WithAttributesPath parent) {
        this.attributeParent = new WeakReference<WithAttributesPath>(parent);
    }

    public WithAttributesPath getAttributeParent() {
        if (this.attributeParent == null) {
            return null;
        }
        return (WithAttributesPath)this.attributeParent.get();
    }

    @Override
    public Location getLocation() {
        if (this.attributes == null) {
            return NULL_Location.INSTANCE;
        }
        return new Location(this.attributes.getLocation());
    }

    @Override
    public void setLocation(Location location) {
    }

    public void setHadGlobalVariants(boolean has) {
        this.hadGlobalVariants = has;
    }

    public boolean getHadGlobalVariants() {
        return this.hadGlobalVariants;
    }

    public void checkGlobalAttributes(CompilationTimeStamp timestamp, boolean erroneousAllowed) {
        int i;
        if (this.lastTimeGlobalChecked != null && !this.lastTimeGlobalChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeGlobalChecked = timestamp;
        if (this.attributes == null) {
            return;
        }
        if (!erroneousAllowed) {
            int size = this.attributes.getNofElements();
            for (int i2 = 0; i2 < size; ++i2) {
                SingleWithAttribute tempAttribute = this.attributes.getAttribute(i2);
                if (tempAttribute.getAttributeType() != SingleWithAttribute.Attribute_Type.Erroneous_Attribute) continue;
                tempAttribute.getLocation().reportSemanticError("The `erroneous' attribute can be used only on template and constant definitions");
            }
        }
        boolean hasOverrideVariant = false;
        boolean hasOverrideDisplay = false;
        boolean hasOverrideExtension = false;
        boolean hasOverrideOptional = false;
        block10: for (i = this.attributes.getNofElements() - 1; i >= 0; --i) {
            SingleWithAttribute tempAttribute = this.attributes.getAttribute(i);
            switch (tempAttribute.getAttributeType()) {
                case Erroneous_Attribute: {
                    if (tempAttribute.getModifier() != SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE) continue block10;
                    tempAttribute.getLocation().reportSemanticError("Override cannot be used with erroneous");
                    continue block10;
                }
            }
        }
        int size = this.attributes.getNofElements();
        block11: for (i = 0; i < size; ++i) {
            SingleWithAttribute tempAttribute = this.attributes.getAttribute(i);
            if (tempAttribute.getModifier() == SingleWithAttribute.Attribute_Modifier_type.MOD_LOCAL && tempAttribute.getAttributeType() != SingleWithAttribute.Attribute_Type.Encode_Attribute) {
                tempAttribute.getLocation().reportSemanticWarning("The '@local' modifier only affects 'encode' attributes. Modifier ignored.");
            }
            if (tempAttribute.getAttributeSpecification().getEncodings() != null && tempAttribute.getAttributeType() != SingleWithAttribute.Attribute_Type.Variant_Attribute) {
                tempAttribute.getLocation().reportSemanticWarning("Invalid attribute format. Dot notation is only allowed for variant attributes when using the new codec handling.");
            }
            switch (tempAttribute.getAttributeType()) {
                case Variant_Attribute: {
                    if (hasOverrideVariant) {
                        tempAttribute.getLocation().reportSemanticWarning("Only the first override variant of the with statement will have effect");
                        continue block11;
                    }
                    if (tempAttribute.getModifier() != SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE) continue block11;
                    hasOverrideVariant = true;
                    continue block11;
                }
                case Display_Attribute: {
                    if (hasOverrideDisplay) {
                        tempAttribute.getLocation().reportSemanticWarning("Only the first override display of the with statement will have effect");
                        continue block11;
                    }
                    if (tempAttribute.getModifier() != SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE) continue block11;
                    hasOverrideDisplay = true;
                    continue block11;
                }
                case Extension_Attribute: {
                    if (hasOverrideExtension) {
                        tempAttribute.getLocation().reportSemanticWarning("Only the first override extension of the with statement will have effect");
                        continue block11;
                    }
                    if (tempAttribute.getModifier() != SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE) continue block11;
                    hasOverrideExtension = true;
                    continue block11;
                }
                case Optional_Attribute: {
                    AttributeSpecification attributeSpecification = tempAttribute.getAttributeSpecification();
                    String tempSpecification = attributeSpecification.getSpecification();
                    if (!"implicit omit".equals(tempSpecification) && !"explicit omit".equals(tempSpecification)) {
                        String message = MessageFormat.format("The specification of an optional attribute can only be \"implicit omit\" or \"explicit omit\", not \"{0}\"", tempSpecification);
                        attributeSpecification.getLocation().reportSemanticError(message);
                    }
                    if (hasOverrideOptional) {
                        tempAttribute.getLocation().reportSemanticWarning("Only the first override optional of the with statement will have effect");
                        continue block11;
                    }
                    if (tempAttribute.getModifier() != SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE) continue block11;
                    hasOverrideOptional = true;
                    continue block11;
                }
            }
        }
    }

    public void checkAttributes(CompilationTimeStamp timestamp, IType.Type_type type) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.attributes == null) {
            return;
        }
        switch (type) {
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_TTCN3_SET: 
            case TYPE_ASN1_SET: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_SET_OF: {
                return;
            }
        }
        int size = this.attributes.getNofElements();
        for (int i = 0; i < size; ++i) {
            SingleWithAttribute tempAttribute = this.attributes.getAttribute(i);
            Qualifiers qualifiers = tempAttribute.getQualifiers();
            if (qualifiers == null || qualifiers.getNofQualifiers() == 0) continue;
            tempAttribute.getLocation().reportSemanticError("Field qualifiers are only allowed for record, set and union types");
        }
    }

    public void checkAttributes(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.attributes == null) {
            return;
        }
        int size = this.attributes.getNofElements();
        for (int i = 0; i < size; ++i) {
            SingleWithAttribute tempAttribute = this.attributes.getAttribute(i);
            Qualifiers qualifiers = tempAttribute.getQualifiers();
            if (qualifiers == null || qualifiers.getNofQualifiers() == 0) continue;
            tempAttribute.getLocation().reportSemanticError("Field qualifiers are only allowed for record, set and union types");
        }
    }

    private boolean hasSteppedOverEncode() {
        return this.steppedOverEncode;
    }

    private List<SingleWithAttribute> qualifierlessAttributeProcessor(CompilationTimeStamp timestamp) {
        int i;
        if (this.lastTimeRealAttributesCalculated != null && !this.lastTimeRealAttributesCalculated.isLess(timestamp)) {
            return this.realAttributeCache;
        }
        this.lastTimeRealAttributesCalculated = timestamp;
        this.realAttributeCache = new ArrayList<SingleWithAttribute>();
        if (this.attributeParent != null) {
            WithAttributesPath parentPath = (WithAttributesPath)this.attributeParent.get();
            if (parentPath != null) {
                List<SingleWithAttribute> temp = parentPath.qualifierlessAttributeProcessor(timestamp);
                this.realAttributeCache.addAll(temp);
                this.steppedOverEncode = parentPath.hasSteppedOverEncode();
            } else {
                this.steppedOverEncode = false;
            }
        } else {
            this.steppedOverEncode = false;
        }
        if (this.attributes == null || this.attributes.getNofElements() == 0) {
            return this.realAttributeCache;
        }
        int selfEncodeIndex = -1;
        boolean selfHasVariant = false;
        int size = this.attributes.getNofElements();
        block22: for (int i2 = 0; i2 < size; ++i2) {
            SingleWithAttribute actualSingleAttribute = this.attributes.getAttribute(i2);
            Qualifiers actualQualifiers = actualSingleAttribute.getQualifiers();
            if (actualQualifiers != null && actualQualifiers.getNofQualifiers() != 0) continue;
            switch (actualSingleAttribute.getAttributeType()) {
                case Encode_Attribute: {
                    selfEncodeIndex = i2;
                    continue block22;
                }
                case Variant_Attribute: {
                    selfHasVariant = true;
                    continue block22;
                }
            }
        }
        boolean parentHasEncode = false;
        boolean parentHasOverrideEncode = false;
        boolean newLocalEncodeContext = false;
        boolean parentHasOverrideVariant = false;
        boolean parentHasOverrideDisplay = false;
        boolean parentHasOverrideExtension = false;
        boolean parentHasOverrideOptional = false;
        int size2 = this.realAttributeCache.size();
        block23: for (i = 0; i < size2; ++i) {
            SingleWithAttribute actualSingleAttribute = this.realAttributeCache.get(i);
            switch (actualSingleAttribute.getAttributeType()) {
                case Encode_Attribute: {
                    String selfSpecification;
                    parentHasEncode = true;
                    parentHasOverrideEncode |= actualSingleAttribute.getModifier() == SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE;
                    if (selfEncodeIndex == -1) continue block23;
                    String actualSpecification = actualSingleAttribute.getAttributeSpecification().getSpecification();
                    newLocalEncodeContext = !actualSpecification.equals(selfSpecification = this.attributes.getAttribute(selfEncodeIndex).getAttributeSpecification().getSpecification());
                    continue block23;
                }
                case Variant_Attribute: {
                    parentHasOverrideVariant |= actualSingleAttribute.getModifier() == SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE;
                    continue block23;
                }
                case Display_Attribute: {
                    parentHasOverrideDisplay |= actualSingleAttribute.getModifier() == SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE;
                    continue block23;
                }
                case Extension_Attribute: {
                    parentHasOverrideExtension |= actualSingleAttribute.getModifier() == SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE;
                    continue block23;
                }
                case Optional_Attribute: {
                    parentHasOverrideOptional |= actualSingleAttribute.getModifier() == SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE;
                    continue block23;
                }
            }
        }
        block24: for (i = this.realAttributeCache.size() - 1; i >= 0; --i) {
            switch (this.realAttributeCache.get(i).getAttributeType()) {
                case Encode_Attribute: {
                    if (selfEncodeIndex == -1 || parentHasOverrideEncode || !newLocalEncodeContext) continue block24;
                    this.realAttributeCache.remove(i);
                    continue block24;
                }
                case Variant_Attribute: {
                    if (selfEncodeIndex == -1 || parentHasOverrideEncode || !newLocalEncodeContext) continue block24;
                    this.realAttributeCache.remove(i);
                    continue block24;
                }
            }
        }
        boolean localHasOverrideVariant = false;
        boolean localHasOverrideDisplay = false;
        boolean localHasOverrideExtension = false;
        boolean localHasOverrideOptional = false;
        int size3 = this.attributes.getNofElements();
        block25: for (int i3 = 0; i3 < size3; ++i3) {
            SingleWithAttribute actualSingleAttribute = this.attributes.getAttribute(i3);
            Qualifiers actualQualifiers = actualSingleAttribute.getQualifiers();
            if (actualQualifiers != null && actualQualifiers.getNofQualifiers() != 0) continue;
            switch (actualSingleAttribute.getAttributeType()) {
                case Encode_Attribute: {
                    if (parentHasEncode && !parentHasOverrideEncode && newLocalEncodeContext || !parentHasEncode) {
                        this.realAttributeCache.add(0, actualSingleAttribute);
                        this.steppedOverEncode = false;
                        continue block25;
                    }
                    if (newLocalEncodeContext) {
                        this.steppedOverEncode = true;
                        continue block25;
                    }
                    this.steppedOverEncode = false;
                    continue block25;
                }
                case Variant_Attribute: {
                    boolean localEncodeOverwritesParent;
                    boolean parentHasNothing = !parentHasEncode && !parentHasOverrideVariant;
                    boolean noParentButLocalEncode = !parentHasEncode && selfEncodeIndex != -1;
                    boolean newLocalEncode = parentHasEncode && selfEncodeIndex == -1 && !this.steppedOverEncode && !parentHasOverrideVariant;
                    boolean bl = localEncodeOverwritesParent = parentHasEncode && selfEncodeIndex != -1 && !parentHasOverrideEncode && !parentHasOverrideVariant;
                    if (!parentHasNothing && !noParentButLocalEncode && !newLocalEncode && !localEncodeOverwritesParent || localHasOverrideVariant) continue block25;
                    this.realAttributeCache.add(actualSingleAttribute);
                    localHasOverrideVariant = actualSingleAttribute.getModifier() == SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE;
                    continue block25;
                }
                case Display_Attribute: {
                    if (parentHasOverrideDisplay || localHasOverrideDisplay) continue block25;
                    this.realAttributeCache.add(actualSingleAttribute);
                    localHasOverrideDisplay = actualSingleAttribute.getModifier() == SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE;
                    continue block25;
                }
                case Extension_Attribute: {
                    if (parentHasOverrideExtension || localHasOverrideExtension) continue block25;
                    this.realAttributeCache.add(actualSingleAttribute);
                    localHasOverrideExtension = actualSingleAttribute.getModifier() == SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE;
                    continue block25;
                }
                case Optional_Attribute: {
                    if (parentHasOverrideOptional || localHasOverrideOptional) continue block25;
                    this.realAttributeCache.add(actualSingleAttribute);
                    localHasOverrideOptional = actualSingleAttribute.getModifier() == SingleWithAttribute.Attribute_Modifier_type.MOD_OVERRIDE;
                    continue block25;
                }
            }
        }
        return this.realAttributeCache;
    }

    public List<SingleWithAttribute> getRealAttributes(CompilationTimeStamp timestamp) {
        return this.qualifierlessAttributeProcessor(timestamp);
    }

    public boolean hasAttributes(CompilationTimeStamp timestamp) {
        if (this.hadGlobalVariants) {
            return true;
        }
        if (this.getRealAttributes(timestamp).size() > 0) {
            return true;
        }
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.getNofElements(); ++i) {
                Qualifiers qualifiers = this.attributes.getAttribute(i).getQualifiers();
                if (qualifiers == null || qualifiers.getNofQualifiers() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.attributes != null) {
            this.attributes.updateSyntax(reparser, false);
            reparser.updateLocation(this.attributes.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.attributes == null) {
            return;
        }
        this.attributes.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.attributes != null && !this.attributes.accept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }
}

