/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TTCN3Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class RunsOnScope
extends TTCN3Scope {
    private Component_Type componentType;
    private ComponentTypeBody componentDefinitions;

    public RunsOnScope(Component_Type componentType, Scope parentScope) {
        this.componentType = componentType;
        if (componentType == null) {
            this.componentDefinitions = null;
        } else {
            componentType.setOwnertype(IType.TypeOwner_type.OT_RUNSON_SCOPE, this);
            this.componentDefinitions = componentType.getComponentBody();
        }
        this.setParentScope(parentScope);
    }

    public void setComponentType(Component_Type componentType) {
        this.componentType = componentType;
        this.componentDefinitions = componentType == null ? null : componentType.getComponentBody();
    }

    @Override
    public boolean hasAssignmentWithId(CompilationTimeStamp timestamp, Identifier identifier) {
        if (this.componentDefinitions != null && this.componentDefinitions.hasAssignmentWithId(timestamp, identifier)) {
            return true;
        }
        return super.hasAssignmentWithId(timestamp, identifier);
    }

    @Override
    public RunsOnScope getScopeRunsOn() {
        return this;
    }

    public Component_Type getComponentType() {
        return this.componentType;
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        if (this.componentDefinitions != null && this.componentDefinitions.hasLocalAssignmentWithId(reference.getId())) {
            return this.componentDefinitions.getLocalAssignmentById(reference.getId());
        }
        if (this.parentScope != null) {
            return this.parentScope.getAssBySRef(timestamp, reference);
        }
        return null;
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        if (propCollector.getReference().getModuleIdentifier() == null && this.componentDefinitions != null) {
            this.componentDefinitions.addProposal(propCollector);
        }
        super.addProposal(propCollector);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector) {
        if (declarationCollector.getReference().getModuleIdentifier() == null && this.componentDefinitions != null && this.componentDefinitions.hasLocalAssignmentWithId(declarationCollector.getReference().getId())) {
            Definition def = this.componentDefinitions.getLocalAssignmentById(declarationCollector.getReference().getId());
            declarationCollector.addDeclaration(def);
        }
        super.addDeclaration(declarationCollector);
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentType != null) {
            this.componentType.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.componentDefinitions != null) {
            this.componentDefinitions.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.componentType != null && !this.componentType.accept(v)) {
            return false;
        }
        if (this.componentDefinitions != null && !this.componentDefinitions.accept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }
}

