/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Const;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Referenced_ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Template_ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.Referenced_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SetOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class All_From_Template
extends TTCN3Template {
    private static final String SPECIFICVALUEEXPECTED = "After all from a specific value is expected";
    private static final String LISTEXPECTED = "After all from a variable or a template of list type is expected";
    private static final String TYPEMISMATCH = "Type mismatch: `{0}'' was expected in the list";
    private static final String REFERENCEEXPECTED = "Reference to a value was expected";
    private static final String ANYOROMITANDPERMUTATIONPRHOHIBITED = "`all from' can not refer to a template containing permutation or AnyElementsOrNone";
    private final TTCN3Template allFrom;

    public All_From_Template(TTCN3Template allFrom) {
        this.allFrom = allFrom;
        if (allFrom != null) {
            allFrom.setFullNameParent(this);
        }
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.ALL_FROM;
    }

    @Override
    public String getTemplateTypeName() {
        return "all from ".concat(this.allFrom.getTemplateTypeName());
    }

    @Override
    public String createStringRepresentation() {
        if (this.allFrom == null) {
            return "<erroneous template>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.allFrom.createStringRepresentation());
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    public TTCN3Template getAllFrom() {
        return this.allFrom;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.allFrom != null) {
            this.allFrom.setMyScope(scope);
        }
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp) && this.myGovernor != null) {
            return this.myGovernor;
        }
        if (this.allFrom != null) {
            this.allFrom.setMyGovernor(null);
            ITTCN3Template temp = this.allFrom.setLoweridToReference(timestamp);
            IType type = temp.getExpressionGovernor(timestamp, expectedValue);
            if (temp.getIsErroneous(timestamp)) {
                this.isErroneous = true;
            }
            return type;
        }
        return null;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp) || this.allFrom == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        this.allFrom.setLoweridToReference(timestamp);
        return this.allFrom.getExpressionReturntype(timestamp, expectedValue);
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        return this.allFrom.checkExpressionSelfReferenceTemplate(timestamp, lhs);
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value expected instead of a all from reference");
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.allFrom != null) {
            this.allFrom.checkRecursions(timestamp, referenceChain);
        }
    }

    @Override
    public boolean checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit, Assignment lhs) {
        if (this.allFrom == null) {
            ErrorReporter.INTERNAL_ERROR();
            return false;
        }
        if (!ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)this.allFrom.getTemplatetype())) {
            this.allFrom.getLocation().reportSemanticError(SPECIFICVALUEEXPECTED);
            this.allFrom.setIsErroneous(true);
            return false;
        }
        if (!((SpecificValue_Template)this.allFrom).isReference()) {
            this.allFrom.getLocation().reportSemanticError(REFERENCEEXPECTED);
            this.allFrom.setIsErroneous(true);
            return false;
        }
        Reference reference = ((SpecificValue_Template)this.allFrom).getReference();
        Assignment assignment = reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.allFrom.getLocation().reportSemanticError("Assignment not found");
            this.allFrom.setIsErroneous(true);
            return false;
        }
        boolean selfReference = lhs == assignment;
        IType assType = assignment.getType(timestamp);
        if (assType != null) {
            IType atype = assType.getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
            if (atype == null) {
                this.allFrom.setIsErroneous(true);
                return false;
            }
            IType referredType = atype.getTypeRefdLast(timestamp);
            IType it = null;
            if (referredType != null) {
                switch (referredType.getTypetype()) {
                    case TYPE_SEQUENCE_OF: {
                        it = ((SequenceOf_Type)referredType).getOfType();
                        break;
                    }
                    case TYPE_ARRAY: {
                        it = ((Array_Type)referredType).getElementType();
                        break;
                    }
                    case TYPE_SET_OF: {
                        it = ((SetOf_Type)referredType).getOfType();
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: {
                        break;
                    }
                    default: {
                        this.allFrom.getLocation().reportSemanticError(LISTEXPECTED);
                        this.allFrom.setIsErroneous(true);
                    }
                }
            }
            if (it != null && !it.isCompatible(timestamp, type, null, null, null)) {
                this.allFrom.getLocation().reportSemanticError(MessageFormat.format(TYPEMISMATCH, type.getTypename()));
                this.allFrom.setIsErroneous(true);
            }
        }
        ITTCN3Template body = null;
        Value value = null;
        switch (assignment.getAssignmentType()) {
            case A_TEMPLATE: {
                body = ((Def_Template)assignment).getTemplate(timestamp);
                selfReference |= this.checkThisTemplateParameterizedReference(reference, lhs);
                break;
            }
            case A_VAR_TEMPLATE: {
                body = ((Def_Var_Template)assignment).getInitialValue();
                break;
            }
            case A_CONST: {
                break;
            }
            case A_MODULEPAR: {
                value = ((Def_ModulePar)assignment).getDefaultValue();
                break;
            }
            case A_MODULEPAR_TEMPLATE: {
                body = ((Def_ModulePar_Template)assignment).getDefaultTemplate(timestamp);
                break;
            }
            case A_VAR: {
                value = ((Def_Var)assignment).getInitialValue();
                break;
            }
            case A_FUNCTION_RVAL: 
            case A_FUNCTION_RTEMP: 
            case A_EXT_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RTEMP: {
                selfReference |= this.checkThisTemplateParameterizedReference(reference, lhs);
                break;
            }
            default: {
                return selfReference;
            }
        }
        if (body != null) {
            switch (body.getTemplatetype()) {
                case TEMPLATE_LIST: {
                    if (allowAnyOrOmit || !((Template_List)body).containsAnyornoneOrPermutation(timestamp)) break;
                    this.allFrom.getLocation().reportSemanticError(ANYOROMITANDPERMUTATIONPRHOHIBITED);
                    this.allFrom.setIsErroneous(true);
                    break;
                }
                case NAMED_TEMPLATE_LIST: {
                    ((Named_Template_List)body).checkSpecificValue(timestamp, true);
                    break;
                }
                case SPECIFIC_VALUE: {
                    break;
                }
                default: {
                    this.allFrom.getLocation().reportSemanticError(LISTEXPECTED);
                    this.allFrom.setIsErroneous(true);
                    return selfReference;
                }
            }
        }
        return selfReference;
    }

    private boolean checkThisTemplateParameterizedReference(Reference reference, Assignment lhs) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.isEmpty() || !(subreferences.get(0) instanceof ParameterisedSubReference)) {
            return false;
        }
        ParameterisedSubReference subReference = (ParameterisedSubReference)subreferences.get(0);
        ActualParameterList actualParameterList = subReference.getActualParameters();
        if (actualParameterList == null) {
            return false;
        }
        int nofParameters = actualParameterList.getNofParameters();
        block3: for (int i = 0; i < nofParameters; ++i) {
            Reference parameterReference = null;
            ActualParameter actualParameter = actualParameterList.getParameter(i);
            if (actualParameter instanceof Template_ActualParameter) {
                TemplateInstance templateInstance = ((Template_ActualParameter)actualParameter).getTemplateInstance();
                ITTCN3Template template = templateInstance.getTemplateBody();
                if ((template = template.setLoweridToReference(CompilationTimeStamp.getBaseTimestamp())).getTemplatetype() == ITTCN3Template.Template_type.TEMPLATE_REFD) {
                    parameterReference = ((Referenced_Template)template).getReference();
                }
            } else if (actualParameter instanceof Referenced_ActualParameter) {
                parameterReference = ((Referenced_ActualParameter)actualParameter).getReference();
            }
            if (parameterReference == null) continue;
            Assignment assignment = parameterReference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
            if (assignment == lhs) {
                return true;
            }
            switch (assignment.getAssignmentType()) {
                case A_TEMPLATE: 
                case A_FUNCTION_RVAL: 
                case A_FUNCTION_RTEMP: 
                case A_EXT_FUNCTION_RVAL: 
                case A_EXT_FUNCTION_RTEMP: {
                    if (!this.checkThisTemplateParameterizedReference(parameterReference, lhs)) continue block3;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isValue(CompilationTimeStamp timestamp) {
        return false;
    }

    private int getNofValues(IValue value, CompilationTimeStamp timestamp) {
        int result = 0;
        if (value == null) {
            return result;
        }
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue lastValue = value.getValueRefdLast(timestamp, chain);
        chain.release();
        if (lastValue.getIsErroneous(timestamp)) {
            return result;
        }
        if (IValue.Value_type.SEQUENCEOF_VALUE.equals((Object)lastValue.getValuetype())) {
            SequenceOf_Value lvalue = (SequenceOf_Value)lastValue;
            result = lvalue.getNofComponents();
            return result;
        }
        if (IValue.Value_type.SETOF_VALUE.equals((Object)lastValue.getValuetype())) {
            SetOf_Value svalue = (SetOf_Value)lastValue;
            result = svalue.getNofComponents();
            return result;
        }
        return 1;
    }

    public int getNofTemplatesNotAnyornone(CompilationTimeStamp timestamp) {
        int result = 0;
        if (this.allFrom == null) {
            ErrorReporter.INTERNAL_ERROR();
            return result;
        }
        if (!ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)this.allFrom.getTemplatetype())) {
            this.allFrom.getLocation().reportSemanticError(REFERENCEEXPECTED);
            this.allFrom.setIsErroneous(true);
            return result;
        }
        if (!((SpecificValue_Template)this.allFrom).isReference()) {
            this.allFrom.getLocation().reportSemanticError(REFERENCEEXPECTED);
            this.allFrom.setIsErroneous(true);
            return result;
        }
        Reference reference = ((SpecificValue_Template)this.allFrom).getReference();
        Assignment assignment = reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.allFrom.getLocation().reportSemanticError("Assignment not found");
            this.allFrom.setIsErroneous(true);
            return result;
        }
        ITTCN3Template body = null;
        switch (assignment.getAssignmentType()) {
            case A_TEMPLATE: {
                body = ((Def_Template)assignment).getTemplate(timestamp);
                break;
            }
            case A_VAR_TEMPLATE: {
                body = ((Def_Var_Template)assignment).getInitialValue();
                break;
            }
            case A_CONST: {
                IValue value = ((Def_Const)assignment).getValue();
                return this.getNofValues(value, timestamp);
            }
            case A_MODULEPAR: {
                Value mvalue = ((Def_ModulePar)assignment).getDefaultValue();
                return this.getNofValues(mvalue, timestamp);
            }
            case A_MODULEPAR_TEMPLATE: {
                body = ((Def_ModulePar_Template)assignment).getDefaultTemplate(timestamp);
                break;
            }
            default: {
                return result;
            }
        }
        if (body == null) {
            ErrorReporter.INTERNAL_ERROR();
            return result;
        }
        if (!ITTCN3Template.Template_type.TEMPLATE_LIST.equals((Object)body.getTemplatetype())) {
            this.allFrom.getLocation().reportSemanticError("Template must be a record of or a set of values");
            this.allFrom.setIsErroneous(true);
            return result;
        }
        result = ((Template_List)body).getNofTemplatesNotAnyornone(timestamp);
        return result;
    }

    public boolean containsAnyornoneOrPermutation(CompilationTimeStamp timestamp) {
        if (this.allFrom == null) {
            ErrorReporter.INTERNAL_ERROR();
            return false;
        }
        if (!ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)this.allFrom.getTemplatetype())) {
            this.allFrom.getLocation().reportSemanticError(REFERENCEEXPECTED);
            this.allFrom.setIsErroneous(true);
            return false;
        }
        if (!((SpecificValue_Template)this.allFrom).isReference()) {
            this.allFrom.getLocation().reportSemanticError(REFERENCEEXPECTED);
            this.allFrom.setIsErroneous(true);
            return false;
        }
        Reference reference = ((SpecificValue_Template)this.allFrom).getReference();
        Assignment assignment = reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.allFrom.getLocation().reportSemanticError("Assignment not found");
            this.allFrom.setIsErroneous(true);
            return false;
        }
        ITTCN3Template body = null;
        switch (assignment.getAssignmentType()) {
            case A_TEMPLATE: {
                body = ((Def_Template)assignment).getTemplate(timestamp);
                break;
            }
            case A_VAR_TEMPLATE: {
                body = ((Def_Var_Template)assignment).getInitialValue();
                break;
            }
            case A_CONST: {
                return false;
            }
            case A_MODULEPAR: {
                return false;
            }
            case A_MODULEPAR_TEMPLATE: {
                body = ((Def_ModulePar_Template)assignment).getDefaultTemplate(timestamp);
                break;
            }
            default: {
                return false;
            }
        }
        if (body == null) {
            ErrorReporter.INTERNAL_ERROR();
            return false;
        }
        if (!ITTCN3Template.Template_type.TEMPLATE_LIST.equals((Object)body.getTemplatetype())) {
            this.allFrom.getLocation().reportSemanticError("Template must be a record of or a set of values");
            this.allFrom.setIsErroneous(true);
            return false;
        }
        return ((Template_List)body).containsAnyornoneOrPermutation(timestamp);
    }

    @Override
    public boolean hasSingleExpression() {
        return false;
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.allFrom != null) {
            this.allFrom.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        this.generateCodeInitAllFrom(aData, source, name);
        if (this.lengthRestriction != null) {
            if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            }
            this.lengthRestriction.generateCodeInit(aData, source, name);
        }
        if (this.isIfpresent) {
            source.append(name);
            source.append(".set_ifPresent();\n");
        }
    }

    public void generateCodeInitAllFrom(JavaGenData aData, StringBuilder source, String name) {
        IValue value = ((SpecificValue_Template)this.allFrom).getValue();
        Reference reference = value.getValuetype() == IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE ? ((Undefined_LowerIdentifier_Value)value).getAsReference() : ((Referenced_Value)value).getReference();
        ExpressionStruct expression = new ExpressionStruct();
        reference.generateCode(aData, expression);
        Assignment assignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
        switch (assignment.getAssignmentType()) {
            case A_CONST: 
            case A_MODULEPAR: 
            case A_VAR: 
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RVAL: 
            case A_EXT_CONST: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                if (!assignment.getType(CompilationTimeStamp.getBaseTimestamp()).fieldIsOptional(reference.getSubreferences())) break;
                expression.expression.append(".get()");
                break;
            }
        }
        source.append(MessageFormat.format("{0}.operator_assign({1}.constGet_at(i_i));\n", name, expression.expression));
    }

    public void generateCodeInitAllFrom(JavaGenData aData, StringBuilder source, String name, StringBuilder referenceCache) {
        source.append(MessageFormat.format("{0}.operator_assign({1}.constGet_at(i_i));\n", name, referenceCache));
    }

    @Override
    public void setMyDefinition(Definition definition) {
        this.allFrom.setMyDefinition(definition);
    }
}

