/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class BitString_Pattern_Template
extends TTCN3Template {
    private final String pattern;

    public BitString_Pattern_Template(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.BSTR_PATTERN;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous bitstring pattern";
        }
        return "bitstring pattern";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("'");
        builder.append(this.pattern);
        builder.append("'B");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.lengthRestriction != null) {
            this.lengthRestriction.setCodeSection(codeSection);
        }
    }

    public boolean containsAnyornoneSymbol() {
        return this.pattern.indexOf(42) > -1;
    }

    public int getMinLengthOfPattern() {
        int starCount = 0;
        int index = this.pattern.indexOf(42, 0);
        while (index != -1) {
            ++index;
            ++starCount;
            index = this.pattern.indexOf(42, index);
        }
        return this.pattern.length() - starCount;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return IType.Type_type.TYPE_BITSTRING;
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        return false;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value expected instead of an bitstring pattern");
    }

    @Override
    protected void checkTemplateSpecificLengthRestriction(CompilationTimeStamp timestamp, IType.Type_type typeType) {
        if (IType.Type_type.TYPE_BITSTRING.equals((Object)typeType)) {
            boolean hasAnyOrNone = this.containsAnyornoneSymbol();
            this.lengthRestriction.checkNofElements(timestamp, this.getMinLengthOfPattern(), hasAnyOrNone, false, hasAnyOrNone, this);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
    }

    @Override
    public boolean hasSingleExpression() {
        return this.lengthRestriction == null && !this.isIfpresent && !this.get_needs_conversion();
    }

    @Override
    public StringBuilder getSingleExpression(JavaGenData aData, boolean castIsNeeded) {
        aData.addBuiltinTypeImport("TitanBitString_template");
        StringBuilder result = new StringBuilder();
        result.append(MessageFormat.format("new TitanBitString_template(\"{0}\")", this.pattern));
        return result;
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        aData.addBuiltinTypeImport("TitanBitString_template");
        source.append(MessageFormat.format("{0}.operator_assign(new TitanBitString_template(\"{1}\"));\n", name, this.pattern));
        if (this.lengthRestriction != null) {
            if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            }
            this.lengthRestriction.generateCodeInit(aData, source, name);
        }
        if (this.isIfpresent) {
            source.append(name);
            source.append(".set_ifPresent();\n");
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
    }
}

