/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.All_From_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.CompositeTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ListOfTemplates;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SetOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class SupersetMatch_Template
extends CompositeTemplate {
    public SupersetMatch_Template(ListOfTemplates templates) {
        super(templates);
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.SUPERSET_MATCH;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous superset match";
        }
        return "superset match";
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return IType.Type_type.TYPE_SET_OF;
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (!this.templates.getTemplateByIndex(i).checkExpressionSelfReferenceTemplate(timestamp, lhs)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value expected instead of a superset match");
    }

    @Override
    protected void checkTemplateSpecificLengthRestriction(CompilationTimeStamp timestamp, IType.Type_type typeType) {
        if (IType.Type_type.TYPE_SET_OF.equals((Object)typeType)) {
            this.lengthRestriction.checkNofElements(timestamp, this.getNofTemplatesNotAnyornone(timestamp), true, false, true, this);
        }
    }

    @Override
    protected String getNameForStringRep() {
        return "superset";
    }

    @Override
    public boolean needsTemporaryReference() {
        return true;
    }

    @Override
    public boolean hasSingleExpression() {
        if (this.lengthRestriction != null || this.isIfpresent || this.get_needs_conversion()) {
            return false;
        }
        return false;
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, TemplateRestriction.Restriction_type templateRestriction) {
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            return;
        }
        String genName = governor.getGenNameTemplate(aData, expression.expression);
        String tempId = aData.getTemporaryVariableName();
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", genName, tempId));
        this.setGenNameRecursive(tempId);
        this.generateCodeInit(aData, expression.preamble, tempId);
        if (templateRestriction != TemplateRestriction.Restriction_type.TR_NONE) {
            TemplateRestriction.generateRestrictionCheckCode(aData, expression.preamble, this.location, tempId, templateRestriction);
        }
        expression.expression.append(tempId);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        for (int i = 0; i < this.templates.getNofTemplates(); ++i) {
            this.templates.getTemplateByIndex(i).reArrangeInitCode(aData, source, usageModule);
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        int i;
        String ofTypeName;
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        aData.addBuiltinTypeImport("Base_Template.template_sel");
        switch (this.myGovernor.getTypetype()) {
            case TYPE_SEQUENCE_OF: {
                ofTypeName = ((SequenceOf_Type)this.myGovernor).getOfType().getGenNameTemplate(aData, source);
                break;
            }
            case TYPE_SET_OF: {
                ofTypeName = ((SetOf_Type)this.myGovernor).getOfType().getGenNameTemplate(aData, source);
                break;
            }
            case TYPE_ARRAY: {
                ofTypeName = ((Array_Type)this.myGovernor).getElementType().getGenNameTemplate(aData, source);
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while processing superset match template `" + this.getFullName() + "''"));
                return;
            }
        }
        ArrayList<Integer> variables = new ArrayList<Integer>();
        long fixedPart = 0L;
        for (i = 0; i < this.templates.getNofTemplates(); ++i) {
            TTCN3Template templateListItem = this.templates.getTemplateByIndex(i);
            if (templateListItem.getTemplatetype() == ITTCN3Template.Template_type.ALL_FROM) {
                variables.add(i);
                continue;
            }
            ++fixedPart;
        }
        if (variables.size() > 0) {
            StringBuilder preamble = new StringBuilder();
            StringBuilder setType = new StringBuilder();
            StringBuilder[] variableReferences = new StringBuilder[this.templates.getNofTemplates()];
            setType.append(MessageFormat.format("{0}.set_type(template_sel.SUPERSET_MATCH, {1}", name, fixedPart));
            for (int v = 0; v < variables.size(); ++v) {
                TTCN3Template template;
                TTCN3Template template2 = template = this.templates.getTemplateByIndex((Integer)variables.get(v));
                if (template instanceof All_From_Template) {
                    template2 = ((All_From_Template)template).getAllFrom();
                }
                Reference reference = ((SpecificValue_Template)template2).getReference();
                Assignment assignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                setType.append(" + ");
                ExpressionStruct expression = new ExpressionStruct();
                reference.generateConstRef(aData, expression);
                if (expression.preamble.length() > 0) {
                    preamble.append((CharSequence)expression.preamble);
                }
                switch (assignment.getAssignmentType()) {
                    case A_CONST: 
                    case A_EXT_CONST: 
                    case A_MODULEPAR: 
                    case A_VAR: 
                    case A_PAR_VAL: 
                    case A_PAR_VAL_IN: 
                    case A_PAR_VAL_OUT: 
                    case A_PAR_VAL_INOUT: 
                    case A_FUNCTION_RVAL: 
                    case A_EXT_FUNCTION_RVAL: {
                        if (!assignment.getType(CompilationTimeStamp.getBaseTimestamp()).fieldIsOptional(reference.getSubreferences())) break;
                        expression.expression.append(".constGet()");
                        break;
                    }
                }
                variableReferences[((Integer)variables.get((int)v)).intValue()] = expression.expression;
                setType.append((CharSequence)expression.expression);
                setType.append(".n_elem()");
            }
            source.append((CharSequence)preamble);
            source.append((CharSequence)setType);
            source.append(");\n");
            StringBuilder shifty = new StringBuilder();
            block13: for (int i2 = 0; i2 < this.templates.getNofTemplates(); ++i2) {
                TTCN3Template template = this.templates.getTemplateByIndex(i2);
                switch (template.getTemplatetype()) {
                    case ALL_FROM: {
                        StringBuilder storedExpression = variableReferences[i2];
                        source.append(MessageFormat.format("for (int i_i = 0, i_lim = {0}.n_elem(); i_i < i_lim; ++i_i ) '{'\n", storedExpression));
                        String embeddedName = MessageFormat.format("{0}.set_item({1}{2} + i_i)", name, i2, shifty);
                        ((All_From_Template)template).generateCodeInitAllFrom(aData, source, embeddedName, storedExpression);
                        source.append("}\n");
                        shifty.append(MessageFormat.format("-1 + {0}.n_elem()", storedExpression));
                        continue block13;
                    }
                    default: {
                        if (template.needsTemporaryReference()) {
                            String tempId = aData.getTemporaryVariableName();
                            source.append("{\n");
                            source.append(MessageFormat.format("final {0} {1} = {2}.set_item({3}{4});\n", ofTypeName, tempId, name, i2, shifty));
                            template.generateCodeInit(aData, source, tempId);
                            source.append("}\n");
                            continue block13;
                        }
                        String embeddedName = MessageFormat.format("{0}.set_item({1}{2})", name, i2, shifty);
                        template.generateCodeInit(aData, source, embeddedName);
                    }
                }
            }
        } else {
            source.append(MessageFormat.format("{0}.set_type(template_sel.SUPERSET_MATCH, {1});\n", name, this.templates.getNofTemplates()));
            for (i = 0; i < this.templates.getNofTemplates(); ++i) {
                TTCN3Template template = this.templates.getTemplateByIndex(i);
                if (template.needsTemporaryReference()) {
                    String tempId = aData.getTemporaryVariableName();
                    source.append("{\n");
                    source.append(MessageFormat.format("{0} {1} = {2}.set_item({3});\n", ofTypeName, tempId, name, i));
                    template.generateCodeInit(aData, source, tempId);
                    source.append("}\n");
                    continue;
                }
                String embeddedName = MessageFormat.format("{0}.set_item({1})", name, i);
                template.generateCodeInit(aData, source, embeddedName);
            }
        }
        if (this.lengthRestriction != null) {
            if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            }
            this.lengthRestriction.generateCodeInit(aData, source, name);
        }
        if (this.isIfpresent) {
            source.append(name);
            source.append(".set_ifPresent();\n");
        }
    }
}

