/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.All_From_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.CompositeTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ListOfTemplates;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ValueList_Template
extends CompositeTemplate {
    public ValueList_Template(ListOfTemplates templates) {
        super(templates);
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.VALUE_LIST;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous value list match";
        }
        return "value list match";
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            IType type = this.templates.getTemplateByIndex(i).getExpressionGovernor(timestamp, expectedValue);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            IType.Type_type type = this.templates.getTemplateByIndex(i).getExpressionReturntype(timestamp, expectedValue);
            if (IType.Type_type.TYPE_UNDEFINED.equals((Object)type)) continue;
            return type;
        }
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public boolean checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit, Assignment lhs) {
        if (type == null) {
            return false;
        }
        boolean allowOmitInValueList = TTCN3Template.allowOmitInValueList(this.getLocation(), allowOmit);
        boolean selfReference = false;
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            TTCN3Template component = this.templates.getTemplateByIndex(i);
            component.setMyGovernor(type);
            ITTCN3Template temporalComponent = type.checkThisTemplateRef(timestamp, component);
            selfReference |= temporalComponent.checkThisTemplateGeneric(timestamp, type, false, allowOmitInValueList, true, subCheck, implicitOmit, lhs);
        }
        this.checkLengthRestriction(timestamp, type);
        if (!allowOmit && this.isIfpresent && this.location != null && !(this.location instanceof NULL_Location)) {
            this.location.reportSemanticError("`ifpresent' is not allowed here");
        }
        if (subCheck) {
            type.checkThisTemplateSubtype(timestamp, this);
        }
        return selfReference;
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (!this.templates.getTemplateByIndex(i).checkExpressionSelfReferenceTemplate(timestamp, lhs)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.getLocation().reportSemanticError("A specific value was expected instead of value list match");
    }

    @Override
    public boolean checkPresentRestriction(CompilationTimeStamp timestamp, String definitionName, Location usageLocation) {
        this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_PRESENT, usageLocation);
        boolean needsRuntimeCheck = false;
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            TTCN3Template component = this.templates.getTemplateByIndex(i);
            if (!component.checkPresentRestriction(timestamp, definitionName, usageLocation)) continue;
            needsRuntimeCheck = true;
        }
        return needsRuntimeCheck;
    }

    @Override
    protected String getNameForStringRep() {
        return "";
    }

    @Override
    public boolean needsTemporaryReference() {
        return true;
    }

    @Override
    public boolean hasSingleExpression() {
        return false;
    }

    @Override
    public StringBuilder getSingleExpression(JavaGenData aData, boolean castIsNeeded) {
        StringBuilder result = new StringBuilder();
        ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while processing value list template `" + this.getFullName() + "''"));
        return result;
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        for (int i = 0; i < this.templates.getNofTemplates(); ++i) {
            this.templates.getTemplateByIndex(i).reArrangeInitCode(aData, source, usageModule);
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        aData.addBuiltinTypeImport("Base_Template.template_sel");
        ArrayList<Integer> variables = new ArrayList<Integer>();
        long fixedPart = 0L;
        for (int i = 0; i < this.templates.getNofTemplates(); ++i) {
            TTCN3Template templateListItem = this.templates.getTemplateByIndex(i);
            if (templateListItem.getTemplatetype() == ITTCN3Template.Template_type.ALL_FROM) {
                variables.add(i);
                continue;
            }
            ++fixedPart;
        }
        String typeName = this.myGovernor.getGenNameTemplate(aData, source);
        if (variables.size() > 0) {
            StringBuilder preamble = new StringBuilder();
            StringBuilder setType = new StringBuilder();
            StringBuilder[] variableReferences = new StringBuilder[this.templates.getNofTemplates()];
            setType.append(MessageFormat.format("{0}.set_type(template_sel.VALUE_LIST, {1}", name, fixedPart));
            for (int v = 0; v < variables.size(); ++v) {
                TTCN3Template template = this.templates.getTemplateByIndex((Integer)variables.get(v));
                if (template instanceof All_From_Template) {
                    template = ((All_From_Template)template).getAllFrom();
                }
                Reference reference = ((SpecificValue_Template)template).getReference();
                Assignment assignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                setType.append(" + ");
                ExpressionStruct expression = new ExpressionStruct();
                reference.generateConstRef(aData, expression);
                if (expression.preamble.length() > 0) {
                    preamble.append((CharSequence)expression.preamble);
                }
                switch (assignment.getAssignmentType()) {
                    case A_CONST: 
                    case A_EXT_CONST: 
                    case A_MODULEPAR: 
                    case A_VAR: 
                    case A_PAR_VAL: 
                    case A_PAR_VAL_IN: 
                    case A_PAR_VAL_OUT: 
                    case A_PAR_VAL_INOUT: 
                    case A_FUNCTION_RVAL: 
                    case A_EXT_FUNCTION_RVAL: {
                        if (!assignment.getType(CompilationTimeStamp.getBaseTimestamp()).fieldIsOptional(reference.getSubreferences())) break;
                        expression.expression.append(".constGet()");
                        break;
                    }
                }
                variableReferences[((Integer)variables.get((int)v)).intValue()] = expression.expression;
                setType.append((CharSequence)expression.expression);
                setType.append(".n_elem()");
            }
            source.append((CharSequence)preamble);
            source.append((CharSequence)setType);
            source.append(");\n");
            StringBuilder shifty = new StringBuilder();
            block8: for (int i = 0; i < this.templates.getNofTemplates(); ++i) {
                TTCN3Template template = this.templates.getTemplateByIndex(i);
                switch (template.getTemplatetype()) {
                    case ALL_FROM: {
                        StringBuilder storedExpression = variableReferences[i];
                        source.append(MessageFormat.format("for (int i_i = 0, i_lim = {0}.n_elem(); i_i < i_lim; ++i_i ) '{'\n", storedExpression));
                        String embeddedName = MessageFormat.format("{0}.list_item({1}{2} + i_i)", name, i, shifty);
                        ((All_From_Template)template).generateCodeInitAllFrom(aData, source, embeddedName, storedExpression);
                        source.append("}\n");
                        shifty.append(MessageFormat.format("-1 + {0}.n_elem()", storedExpression));
                        continue block8;
                    }
                    default: {
                        if (template.needsTemporaryReference()) {
                            String tempId = aData.getTemporaryVariableName();
                            source.append("{\n");
                            source.append(MessageFormat.format("final {0} {1} = {2}.list_item({3}{4});\n", typeName, tempId, name, i, shifty));
                            template.generateCodeInit(aData, source, tempId);
                            source.append("}\n");
                            continue block8;
                        }
                        String embeddedName = MessageFormat.format("{0}.list_item({1}{2})", name, i, shifty);
                        template.generateCodeInit(aData, source, embeddedName);
                    }
                }
            }
        } else {
            source.append(MessageFormat.format("{0}.set_type(template_sel.VALUE_LIST, {1});\n", name, this.templates.getNofTemplates()));
            for (int i = 0; i < this.templates.getNofTemplates(); ++i) {
                TTCN3Template template = this.templates.getTemplateByIndex(i);
                if (template.needsTemporaryReference()) {
                    String tempId = aData.getTemporaryVariableName();
                    source.append("{\n");
                    source.append(MessageFormat.format("final {0} {1} = {2}.list_item({3});\n", typeName, tempId, name, i));
                    template.generateCodeInit(aData, source, tempId);
                    source.append("}\n");
                    continue;
                }
                String embeddedName = MessageFormat.format("{0}.list_item({1})", name, i);
                template.generateCodeInit(aData, source, embeddedName);
            }
        }
        if (this.lengthRestriction != null) {
            if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            }
            this.lengthRestriction.generateCodeInit(aData, source, name);
        }
        if (this.isIfpresent) {
            source.append(name);
            source.append(".set_ifPresent();\n");
        }
    }
}

