/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.BridgingNamedNode;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValues;
import org.eclipse.titan.designer.AST.TTCN3.values.Omit_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Set_Value
extends Value {
    private static final String NONEXISTENTFIELD = "Reference to non-existent set field `{0}'' in type `{1}''";
    private final NamedValues values;

    public Set_Value(NamedValues values) {
        this.values = values;
        if (values != null) {
            values.setFullNameParent(this);
        }
    }

    public Set_Value(Sequence_Value original) {
        this.copyGeneralProperties(original);
        this.values = original.getValues();
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.SET_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("{");
        boolean isAsn1 = this.isAsn();
        for (int i = 0; i < this.values.getSize(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            NamedValue namedValue = this.values.getNamedValueByIndex(i);
            builder.append(namedValue.getName().getDisplayName());
            if (isAsn1) {
                builder.append(' ');
            } else {
                builder.append(" := ");
            }
            builder.append(namedValue.getValue().createStringRepresentation());
        }
        builder.append('}');
        return builder.toString();
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return null;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Identifier fieldId = ((FieldSubReference)subreference).getId();
                switch (type.getTypetype()) {
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Type)type).hasComponentWithName(fieldId.getName())) break;
                        subreference.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTFIELD, fieldId.getDisplayName(), type.getTypename()));
                        return null;
                    }
                    case TYPE_ASN1_SET: {
                        if (((ASN1_Set_Type)type).hasComponentWithName(fieldId)) break;
                        subreference.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTFIELD, fieldId.getDisplayName(), type.getTypename()));
                        return null;
                    }
                    default: {
                        return null;
                    }
                }
                if (this.values.hasNamedValueWithName(fieldId)) {
                    return this.values.getNamedValueByName(fieldId).getValue().getReferencedSubValue(timestamp, reference, actualSubReference + 1, refChain);
                }
                if (IType.Type_type.TYPE_TTCN3_SET.equals((Object)type.getTypetype())) {
                    if (!reference.getUsedInIsbound()) {
                        subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to unbound set field `{0}''", fieldId.getDisplayName()));
                    }
                    return null;
                }
                CompField compField = ((ASN1_Sequence_Type)type).getComponentByName(fieldId);
                if (compField.isOptional()) {
                    Omit_Value result = new Omit_Value();
                    BridgingNamedNode bridge = new BridgingNamedNode(this, "." + fieldId.getDisplayName());
                    result.setFullNameParent(bridge);
                    result.setMyScope(this.getMyScope());
                    return ((Value)result).getReferencedSubValue(timestamp, reference, actualSubReference + 1, refChain);
                }
                if (compField.hasDefault()) {
                    return compField.getDefault().getReferencedSubValue(timestamp, reference, actualSubReference + 1, refChain);
                }
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.values == null) {
            return true;
        }
        for (int i = 0; i < this.values.getSize(); ++i) {
            if (!this.values.getNamedValueByIndex(i).getValue().isUnfoldable(timestamp, expectedValue, referenceChain)) continue;
            return true;
        }
        return false;
    }

    public void addNamedValue(NamedValue value) {
        if (value != null) {
            this.values.addNamedValue(value);
            value.setMyScope(this.myScope);
        }
    }

    public void removeGeneratedValues() {
        if (this.values != null) {
            this.values.removeGeneratedValues();
        }
    }

    public int getNofComponents() {
        return this.values.getSize();
    }

    public NamedValue getSequenceValueByIndex(int index) {
        if (this.values == null) {
            return null;
        }
        return this.values.getNamedValueByIndex(index);
    }

    public boolean hasComponentWithName(Identifier name) {
        if (this.values == null) {
            return false;
        }
        return this.values.hasNamedValueWithName(name);
    }

    public NamedValue getComponentByName(Identifier name) {
        if (this.values == null) {
            return null;
        }
        return this.values.getNamedValueByName(name);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.values != null) {
            this.values.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.values != null) {
            this.values.setCodeSection(codeSection);
        }
    }

    public void checkUniqueness(CompilationTimeStamp timestamp) {
        if (this.values == null) {
            return;
        }
        this.values.checkUniqueness(timestamp);
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            int size = this.values.getSize();
            for (int i = 0; i < size; ++i) {
                IValue temp = this.values.getNamedValueByIndex(i).getValue();
                if (temp == null) continue;
                referenceChain.markState();
                temp.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (!IValue.Value_type.SET_VALUE.equals((Object)last.getValuetype())) {
            return false;
        }
        if (this.myGovernor == null) {
            return false;
        }
        Set_Value otherSet = (Set_Value)last;
        if (this.values.getSize() != otherSet.values.getSize()) {
            return false;
        }
        int nofComps = 0;
        IType leftGovernor = this.myGovernor.getTypeRefdLast(timestamp);
        switch (leftGovernor.getTypetype()) {
            case TYPE_TTCN3_SET: {
                nofComps = ((TTCN3_Set_Type)leftGovernor).getNofComponents();
                break;
            }
            case TYPE_ASN1_SET: {
                nofComps = ((ASN1_Set_Type)leftGovernor).getNofComponents();
                break;
            }
            default: {
                return false;
            }
        }
        CompField compField = null;
        for (int i = 0; i < nofComps; ++i) {
            switch (leftGovernor.getTypetype()) {
                case TYPE_TTCN3_SET: {
                    compField = ((TTCN3_Set_Type)leftGovernor).getComponentByIndex(i);
                    break;
                }
                case TYPE_ASN1_SET: {
                    compField = ((ASN1_Set_Type)leftGovernor).getComponentByIndex(i);
                    break;
                }
                default: {
                    return false;
                }
            }
            Identifier fieldName = compField.getIdentifier();
            if (this.hasComponentWithName(fieldName)) {
                IValue leftValue = this.getComponentByName(fieldName).getValue();
                if (otherSet.hasComponentWithName(fieldName)) {
                    IValue otherValue = otherSet.getComponentByName(fieldName).getValue();
                    if (IValue.Value_type.OMIT_VALUE.equals((Object)leftValue.getValuetype()) && !IValue.Value_type.OMIT_VALUE.equals((Object)otherValue.getValuetype()) || !IValue.Value_type.OMIT_VALUE.equals((Object)leftValue.getValuetype()) && IValue.Value_type.OMIT_VALUE.equals((Object)otherValue.getValuetype())) {
                        return false;
                    }
                    if (leftValue.checkEquality(timestamp, otherValue)) continue;
                    return false;
                }
                if (!(compField.hasDefault() ? !leftValue.checkEquality(timestamp, compField.getDefault()) : !IValue.Value_type.OMIT_VALUE.equals((Object)leftValue.getValuetype()))) continue;
                return false;
            }
            if (!otherSet.hasComponentWithName(fieldName)) continue;
            IValue otherValue = otherSet.getComponentByName(fieldName).getValue();
            if (!compField.hasDefault()) continue;
            if (IValue.Value_type.OMIT_VALUE.equals((Object)otherValue.getValuetype())) {
                return false;
            }
            if (compField.getDefault().checkEquality(timestamp, otherValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.values != null) {
            this.values.updateSyntax(reparser, false);
        }
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        if (this.values == null) {
            return true;
        }
        int size = this.values.getSize();
        for (int i = 0; i < size; ++i) {
            if (this.values.getNamedValueByIndex(i).getValue().evaluateIsvalue(true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluateIsbound(CompilationTimeStamp timestamp, Reference reference, int actualSubReference) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return true;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return false;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                return false;
            }
            case fieldSubReference: {
                Identifier fieldId = ((FieldSubReference)subreference).getId();
                switch (type.getTypetype()) {
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Type)type).hasComponentWithName(fieldId.getName())) break;
                        return false;
                    }
                    case TYPE_ASN1_SET: {
                        if (((ASN1_Set_Type)type).hasComponentWithName(fieldId)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                if (this.values.hasNamedValueWithName(fieldId)) {
                    return this.values.getNamedValueByName(fieldId).getValue().evaluateIsbound(timestamp, reference, actualSubReference + 1);
                }
                if (IType.Type_type.TYPE_TTCN3_SET.equals((Object)type.getTypetype())) {
                    return false;
                }
                CompField compField = ((ASN1_Set_Type)type).getComponentByName(fieldId);
                if (compField.isOptional()) {
                    Omit_Value result = new Omit_Value();
                    BridgingNamedNode bridge = new BridgingNamedNode(this, "." + fieldId.getDisplayName());
                    result.setFullNameParent(bridge);
                    result.setMyScope(this.getMyScope());
                    return result.evaluateIsbound(timestamp, reference, actualSubReference + 1);
                }
                if (compField.hasDefault()) {
                    return compField.getDefault().evaluateIsbound(timestamp, reference, actualSubReference + 1);
                }
                return false;
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean evaluateIspresent(CompilationTimeStamp timestamp, Reference reference, int actualSubReference) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return true;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return false;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                return false;
            }
            case fieldSubReference: {
                Identifier fieldId = ((FieldSubReference)subreference).getId();
                switch (type.getTypetype()) {
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Type)type).hasComponentWithName(fieldId.getName())) break;
                        return false;
                    }
                    case TYPE_ASN1_SET: {
                        if (((ASN1_Set_Type)type).hasComponentWithName(fieldId)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                if (this.values.hasNamedValueWithName(fieldId)) {
                    return this.values.getNamedValueByName(fieldId).getValue().evaluateIspresent(timestamp, reference, actualSubReference + 1);
                }
                if (IType.Type_type.TYPE_TTCN3_SET.equals((Object)type.getTypetype())) {
                    return false;
                }
                CompField compField = ((ASN1_Set_Type)type).getComponentByName(fieldId);
                if (compField.isOptional()) {
                    Omit_Value result = new Omit_Value();
                    BridgingNamedNode bridge = new BridgingNamedNode(this, "." + fieldId.getDisplayName());
                    result.setFullNameParent(bridge);
                    result.setMyScope(this.getMyScope());
                    return ((Value)result).evaluateIspresent(timestamp, reference, actualSubReference + 1);
                }
                if (compField.hasDefault()) {
                    return compField.getDefault().evaluateIspresent(timestamp, reference, actualSubReference + 1);
                }
                return false;
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        NamedValue nv;
        IType governorLast;
        if (this.values == null) {
            return;
        }
        if (referenceFinder.assignment.getAssignmentType() == Assignment.Assignment_type.A_TYPE && referenceFinder.fieldId != null && this.myGovernor != null && referenceFinder.type == (governorLast = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp())) && (nv = this.values.getNamedValueByName(referenceFinder.fieldId)) != null) {
            foundIdentifiers.add(new ReferenceFinder.Hit(nv.getName()));
        }
        this.values.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.values == null || this.values.accept(v);
    }

    @Override
    public void setGenNamePrefix(String prefix) {
        super.setGenNamePrefix(prefix);
        for (int i = 0; i < this.values.getSize(); ++i) {
            this.values.getNamedValueByIndex(i).getValue().setGenNamePrefix(prefix);
        }
    }

    @Override
    public void setGenNameRecursive(String parameterGenName) {
        super.setGenNameRecursive(parameterGenName);
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            governor = this.myLastSetGovernor;
        }
        if (governor == null) {
            return;
        }
        IType type = governor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (IType.Type_type.TYPE_TTCN3_SET.equals((Object)type.getTypetype())) {
            for (int i = 0; i < this.values.getSize(); ++i) {
                IValue v;
                NamedValue namedValue = this.values.getNamedValueByIndex(i);
                String name = namedValue.getName().getName();
                if (!((TTCN3_Set_Type)type).hasComponentWithName(name)) continue;
                StringBuilder embeddedName = new StringBuilder();
                embeddedName.append(MessageFormat.format("{0}.get_field_{1}()", parameterGenName, name));
                if (((TTCN3_Set_Type)type).getComponentByName(name).isOptional()) {
                    embeddedName.append(".get()");
                }
                if ((v = namedValue.getValue()) == null) continue;
                v.setGenNameRecursive(embeddedName.toString());
            }
        }
    }

    @Override
    public boolean needsTemporaryReference() {
        if (this.isAsn()) {
            IType lastType = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            return ((ASN1_Set_Type)lastType).getNofComponents() > 1;
        }
        for (int i = 0; i < this.values.getSize(); ++i) {
            IValue value = this.values.getNamedValueByIndex(i).getValue();
            if (value.getValuetype() == IValue.Value_type.NOTUSED_VALUE || !value.needsTemporaryReference()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        if (this.values == null) {
            return false;
        }
        return this.values.getSize() == 0;
    }

    @Override
    public StringBuilder generateSingleExpression(JavaGenData aData) {
        aData.addBuiltinTypeImport("TitanNull_Type");
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            governor = this.myLastSetGovernor;
        }
        aData.addBuiltinTypeImport("TitanNull_Type");
        if (governor == null) {
            return new StringBuilder("TitanNull_Type.NULL_VALUE");
        }
        StringBuilder result = new StringBuilder();
        String genName = governor.getGenNameValue(aData, result);
        result.append(MessageFormat.format("new {0}(TitanNull_Type.NULL_VALUE)", genName));
        return result;
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            governor = this.myLastSetGovernor;
        }
        IType type = governor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        int nofComps = 0;
        switch (type.getTypetype()) {
            case TYPE_TTCN3_SET: {
                nofComps = ((TTCN3_Set_Type)type).getNofComponents();
                break;
            }
            case TYPE_ASN1_SET: {
                nofComps = ((ASN1_Set_Type)type).getNofComponents();
                break;
            }
            case TYPE_TTCN3_CHOICE: {
                nofComps = ((TTCN3_Choice_Type)type).getNofComponents();
                break;
            }
            case TYPE_ASN1_CHOICE: {
                nofComps = ((ASN1_Choice_Type)type).getNofComponents();
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for value `" + this.getFullName() + "''"));
            }
        }
        if (nofComps == 0) {
            aData.addBuiltinTypeImport("TitanNull_Type");
            source.append(MessageFormat.format("{0}.operator_assign(TitanNull_Type.NULL_VALUE);\n", name));
            this.lastTimeGenerated = aData.getBuildTimstamp();
            return source;
        }
        CompField compField = null;
        for (int i = 0; i < nofComps; ++i) {
            IValue fieldValue;
            switch (type.getTypetype()) {
                case TYPE_TTCN3_SET: {
                    compField = ((TTCN3_Set_Type)type).getComponentByIndex(i);
                    break;
                }
                case TYPE_ASN1_SET: {
                    compField = ((ASN1_Set_Type)type).getComponentByIndex(i);
                    break;
                }
                case TYPE_TTCN3_CHOICE: {
                    compField = ((TTCN3_Choice_Type)type).getComponentByIndex(i);
                    break;
                }
                case TYPE_ASN1_CHOICE: {
                    compField = ((ASN1_Choice_Type)type).getComponentByIndex(i);
                    break;
                }
                default: {
                    ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for value `" + this.getFullName() + "''"));
                }
            }
            Identifier fieldName = compField.getIdentifier();
            if (this.hasComponentWithName(fieldName)) {
                fieldValue = this.getComponentByName(fieldName).getValue();
                if (IValue.Value_type.NOTUSED_VALUE.equals((Object)fieldValue.getValuetype())) continue;
                if (IValue.Value_type.OMIT_VALUE.equals((Object)fieldValue.getValuetype())) {
                    fieldValue = null;
                }
            } else {
                if (!this.isAsn()) continue;
                if (compField.hasDefault()) {
                    Value defaultValue = compField.getDefault();
                    if (this.needsInitPrecede(aData, defaultValue)) {
                        defaultValue.generateCodeInit(aData, source, defaultValue.get_lhs_name());
                    }
                    source.append(MessageFormat.format("{0}.get_field_{1}().operator_assign({2});\n", name, fieldName, defaultValue.getGenNameOwn(aData)));
                    continue;
                }
                fieldValue = null;
            }
            String javaGetterName = FieldSubReference.getJavaGetterName(fieldName.getName());
            if (fieldValue != null) {
                if (fieldValue.needsTemporaryReference()) {
                    String tempId = aData.getTemporaryVariableName();
                    source.append("{\n");
                    String embeddedTypeName = compField.getType().getGenNameValue(aData, source);
                    source.append(MessageFormat.format("{0} {1} = {2}.get_field_{3}()", embeddedTypeName, tempId, name, javaGetterName));
                    if (compField.isOptional()) {
                        source.append(".get()");
                    }
                    source.append(";\n");
                    fieldValue.generateCodeInit(aData, source, tempId);
                    source.append("}\n");
                    continue;
                }
                StringBuilder embeddedName = new StringBuilder();
                embeddedName.append(MessageFormat.format("{0}.get_field_{1}()", name, javaGetterName));
                if (compField.isOptional()) {
                    embeddedName.append(".get()");
                }
                fieldValue.generateCodeInit(aData, source, embeddedName.toString());
                continue;
            }
            aData.addBuiltinTypeImport("Base_Template.template_sel");
            source.append(MessageFormat.format("{0}.get_field_{1}().operator_assign(template_sel.OMIT_VALUE);\n", name, javaGetterName));
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        return source;
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, boolean forceObject) {
        if (this.canGenerateSingleExpression()) {
            expression.expression.append((CharSequence)this.generateSingleExpression(aData));
            return;
        }
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            governor = this.myLastSetGovernor;
        }
        String tempId = aData.getTemporaryVariableName();
        String genName = governor.getGenNameValue(aData, expression.expression);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", genName, tempId));
        this.setGenNamePrefix(tempId);
        this.generateCodeInit(aData, expression.preamble, tempId);
        expression.expression.append(tempId);
    }
}

