/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.Boolean_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class OfClassExpression
extends Expression_Value {
    private static final String CLASSREFERENCEEXPECTED = "Reference to a class object was expected";
    private static final String CLASSTYPEEXPECTED = "Class type was expected";
    private final Type type;
    private final Reference reference;
    private boolean value;

    public OfClassExpression(Type type, Reference reference) {
        this.type = type;
        this.reference = reference;
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.CLASS_OF_OPERATION;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.reference == null || this.type == null) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        if (!this.isUnfoldable(timestamp)) {
            this.value = false;
        }
        return this.lastValue;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.reference != null) {
            this.reference.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference.getLocation());
        }
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        Class_Type expectedClass;
        Class_Type refClass = this.reference.checkVariableReference(timestamp).getTypeRefdLast(timestamp).getClassType();
        return refClass.isParentClass(timestamp, expectedClass = this.type.getTypeRefdLast(timestamp).getClassType()) || expectedClass.isParentClass(timestamp, refClass);
    }

    @Override
    public boolean checkExpressionSelfReferenceValue(CompilationTimeStamp timestamp, Assignment lhs) {
        if (lhs != null) {
            Assignment assignment = this.reference.getRefdAssignment(timestamp, false);
            return assignment == lhs;
        }
        return false;
    }

    @Override
    public String createStringRepresentation() {
        return this.reference.getDisplayName() + " of " + this.type.getTypename();
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BOOL;
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        return new Boolean_Type();
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.reference == null || this.reference.accept(v);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IType typeRefdLast = null;
        IType refType = this.reference.checkVariableReference(timestamp);
        if (refType != null) {
            typeRefdLast = refType.getTypeRefdLast(timestamp);
            if (typeRefdLast.getTypetype() != IType.Type_type.TYPE_CLASS) {
                this.reference.getLocation().reportSemanticError(CLASSREFERENCEEXPECTED);
                this.setIsErroneous(true);
            }
        } else {
            this.setIsErroneous(true);
        }
        this.type.check(timestamp);
        IType typeLast = this.type.getTypeRefdLast(timestamp);
        if (typeLast.getTypetype() != IType.Type_type.TYPE_CLASS) {
            this.type.getLocation().reportSemanticError(CLASSTYPEEXPECTED);
            this.setIsErroneous(true);
        }
    }
}

