/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.designer.actions.ExternalTitanAction;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANInstallationValidator;
import org.eclipse.titan.designer.core.TITANJob;
import org.eclipse.titan.designer.license.LicenseValidator;

public final class CheckVersion
extends ExternalTitanAction {
    private static final String JOB_TITLE = "Version check";
    private static final String DOT = ".";

    public void run(IAction action) {
        this.doCheckVersion();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doCheckVersion();
        return null;
    }

    private void doCheckVersion() {
        if (!TITANInstallationValidator.check(true)) {
            return;
        }
        if (!LicenseValidator.check()) {
            return;
        }
        this.processSelection();
        TITANJob titanJob = new TITANJob(JOB_TITLE, new HashMap<String, IFile>(), new File(DOT), this.project);
        titanJob.setPriority(50);
        titanJob.setUser(true);
        titanJob.setRule((ISchedulingRule)this.project);
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        ArrayList<String> command = new ArrayList<String>();
        StringBuilder output = new StringBuilder();
        command.add(PathConverter.convert((String)this.getCompilerPath().toOSString(), (boolean)reportDebugInformation, (StringBuilder)output));
        TITANDebugConsole.println(output);
        command.add("-v");
        titanJob.addCommand(command, JOB_TITLE);
        titanJob.schedule();
    }
}

