/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions.runconfiggenerator;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.path.PathUtil;

public class FileNameDialog
extends TitleAreaDialog {
    private static final String SHELL_TEXT = "Save run configuration for Eclipse Titan";
    private static final String TITLE_TEXT = "You can save the run configration for {0} mode";
    private static final String HELP_TEXT = "Give name for the run configuration";
    private static final String ERROR_TEXT = "Invalid file name";
    private static final String LABEL_TEXT = "File name: ";
    private static final String OVERWRITE_TEXT = "Overwrite if exists?";
    private Text fileNameText;
    private Button overwriteButton;
    private String selectedFileName = "";
    private String defaultFileName = "";
    private boolean isOverwite = false;
    private boolean mode = false;

    public FileNameDialog(Shell parent) {
        super(parent);
        this.setHelpAvailable(false);
    }

    public void create() {
        super.create();
        this.setTitle(MessageFormat.format(TITLE_TEXT, this.mode ? "parallel" : "single"));
        this.setMessage(HELP_TEXT, 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.createFileNameText(container);
        this.createOverwriteCheckBox(container);
        return area;
    }

    protected Point getInitialSize() {
        return new Point(500, 300);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(SHELL_TEXT);
    }

    private void createFileNameText(Composite container) {
        Label fileNameLabel = new Label(container, 0);
        fileNameLabel.setText(LABEL_TEXT);
        GridData dataFileName = new GridData();
        dataFileName.grabExcessHorizontalSpace = true;
        dataFileName.horizontalAlignment = 4;
        this.fileNameText = new Text(container, 2048);
        this.fileNameText.setLayoutData((Object)dataFileName);
        this.fileNameText.setText(this.defaultFileName);
        this.fileNameText.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                String string = FileNameDialog.this.fileNameText.getText();
                Button okButton = FileNameDialog.this.getButton(0);
                if (!PathUtil.isValidFileName((String)string)) {
                    FileNameDialog.this.setMessage(FileNameDialog.ERROR_TEXT, 3);
                    if (okButton != null) {
                        okButton.setEnabled(false);
                    }
                } else {
                    FileNameDialog.this.setMessage(FileNameDialog.HELP_TEXT, 1);
                    if (okButton != null) {
                        okButton.setEnabled(true);
                    }
                }
            }
        });
    }

    private void createOverwriteCheckBox(Composite container) {
        this.overwriteButton = new Button(container, 32);
        this.overwriteButton.setText(OVERWRITE_TEXT);
    }

    protected boolean isResizable() {
        return true;
    }

    public void setDefaultFileName(String defaultFileName) {
        this.defaultFileName = defaultFileName;
    }

    public String getDefaultFileName() {
        return this.defaultFileName;
    }

    private void saveInput() {
        this.selectedFileName = this.fileNameText.getText();
        this.isOverwite = this.overwriteButton.getSelection();
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public String getFirstName() {
        return this.selectedFileName;
    }

    public boolean getOverwrite() {
        return this.isOverwite;
    }

    public boolean getMode() {
        return this.mode;
    }

    public void setMode(boolean mode) {
        this.mode = mode;
    }
}

