/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.common.utils.Cygwin;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.license.License;
import org.eclipse.titan.designer.license.LicenseValidator;

public final class CompilerVersionInformationCollector {
    private static final String TTCN3_LICENSE_FILE_KEY = "TTCN3_LICENSE_FILE";
    private static final String TTCN3_DIR_KEY = "TTCN3_DIR";
    private static final String LD_LIBRARY_PATH_KEY = "LD_LIBRARY_PATH";
    private static final String LIBRARY_SUB_DIR = "/lib";
    public static final String VERSION_CHECK_FLAG = "v";
    public static final String COMPILER_SUBPATH = File.separatorChar + "bin" + File.separatorChar + "compiler";
    private static final String SPACE = " ";
    private static final String SUCCESS = "Operation finished successfully.";
    private static final String FAILURE = "Operation failed with return value: ";
    private static final Pattern BASE_TITAN_HEADER_PATTERN = Pattern.compile("TTCN\\-3 and ASN\\.1 Compiler for the TTCN\\-3 Test Executor, version (.+)\\nProduct number: (.+)\\nBuild date: (.+)\\nCompiled with: ([^\\n]+)\\n?\\n(.+)", 40);
    private static final Pattern BASE_TITAN_HEADER_PATTERN2 = Pattern.compile("TTCN\\-3 and ASN\\.1 Compiler for the TTCN\\-3 Test Executor\\nProduct number: (.+)\\nVersion: (.+)\\nBuild date: (.+)\\nCompiled with: ([^\\n]+)\\n?\\n(.+)", 40);
    private static final Pattern BASE_TITAN_HEADER_PATTERN3 = Pattern.compile("TTCN\\-3 and ASN\\.1 Compiler for the TTCN\\-3 Test Executor\\nProduct number: (.+)\\nBuild date: (.+)\\nCompiled with: ([^\\n]+)\\n?\\n(.+)", 40);
    private static final Pattern BASE_TITAN_HEADER_PATTERN4 = Pattern.compile("TTCN\\-3 and ASN\\.1 Compiler for the TTCN\\-3 Test Executor\\nVersion: (.+)\\nBuild date: (.+)\\nCompiled with: ([^\\n]+)\\n?\\n(.+)", 40);
    private static String resolvedInstallationPath = "";
    private static CompilerInfoStruct compilerInfoStruct;
    private static boolean infoIsUptodate;

    private CompilerVersionInformationCollector() {
    }

    public static String getCompilerProductNumber() {
        if (!infoIsUptodate) {
            CompilerVersionInformationCollector.collectInformation();
        }
        if (compilerInfoStruct == null) {
            return null;
        }
        return CompilerVersionInformationCollector.compilerInfoStruct.compilerProductNumber;
    }

    public static String getBuildDate() {
        if (!infoIsUptodate) {
            CompilerVersionInformationCollector.collectInformation();
        }
        if (compilerInfoStruct == null) {
            return null;
        }
        return CompilerVersionInformationCollector.compilerInfoStruct.buildDate;
    }

    public static String getCCompilerVersion() {
        if (!infoIsUptodate) {
            CompilerVersionInformationCollector.collectInformation();
        }
        if (compilerInfoStruct == null) {
            return null;
        }
        return CompilerVersionInformationCollector.compilerInfoStruct.cCompilerVersion;
    }

    public static String getCommandOutput() {
        if (!infoIsUptodate) {
            CompilerVersionInformationCollector.collectInformation();
        }
        if (compilerInfoStruct == null) {
            return null;
        }
        return CompilerVersionInformationCollector.compilerInfoStruct.commandOutput;
    }

    private static void setEnvironmentalVariables(ProcessBuilder pb, String path) {
        Map<String, String> env = pb.environment();
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        StringBuilder output = new StringBuilder();
        String ttcn3Dir = PathConverter.convert((String)path, (boolean)reportDebugInformation, (StringBuilder)output);
        TITANDebugConsole.println(output);
        if (License.isLicenseNeeded()) {
            env.put(TTCN3_LICENSE_FILE_KEY, LicenseValidator.getResolvedLicenseFilePath(false));
        }
        env.put(TTCN3_DIR_KEY, ttcn3Dir);
        String temp = env.get(LD_LIBRARY_PATH_KEY);
        if (temp == null) {
            env.put(LD_LIBRARY_PATH_KEY, ttcn3Dir + LIBRARY_SUB_DIR);
        } else {
            env.put(LD_LIBRARY_PATH_KEY, temp + ":" + ttcn3Dir + LIBRARY_SUB_DIR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompilerInfoStruct collectVersionInformation(String path) {
        Matcher baseTITANErrorMatcher4;
        Matcher baseTITANErrorMatcher3;
        Matcher baseTITANErrorMatcher2;
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        if ("win32".equals(Platform.getOS()) && !Cygwin.isInstalled()) {
            return null;
        }
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        ArrayList<String> command = new ArrayList<String>();
        StringBuilder output = new StringBuilder();
        command.add(PathConverter.convert((String)new Path(path + COMPILER_SUBPATH).toOSString(), (boolean)reportDebugInformation, (StringBuilder)output));
        TITANDebugConsole.println(output);
        command.add("-v");
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        CompilerVersionInformationCollector.setEnvironmentalVariables(pb, path);
        pb.redirectErrorStream(true);
        Process proc = null;
        StringBuilder tempCommand = new StringBuilder();
        for (String c : command) {
            tempCommand.append(c).append(SPACE);
        }
        ArrayList<String> finalCommand = new ArrayList<String>();
        finalCommand.add("sh");
        finalCommand.add("-c");
        finalCommand.add(tempCommand.toString());
        StringBuilder readLines = new StringBuilder();
        pb.command(finalCommand);
        try {
            proc = pb.start();
        }
        catch (IOException e) {
            TITANConsole.println("execution failed");
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return null;
        }
        BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        CompilerInfoStruct temp = new CompilerInfoStruct();
        try {
            int linesRead = 0;
            String line = stdout.readLine();
            while (line != null) {
                if (++linesRead < 30) {
                    readLines.append(line).append('\n');
                } else if (linesRead > 100) {
                    CompilerInfoStruct compilerInfoStruct = null;
                    return compilerInfoStruct;
                }
                if (reportDebugInformation) {
                    TITANConsole.println(line);
                }
                line = stdout.readLine();
            }
            int exitval = proc.waitFor();
            if (exitval != 0) {
                if (reportDebugInformation) {
                    TITANConsole.println(FAILURE + exitval);
                }
                proc.destroy();
                temp.commandOutput = readLines.toString();
                CompilerInfoStruct e = temp;
                return e;
            }
            if (reportDebugInformation) {
                TITANConsole.println(SUCCESS);
            }
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        finally {
            try {
                stdout.close();
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        temp.commandOutput = readLines.toString();
        Matcher baseTITANErrorMatcher = BASE_TITAN_HEADER_PATTERN.matcher(temp.commandOutput);
        if (baseTITANErrorMatcher.matches()) {
            temp.compilerVersion = baseTITANErrorMatcher.group(1);
            temp.compilerProductNumber = baseTITANErrorMatcher.group(2);
            temp.buildDate = baseTITANErrorMatcher.group(3);
            temp.cCompilerVersion = baseTITANErrorMatcher.group(4);
        }
        if ((baseTITANErrorMatcher2 = BASE_TITAN_HEADER_PATTERN2.matcher(readLines.toString())).matches()) {
            temp.compilerProductNumber = baseTITANErrorMatcher2.group(1);
            temp.compilerVersion = baseTITANErrorMatcher2.group(2);
            temp.buildDate = baseTITANErrorMatcher2.group(3);
            temp.cCompilerVersion = baseTITANErrorMatcher2.group(4);
        }
        if ((baseTITANErrorMatcher3 = BASE_TITAN_HEADER_PATTERN3.matcher(readLines.toString())).matches()) {
            temp.compilerProductNumber = baseTITANErrorMatcher3.group(1);
            temp.buildDate = baseTITANErrorMatcher3.group(2);
            temp.cCompilerVersion = baseTITANErrorMatcher3.group(3);
            temp.compilerVersion = null;
        }
        if ((baseTITANErrorMatcher4 = BASE_TITAN_HEADER_PATTERN4.matcher(readLines.toString())).matches()) {
            temp.compilerProductNumber = baseTITANErrorMatcher4.group(1);
            temp.compilerVersion = baseTITANErrorMatcher4.group(1);
            temp.buildDate = baseTITANErrorMatcher4.group(2);
            temp.cCompilerVersion = baseTITANErrorMatcher4.group(3);
        }
        return temp;
    }

    public static String getResolvedInstallationPath(boolean force) {
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        if (force || resolvedInstallationPath.length() == 0) {
            String installationPath = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.TTCN3_INSTALL_DIR", "", null);
            StringBuilder output = new StringBuilder();
            resolvedInstallationPath = PathConverter.convert((String)installationPath, (boolean)reportDebugInformation, (StringBuilder)output);
            TITANDebugConsole.println(output);
        }
        return resolvedInstallationPath;
    }

    public static CompilerInfoStruct checkTemporalLocation(String path) {
        if (path == null) {
            return null;
        }
        return CompilerVersionInformationCollector.collectVersionInformation(path);
    }

    public static void collectInformation() {
        if (compilerInfoStruct != null || infoIsUptodate) {
            return;
        }
        String installationPath = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.TTCN3_INSTALL_DIR", null, null);
        compilerInfoStruct = CompilerVersionInformationCollector.collectVersionInformation(installationPath);
        infoIsUptodate = true;
    }

    public static void clearStoredInformation() {
        compilerInfoStruct = null;
        resolvedInstallationPath = "";
        infoIsUptodate = false;
    }

    static {
        infoIsUptodate = false;
    }

    public static final class CompilerInfoStruct {
        public String compilerProductNumber;
        public String buildDate;
        public String cCompilerVersion;
        public String compilerVersion;
        public String commandOutput;

        private CompilerInfoStruct() {
        }
    }
}

