/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.HeuristicalIntervalDetector;
import org.eclipse.titan.designer.editors.IHeuristicalIntervalDetector;
import org.eclipse.titan.designer.editors.actions.IndentationSupport;

public abstract class GeneralTITANAutoEditStrategy
implements IAutoEditStrategy {
    public static final String EMPTY_STRING = "";
    protected static final String TRUE = "true";
    protected String indentString;
    protected Interval rootInterval;
    protected IHeuristicalIntervalDetector heuristicIntervalDetector;
    protected IPreferenceStore preferenceStore;

    protected final void refreshAutoEditStrategy() {
        this.indentString = IndentationSupport.getIndentString();
        this.preferenceStore = Activator.getDefault().getPreferenceStore();
    }

    protected final void initializeRootInterval(IDocument document) {
        this.rootInterval = GlobalIntervalHandler.getInterval(document);
        if (this.rootInterval == null) {
            this.rootInterval = new HeuristicalIntervalDetector().buildIntervals(document);
            GlobalIntervalHandler.putInterval(document, this.rootInterval);
        }
    }

    public final void setHeuristicIntervalDetector(IHeuristicalIntervalDetector heuristicIntervalDetector) {
        this.heuristicIntervalDetector = heuristicIntervalDetector;
    }

    protected final boolean endsWithDelimiter(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        for (int i = 0; i < delimiters.length; ++i) {
            if (!txt.endsWith(delimiters[i])) continue;
            return true;
        }
        return false;
    }

    protected final int delimiterLength() {
        if ("win32".equals(Platform.getOS())) {
            return 2;
        }
        return 1;
    }

    protected final boolean isWithinMultiLineComment(int offset) {
        Interval interval = this.rootInterval.getSmallestEnclosingInterval(offset);
        return Interval.interval_type.MULTILINE_COMMENT.equals((Object)interval.getType()) && interval.getStartOffset() != offset;
    }

    protected final String getIndentOfLine(IDocument document, int line, DocumentCommand command) throws BadLocationException {
        if (line > -1) {
            int end;
            int start = document.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(document, start, end = start + document.getLineLength(line) - 1);
            if (whiteend > command.offset) {
                whiteend = command.offset;
            }
            return document.get(start, whiteend - start);
        }
        return EMPTY_STRING;
    }

    protected final int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        for (int offset2 = offset; offset2 < end; ++offset2) {
            char c = document.getChar(offset2);
            if (c == ' ' || c == '\t') continue;
            return offset2;
        }
        return end;
    }

    protected final int findMatchingOpenBracket(IDocument document, int end) throws BadLocationException {
        Interval interval = this.rootInterval.getSmallestEnclosingInterval(end);
        return document.getLineOfOffset(interval.getStartOffset());
    }

    protected final boolean containsUnclosedInterval(int start, int end) {
        Interval endInterval = this.rootInterval.getSmallestEnclosingInterval(end);
        return endInterval.getStartOffset() >= start && Interval.interval_type.NORMAL.equals((Object)endInterval.getType());
    }

    protected final boolean containsUnopenedInterval(int start, int end) {
        Interval startInterval = this.rootInterval.getSmallestEnclosingInterval(start);
        return startInterval.getEndOffset() <= end && Interval.interval_type.NORMAL.equals((Object)startInterval.getType());
    }

    protected final boolean canStatementBlockBeOpen(IDocument document, int start) {
        Interval interval = this.rootInterval.getSmallestEnclosingInterval(start);
        if (!Interval.interval_type.NORMAL.equals((Object)interval.getType())) {
            return false;
        }
        while (!this.rootInterval.equals(interval)) {
            if (interval.getErroneous()) {
                return true;
            }
            interval = interval.getParent();
        }
        return false;
    }

    protected final boolean isWithinString(StringBuilder document, int offset) throws BadLocationException {
        if (this.heuristicIntervalDetector != null) {
            this.heuristicIntervalDetector.isWithinString(document, offset, this.rootInterval);
        }
        return false;
    }
}

