/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.ListConverter;
import org.eclipse.titan.designer.properties.pages.IOptionsPage;
import org.eclipse.titan.designer.properties.pages.MyFolderListControl;
import org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage;

public final class PreprocessorIncludedOptionsPage
implements IOptionsPage {
    private final boolean preprocessor;
    private final IProject project;
    private Composite mainComposite;
    private MyFolderListControl includes;

    public PreprocessorIncludedOptionsPage(IProject project, boolean preprocessor) {
        this.project = project;
        this.preprocessor = preprocessor;
    }

    @Override
    public void dispose() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
            this.mainComposite = null;
            this.includes.dispose();
        }
    }

    @Override
    public Composite createContents(Composite parent) {
        if (this.mainComposite != null) {
            return this.mainComposite;
        }
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout());
        this.mainComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.includes = new MyFolderListControl(this.mainComposite, this.project.getLocation().toOSString(), "Include paths (-I)", "path");
        return this.mainComposite;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mainComposite == null) {
            return;
        }
        this.includes.setEnabled(enabled);
    }

    @Override
    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        String property = this.preprocessor ? "TTCN3preprocessorIncludes" : "preprocessorIncludes";
        String temp = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", property));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        if (temp != null) {
            tempStorage.setValue(property, temp);
        }
    }

    @Override
    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        String property = this.preprocessor ? "TTCN3preprocessorIncludes" : "preprocessorIncludes";
        String actualValue = null;
        String copyValue = null;
        try {
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", property));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        copyValue = tempStorage.getString(property);
        return actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
    }

    @Override
    public void performDefaults() {
        if (this.mainComposite == null) {
            return;
        }
        this.includes.setEnabled(true);
        this.includes.setValues(new String[0]);
    }

    @Override
    public boolean checkProperties(ProjectBuildPropertyPage page) {
        return true;
    }

    @Override
    public void loadProperties(IProject project) {
        String property = this.preprocessor ? "TTCN3preprocessorIncludes" : "preprocessorIncludes";
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", property));
            this.includes.setValues(ListConverter.convertToList(temp));
        }
        catch (CoreException e) {
            this.includes.setValues(new String[0]);
        }
    }

    @Override
    public boolean saveProperties(IProject project) {
        String property = this.preprocessor ? "TTCN3preprocessorIncludes" : "preprocessorIncludes";
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", property);
            String newValue = ListConverter.convertFromList(this.includes.getValues());
            String oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return true;
    }
}

