/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titanium.metrics.AltstepMetric;
import org.eclipse.titanium.metrics.FunctionMetric;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.MetricData;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.Statistics;
import org.eclipse.titanium.metrics.TestcaseMetric;
import org.eclipse.titanium.metrics.utils.RiskLevel;

public class ModuleMetricsWrapper {
    private final MetricData data;
    private final Map<String, Module> modules = new HashMap<String, Module>();

    protected ModuleMetricsWrapper(IProject project) {
        this.data = MetricData.measure(project);
        for (Module module : this.data.getModules()) {
            this.modules.put(module.getName(), module);
        }
    }

    public Statistics getStats(IMetricEnum metric, String moduleName) {
        Module module = this.modules.get(moduleName);
        if (module == null) {
            return null;
        }
        if (metric instanceof AltstepMetric) {
            return this.data.getStatistics((AltstepMetric)metric, module);
        }
        if (metric instanceof FunctionMetric) {
            return this.data.getStatistics((FunctionMetric)metric, module);
        }
        if (metric instanceof TestcaseMetric) {
            return this.data.getStatistics((TestcaseMetric)metric, module);
        }
        throw new IllegalArgumentException("The metric " + metric.getName() + " does not have statistics for modules");
    }

    public Number getValue(IMetricEnum metric, String moduleName) {
        Module module = this.modules.get(moduleName);
        if (module == null) {
            return null;
        }
        if (metric instanceof ModuleMetric) {
            return this.data.get((ModuleMetric)metric, module);
        }
        if (metric instanceof AltstepMetric) {
            return this.data.getHighestRiskCauser((AltstepMetric)metric, module);
        }
        if (metric instanceof FunctionMetric) {
            return this.data.getHighestRiskCauser((FunctionMetric)metric, module);
        }
        if (metric instanceof TestcaseMetric) {
            return this.data.getHighestRiskCauser((TestcaseMetric)metric, module);
        }
        throw new IllegalArgumentException();
    }

    public RiskLevel getRisk(IMetricEnum metric, String moduleName) {
        Module module = this.modules.get(moduleName);
        if (module == null) {
            return RiskLevel.UNKNOWN;
        }
        if (metric instanceof ModuleMetric) {
            return this.data.getRisk((ModuleMetric)metric, module);
        }
        if (metric instanceof AltstepMetric) {
            return this.data.getRisk((AltstepMetric)metric, module);
        }
        if (metric instanceof FunctionMetric) {
            return this.data.getRisk((FunctionMetric)metric, module);
        }
        if (metric instanceof TestcaseMetric) {
            return this.data.getRisk((TestcaseMetric)metric, module);
        }
        throw new IllegalArgumentException();
    }

    public double getRiskValue(IMetricEnum metric, String moduleName) {
        Module module = this.modules.get(moduleName);
        if (module == null) {
            throw new IllegalArgumentException("module_name does not correspond to a module");
        }
        if (metric instanceof ModuleMetric) {
            return this.data.getRiskValue((ModuleMetric)metric, module);
        }
        if (metric instanceof AltstepMetric) {
            return this.data.getRiskValue((AltstepMetric)metric, module);
        }
        if (metric instanceof FunctionMetric) {
            return this.data.getRiskValue((FunctionMetric)metric, module);
        }
        if (metric instanceof TestcaseMetric) {
            return this.data.getRiskValue((TestcaseMetric)metric, module);
        }
        throw new IllegalArgumentException();
    }

    public MetricData getMetricData() {
        return this.data;
    }
}

