/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TC_End;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Module;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TtcnError;
import org.eclipse.titan.runtime.core.Usage_Stats;

public final class Module_List {
    public static final ArrayList<TTCN_Module> modules = new ArrayList();

    private Module_List() {
    }

    public static void add_module(TTCN_Module module) {
        modules.add(module);
    }

    public static void remove_module(TTCN_Module module) {
        modules.remove(module);
    }

    public static TTCN_Module lookup_module(String module_name) {
        for (TTCN_Module module : modules) {
            if (!module.module_name.equals(module_name)) continue;
            return module;
        }
        return null;
    }

    public static void pre_init_modules() {
        for (TTCN_Module module : modules) {
            module.pre_init_module();
        }
    }

    public static void pre_init_module(String module_name) {
        TTCN_Module module = Module_List.lookup_module(module_name);
        module.pre_init_module();
    }

    public static void post_init_modules() {
        for (TTCN_Module module : modules) {
            module.post_init_module();
        }
    }

    public static void post_init_module(String module_name) {
        TTCN_Module module = Module_List.lookup_module(module_name);
        module.post_init_module();
    }

    public static void start_function(String module_name, String function_name, Text_Buf function_arguments) {
        TTCN_Module module = Module_List.lookup_module(module_name);
        if (module == null) {
            function_arguments.cut_message();
            throw new TtcnError(MessageFormat.format("Internal error: Module {0} does not exist.", module_name));
        }
        module.start_ptc_function(function_name, function_arguments);
    }

    public static void initialize_component(String module_name, String component_type, boolean init_base_comps) {
        TTCN_Module module = Module_List.lookup_module(module_name);
        if (module == null) {
            throw new TtcnError(MessageFormat.format("Internal error: Module {0} does not exist.", module_name));
        }
        if (!module.init_comp_type(component_type, init_base_comps)) {
            throw new TtcnError(MessageFormat.format("Internal error: Component type {0} does not exist in module {1}.", component_type, module_name));
        }
    }

    static void initialize_system_port(String module_name, String component_type, String port_name) {
        TTCN_Module system_module = Module_List.lookup_module(module_name);
        if (system_module == null) {
            throw new TtcnError(MessageFormat.format("Internal error: Module {0} does not exist.", module_name));
        }
        if (!system_module.init_system_port(component_type, port_name)) {
            throw new TtcnError(MessageFormat.format("Internal error: Cannot find port {0} in component type {1}, or component type {2} in module {3}.", port_name, component_type, component_type, module_name));
        }
    }

    public static void set_param(Param_Types.Module_Parameter param) {
        if (param.get_id().get_nof_names() > 2) {
            param.error("Module parameter cannot be set. Field names and array indexes are not supported in the Load Test Runtime.", new Object[0]);
        }
        String first_name = param.get_id().get_current_name();
        String second_name = null;
        boolean param_found = false;
        TTCN_Module module = Module_List.lookup_module(first_name);
        if (module != null && param.get_id().next_name() && !(param_found = module.set_module_param(param))) {
            second_name = param.get_id().get_current_name();
        }
        if (!param_found) {
            param.get_id().reset();
            for (TTCN_Module module2 : modules) {
                if (!module2.set_module_param(param)) continue;
                param_found = true;
            }
        }
        if (!param_found) {
            if (module == null) {
                param.error(MessageFormat.format("Module parameter cannot be set, because module `{0}'' does not exist, and no parameter with name `{0}'' exists in any module.", first_name), new Object[0]);
            } else if (!module.has_set_module_param()) {
                param.error(MessageFormat.format("Module parameter cannot be set, because module `{0}'' does not have parameters, and no parameter with name `{0}'' exists in other modules.", first_name), new Object[0]);
            } else {
                param.error(MessageFormat.format("Module parameter cannot be set, because no parameter with name `{0}'' exists in module `{1}'', and no parameter with name `{1}'' exists in any module.", second_name, first_name), new Object[0]);
            }
        }
    }

    public static Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name, Param_Types.Module_Parameter caller) {
        String first_name = param_name.get_current_name();
        String second_name = null;
        Param_Types.Module_Parameter param = null;
        TTCN_Module module_ptr = Module_List.lookup_module(first_name);
        if (module_ptr != null && module_ptr.has_get_module_param() && param_name.next_name() && (param = module_ptr.get_module_param(param_name)) == null) {
            second_name = param_name.get_current_name();
        }
        if (param == null) {
            TTCN_Module module2;
            param_name.reset();
            Iterator<TTCN_Module> iterator = modules.iterator();
            while (iterator.hasNext() && (param = (module2 = iterator.next()).get_module_param(param_name)) == null) {
            }
        }
        if (param == null) {
            if (module_ptr == null) {
                caller.error("Referenced module parameter cannot be found. Module `%s' does not exist, and no parameter with name `%s' exists in any module.", first_name, first_name);
            } else if (!module_ptr.has_get_module_param()) {
                caller.error("Referenced module parameter cannot be found. Module `%s' does not have parameters, and no parameter with name `%s' exists in other modules.", first_name, first_name);
            } else {
                caller.error("Referenced module parameter cannot be found. No parameter with name `%s' exists in module `%s', and no parameter with name `%s' exists in any module.", second_name, first_name, first_name);
            }
        } else if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Unbound) {
            caller.error("Referenced module parameter '%s' is unbound.", param_name.get_str());
        }
        return param;
    }

    public static void log_param() {
        for (int i = 0; i < modules.size(); ++i) {
            if (!modules.get(i).has_log_module_param()) continue;
            TTCN_Logger.begin_event(TTCN_Logger.Severity.EXECUTOR_CONFIGDATA);
            TTCN_Logger.log_event("Module %s has the following parameters: { ", Module_List.modules.get((int)i).module_name);
            modules.get(i).log_module_param();
            TTCN_Logger.log_event_str(" }");
            TTCN_Logger.end_event();
        }
    }

    public static void execute_control(String module_name) {
        TTCN_Module module = Module_List.lookup_module(module_name);
        if (module == null) {
            throw new TtcnError(MessageFormat.format("Module {0} does not exist.", module_name));
        }
        try {
            module.control();
        }
        catch (TtcnError TC_error) {
            TTCN_Logger.log_str(TTCN_Logger.Severity.ERROR_UNQUALIFIED, MessageFormat.format("Unrecoverable error in control part of module {0}. Execution aborted.", module_name));
        }
        catch (TC_End TC_end) {
            TTCN_Logger.log_str(TTCN_Logger.Severity.FUNCTION_UNQUALIFIED, MessageFormat.format("Control part of module {0} was stopped.", module_name));
        }
    }

    public static void execute_testcase(String module_name, String testcase_name) {
        TTCN_Module module = Module_List.lookup_module(module_name);
        if (module == null) {
            throw new TtcnError(MessageFormat.format("Module {0} does not exist.", module_name));
        }
        module.execute_testcase(testcase_name);
    }

    public static void execute_all_testcases(String module_name) {
        TTCN_Module module = Module_List.lookup_module(module_name);
        if (module == null) {
            throw new TtcnError(MessageFormat.format("Module {0} does not exist.", module_name));
        }
        module.execute_all_testcases();
    }

    public static void send_usage_stats() {
        StringBuilder builder = new StringBuilder("Module version infos: ");
        Usage_Stats.sendAsync(builder.toString());
    }

    public static void clean_up_usage_stats() {
    }

    public void list_testcases() {
        for (TTCN_Module module : modules) {
            module.list_testcases();
        }
    }

    public void list_modulepars() {
        for (TTCN_Module module : modules) {
            module.list_modulepars();
        }
    }

    public static void push_version(Text_Buf text_buf) {
        text_buf.push_int(modules.size());
        for (TTCN_Module module : modules) {
            module.push_version(text_buf);
        }
    }
}

