/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.util.ArrayList;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanUniversalChar;
import org.eclipse.titan.runtime.core.TitanUniversalCharString;
import org.eclipse.titan.runtime.core.TitanUniversalCharString_Element;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanCharString_Element {
    private boolean bound_flag;
    private final TitanCharString str_val;
    private final int char_pos;

    public TitanCharString_Element(boolean par_bound_flag, TitanCharString par_str_val, int par_char_pos) {
        this.bound_flag = par_bound_flag;
        this.str_val = par_str_val;
        this.char_pos = par_char_pos;
    }

    public boolean is_bound() {
        return this.bound_flag;
    }

    public boolean is_value() {
        return this.bound_flag;
    }

    public void must_bound(String errorMessage) {
        if (!this.bound_flag) {
            throw new TtcnError(errorMessage);
        }
    }

    public TitanCharString_Element operator_assign(String otherValue) {
        if (otherValue == null || otherValue.length() != 1) {
            throw new TtcnError("Assignment of a charstring value with length other than 1 to a charstring element.");
        }
        this.bound_flag = true;
        this.str_val.get_value().setCharAt(this.char_pos, otherValue.charAt(0));
        return this;
    }

    public TitanCharString_Element operator_assign(TitanCharString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound charstring element.");
        this.bound_flag = true;
        this.str_val.get_value().setCharAt(this.char_pos, otherValue.str_val.get_value().charAt(otherValue.char_pos));
        return this;
    }

    public TitanCharString_Element operator_assign(TitanCharString otherValue) {
        otherValue.must_bound("Assignment of unbound charstring value.");
        if (otherValue.get_value().length() != 1) {
            throw new TtcnError("Assignment of a charstring value with length other than 1 to a charstring element.");
        }
        this.bound_flag = true;
        this.str_val.get_value().setCharAt(this.char_pos, otherValue.get_value().charAt(0));
        return this;
    }

    public boolean operator_equals(String otherValue) {
        this.must_bound("Comparison of an unbound charstring element.");
        if (otherValue == null || otherValue.length() != 1) {
            return false;
        }
        return this.str_val.get_at(this.char_pos).get_char() == otherValue.charAt(0);
    }

    public boolean operator_equals(TitanCharString otherValue) {
        this.must_bound("Unbound left operand of charstring element comparison.");
        otherValue.must_bound("Unbound right operand of charstring element comparison.");
        if (otherValue.get_value().length() != 1) {
            return false;
        }
        return this.get_char() == otherValue.get_value().charAt(0);
    }

    public boolean operator_equals(TitanCharString_Element otherValue) {
        this.must_bound("Unbound left operand of charstring element comparison.");
        otherValue.must_bound("Unbound right operand of charstring element comparison.");
        return this.get_char() == otherValue.str_val.get_value().charAt(otherValue.char_pos);
    }

    public boolean operator_equals(TitanUniversalCharString otherValue) {
        this.must_bound("The left operand of comparison is an unbound charstring element.");
        otherValue.must_bound("The right operand of comparison is an unbound universal charstring value.");
        if (otherValue.val_ptr.size() != 1) {
            return false;
        }
        if (otherValue.charstring) {
            return this.str_val.get_at(this.char_pos).get_char() == otherValue.char_at(0).getUc_cell();
        }
        TitanUniversalChar temp = otherValue.char_at(0);
        return temp.getUc_group() == '\u0000' && temp.getUc_plane() == '\u0000' && temp.getUc_row() == '\u0000' && this.str_val.get_at(this.char_pos).get_char() == temp.getUc_cell();
    }

    public boolean operator_equals(TitanUniversalCharString_Element otherValue) {
        this.must_bound("The left operand of comparison is an unbound charstring element.");
        otherValue.must_bound("The right operand of comparison is an unbound universal charstring element.");
        TitanUniversalChar temp = otherValue.get_char();
        return temp.getUc_group() == '\u0000' && temp.getUc_plane() == '\u0000' && temp.getUc_row() == '\u0000' && this.str_val.get_at(this.char_pos).get_char() == temp.getUc_cell();
    }

    public boolean operator_not_equals(String otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanUniversalCharString otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanUniversalCharString_Element otherValue) {
        return !this.operator_equals(otherValue);
    }

    public char get_char() {
        return this.str_val.get_value().charAt(this.char_pos);
    }

    public TitanCharString operator_concatenate(String other_value) {
        this.must_bound("Unbound operand of charstring element concatenation.");
        if (other_value != null) {
            int otherLen = other_value.length();
            StringBuilder ret_val = new StringBuilder(otherLen + 1);
            ret_val.append(this.str_val.constGet_at(this.char_pos).get_char());
            ret_val.append(other_value);
            return new TitanCharString(ret_val);
        }
        StringBuilder ret_val = new StringBuilder();
        ret_val.append(this.str_val.constGet_at(this.char_pos).get_char());
        return new TitanCharString(ret_val);
    }

    public TitanCharString operator_concatenate(TitanCharString other_value) {
        this.must_bound("Unbound operand of charstring element concatenation.");
        other_value.must_bound("Unbound operand of charstring concatenation.");
        int nChars = other_value.lengthof().get_int();
        StringBuilder ret_val = new StringBuilder(nChars + 1);
        ret_val.append(this.str_val.constGet_at(this.char_pos).get_char());
        ret_val.append((CharSequence)other_value.get_value());
        return new TitanCharString(ret_val);
    }

    public TitanCharString operator_concatenate(TitanCharString_Element other_value) {
        this.must_bound("Unbound operand of charstring element concatenation.");
        other_value.must_bound("Unbound operand of charstring element concatenation.");
        StringBuilder ret_val = new StringBuilder(2);
        ret_val.append(this.str_val.constGet_at(this.char_pos).get_char());
        ret_val.append(other_value.get_char());
        return new TitanCharString(ret_val);
    }

    public TitanUniversalCharString operator_concatenate(TitanUniversalCharString other_value) {
        this.must_bound("The left operand of concatenation is an unbound charstring value.");
        other_value.must_bound("The right operand of concatenation is an unbound universal charstring value.");
        if (other_value.charstring) {
            TitanUniversalCharString temp = new TitanUniversalCharString('\u0000', '\u0000', '\u0000', this.get_char());
            return temp.operator_concatenate(other_value);
        }
        ArrayList<TitanUniversalChar> ret_val = new ArrayList<TitanUniversalChar>();
        ret_val.add(new TitanUniversalChar('\u0000', '\u0000', '\u0000', this.get_char()));
        for (int i = 0; i < other_value.lengthof().get_int(); ++i) {
            ret_val.add(other_value.char_at(i));
        }
        return new TitanUniversalCharString(ret_val);
    }

    public TitanUniversalCharString operator_concatenate(TitanUniversalCharString_Element other_value) {
        this.must_bound("The left operand of concatenation is an unbound charstring element.");
        other_value.must_bound("The right operand of concatenation is an unbound universal charstring element.");
        TitanUniversalChar[] result = new TitanUniversalChar[]{new TitanUniversalChar('\u0000', '\u0000', '\u0000', this.get_char()), other_value.get_char()};
        return new TitanUniversalCharString(result);
    }

    public TitanCharString rotate_left(int rotate_count) {
        this.must_bound("Unbound charstring element operand of rotate left operator.");
        return new TitanCharString(this);
    }

    public TitanCharString rotate_left(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound integer operand of rotate left operator.");
        return this.rotate_left(rotate_count.get_int());
    }

    public TitanCharString rotate_right(int rotate_count) {
        this.must_bound("Unbound charstring element operand of rotate right operator.");
        return new TitanCharString(this);
    }

    public TitanCharString rotate_right(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound integer operand of rotate right operator.");
        return this.rotate_right(rotate_count.get_int());
    }

    public String toString() {
        if (this.str_val == null) {
            return "<unbound>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('\"').append(this.str_val.get_value().charAt(this.char_pos)).append('\"');
        return builder.toString();
    }

    public void log() {
        if (this.bound_flag) {
            char c = this.str_val.get_at(this.char_pos).get_char();
            if (TTCN_Logger.is_printable(c)) {
                TTCN_Logger.log_char('\"');
                TTCN_Logger.log_char_escaped(c);
                TTCN_Logger.log_char('\"');
            } else {
                TTCN_Logger.log_event("char(0, 0, 0, {0})", c);
            }
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }
}

