/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers.cfg;

import java.math.BigInteger;

public final class CFGNumber {
    private static final String DIV_BY_ZERO = "Division by zero";
    private boolean isFloatNumber;
    private double floatNumber;
    private BigInteger intNumber;

    public CFGNumber(String text) {
        try {
            this.floatNumber = Float.parseFloat(text);
            this.isFloatNumber = true;
            this.intNumber = new BigInteger(text);
            this.isFloatNumber = false;
        }
        catch (NumberFormatException e) {
            this.isFloatNumber = true;
        }
    }

    public boolean isFloat() {
        return this.isFloatNumber;
    }

    public void add(CFGNumber num) {
        if (this.isFloatNumber) {
            this.floatNumber = num.isFloatNumber ? (this.floatNumber += num.floatNumber) : (this.floatNumber += (double)num.intNumber.floatValue());
        } else if (num.isFloatNumber) {
            this.isFloatNumber = true;
            this.floatNumber = (double)this.intNumber.floatValue() + num.floatNumber;
        } else {
            this.intNumber = this.intNumber.add(num.intNumber);
        }
    }

    public void sub(CFGNumber num) {
        if (this.isFloatNumber) {
            this.floatNumber = num.isFloatNumber ? (this.floatNumber -= num.floatNumber) : (this.floatNumber -= (double)num.intNumber.floatValue());
        } else if (num.isFloatNumber) {
            this.isFloatNumber = true;
            this.floatNumber = (double)this.intNumber.floatValue() - num.floatNumber;
        } else {
            this.intNumber = this.intNumber.subtract(num.intNumber);
        }
    }

    public void mul(int num) {
        if (this.isFloatNumber) {
            this.floatNumber *= (double)num;
        } else {
            this.intNumber = this.intNumber.multiply(new BigInteger(String.valueOf(num)));
        }
    }

    public void mul(CFGNumber num) {
        if (this.isFloatNumber) {
            this.floatNumber = num.isFloatNumber ? (this.floatNumber *= num.floatNumber) : (this.floatNumber *= (double)num.intNumber.floatValue());
        } else if (num.isFloatNumber) {
            this.isFloatNumber = true;
            this.floatNumber = (double)this.intNumber.floatValue() * num.floatNumber;
        } else {
            this.intNumber = this.intNumber.multiply(num.intNumber);
        }
    }

    public void div(CFGNumber num) throws ArithmeticException {
        if (this.isFloatNumber) {
            if (num.isFloatNumber) {
                if (num.floatNumber == 0.0) {
                    throw new ArithmeticException(DIV_BY_ZERO);
                }
                this.floatNumber /= num.floatNumber;
            } else {
                if (num.intNumber.compareTo(BigInteger.ZERO) == 0) {
                    throw new ArithmeticException(DIV_BY_ZERO);
                }
                this.floatNumber /= (double)num.intNumber.floatValue();
            }
        } else if (num.isFloatNumber) {
            if (num.floatNumber == 0.0) {
                throw new ArithmeticException(DIV_BY_ZERO);
            }
            this.isFloatNumber = true;
            this.floatNumber = (double)this.intNumber.floatValue() / num.floatNumber;
        } else {
            if (num.intNumber.compareTo(BigInteger.ZERO) == 0) {
                throw new ArithmeticException(DIV_BY_ZERO);
            }
            this.intNumber = this.intNumber.divide(num.intNumber);
        }
    }

    public String toString() {
        if (this.isFloatNumber) {
            if (Double.isInfinite(this.floatNumber)) {
                return "0.0";
            }
            return Double.toString(this.floatNumber);
        }
        return this.intNumber.toString();
    }

    public Double getValue() {
        if (this.isFloatNumber) {
            return new Double(this.floatNumber);
        }
        return this.intNumber.doubleValue();
    }

    public Integer getIntegerValue() {
        if (this.isFloatNumber) {
            return null;
        }
        return this.intNumber.intValue();
    }
}

