/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.views.executormonitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.titan.executor.executors.ITreeBranch;
import org.eclipse.titan.executor.executors.ITreeLeaf;
import org.eclipse.titan.executor.executors.TreeLeaf;
import org.eclipse.titan.executor.views.executormonitor.ComponentElement;
import org.eclipse.titan.executor.views.executormonitor.InformationElement;

public final class HostControllerElement
extends TreeLeaf
implements ITreeBranch {
    private InformationElement ipAddressInfo;
    private InformationElement ipNumberInfo;
    private InformationElement hostNameInfo;
    private InformationElement operatingSystemInfo;
    private InformationElement stateInfo;
    private List<ComponentElement> components = new ArrayList<ComponentElement>(1);

    public HostControllerElement(String name) {
        super(name);
    }

    public void setIPAddressInfo(InformationElement ipAddressInfo) {
        this.ipAddressInfo = ipAddressInfo;
        ipAddressInfo.parent(this);
    }

    public void setIPNumberInfo(InformationElement ipNumberInfo) {
        this.ipNumberInfo = ipNumberInfo;
        ipNumberInfo.parent(this);
    }

    public void setHostNameInfo(InformationElement hostNameInfo) {
        this.hostNameInfo = hostNameInfo;
        hostNameInfo.parent(this);
    }

    public void setOperatingSystemInfo(InformationElement operatingSystemInfo) {
        this.operatingSystemInfo = operatingSystemInfo;
        operatingSystemInfo.parent(this);
    }

    public void setStateInfo(InformationElement stateInfo) {
        this.stateInfo = stateInfo;
        stateInfo.parent(this);
    }

    public void addComponent(ComponentElement component) {
        this.components.add(component);
        component.parent(this);
    }

    @Override
    public List<ITreeLeaf> children() {
        ArrayList<ITreeLeaf> result = new ArrayList<ITreeLeaf>();
        if (null != this.ipAddressInfo) {
            result.add(this.ipAddressInfo);
        }
        if (null != this.ipNumberInfo) {
            result.add(this.ipNumberInfo);
        }
        if (null != this.hostNameInfo) {
            result.add(this.hostNameInfo);
        }
        if (null != this.operatingSystemInfo) {
            result.add(this.operatingSystemInfo);
        }
        if (null != this.stateInfo) {
            result.add(this.stateInfo);
        }
        result.addAll(this.components);
        return result;
    }

    public boolean isSame(HostControllerElement other) {
        return null != this.ipAddressInfo && null != other.ipAddressInfo && this.ipAddressInfo.name().equals(other.ipAddressInfo.name());
    }

    public void transferData(HostControllerElement other) {
        this.ipAddressInfo = other.ipAddressInfo;
        if (null != this.ipAddressInfo) {
            this.ipAddressInfo.parent(this);
        }
        this.ipNumberInfo = other.ipNumberInfo;
        if (null != this.ipNumberInfo) {
            this.ipNumberInfo.parent(this);
        }
        this.hostNameInfo = other.hostNameInfo;
        if (null != this.hostNameInfo) {
            this.hostNameInfo.parent(this);
        }
        this.operatingSystemInfo = other.operatingSystemInfo;
        if (null != this.operatingSystemInfo) {
            this.operatingSystemInfo.parent(this);
        }
        this.stateInfo = other.stateInfo;
        if (null != this.stateInfo) {
            this.stateInfo.parent(this);
        }
        List<ComponentElement> oldComponents = this.components;
        this.components = new ArrayList<ComponentElement>(other.components.size());
        for (ComponentElement tempElement : other.components) {
            boolean found = false;
            Iterator<ComponentElement> iterator = oldComponents.iterator();
            while (iterator.hasNext() && !found) {
                ComponentElement oldElement = iterator.next();
                if (!oldElement.isSame(tempElement)) continue;
                oldElement.transferData(tempElement);
                this.components.add(oldElement);
                iterator.remove();
                found = true;
            }
            if (found) continue;
            this.components.add(tempElement);
            tempElement.parent(this);
        }
        other.components.clear();
    }
}

