/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.mtl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.trace4cps.analysis.mtl.InformativePrefix;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.mtl.MtlFuture;
import org.eclipse.trace4cps.analysis.mtl.MtlResult;
import org.eclipse.trace4cps.analysis.mtl.MtlUtil;
import org.eclipse.trace4cps.analysis.mtl.State;
import org.eclipse.trace4cps.analysis.mtl.check.RecursiveMemoizationChecker;

public final class MtlChecker {
    private final int numThreads;

    public MtlChecker() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public MtlChecker(int numThreads) {
        this.numThreads = numThreads;
    }

    public MtlResult check(List<? extends State> trace, MtlFormula phi) {
        boolean interpretAsPrefix = MtlUtil.isMtl(phi);
        return this.check(trace, phi, new HashSet<InformativePrefix>(), interpretAsPrefix);
    }

    public MtlResult check(List<? extends State> trace, MtlFormula phi, Set<InformativePrefix> explain, boolean interpretAsPrefix) {
        if (interpretAsPrefix && !MtlUtil.isMtl(phi)) {
            throw new IllegalArgumentException("trace can only be interpreted as a prefix for pure MTL formulas");
        }
        RecursiveMemoizationChecker c = new RecursiveMemoizationChecker();
        InformativePrefix r = c.check(trace, phi, explain, interpretAsPrefix);
        return new MtlResult(phi, r, c.getExplanation());
    }

    public MtlFuture checkAll(List<? extends State> trace, List<MtlFormula> phis) {
        return this.checkAll(trace, phis, new HashSet<InformativePrefix>(), true);
    }

    public MtlFuture checkAll(List<? extends State> trace, Collection<MtlFormula> phis, Set<InformativePrefix> explain, boolean tryInterpretAsPrefix) {
        CopyOnWriteArrayList<State> safeList = new CopyOnWriteArrayList<State>(trace);
        ExecutorService exec = Executors.newFixedThreadPool(this.numThreads);
        MtlFuture future = new MtlFuture(phis.size(), exec);
        for (MtlFormula phi : phis) {
            boolean pref = tryInterpretAsPrefix && MtlUtil.isMtl(phi);
            exec.submit(new CheckTask(safeList, phi, future, explain, pref));
        }
        return future;
    }

    public String toString() {
        return "MtlChecker[#threads=" + this.numThreads + "]";
    }

    private static final class CheckTask
    implements Runnable {
        private final List<State> trace;
        private final MtlFormula phi;
        private final MtlFuture result;
        private final Set<InformativePrefix> explain;
        private final boolean interpretAsPrefix;

        public CheckTask(List<State> trace, MtlFormula phi, MtlFuture result, Set<InformativePrefix> explain, boolean interpretAsPrefix) {
            this.trace = trace;
            this.phi = phi;
            this.result = result;
            this.explain = explain;
            this.interpretAsPrefix = interpretAsPrefix;
        }

        @Override
        public void run() {
            try {
                RecursiveMemoizationChecker c = new RecursiveMemoizationChecker();
                InformativePrefix r = c.check(this.trace, this.phi, this.explain, this.interpretAsPrefix);
                this.result.addToResult(this.phi, r, c.getExplanation());
            }
            catch (Throwable th) {
                this.result.addError(th);
            }
        }
    }
}

