/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtils;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.XYAnnotationEntity;
import org.jfree.chart.entity.XYMeasurementAnnotationEntity;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.text.TextUtils;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.chart.util.Args;
import org.jfree.chart.util.PublicCloneable;
import org.jfree.chart.util.SerialUtils;

public class XYMeasurementAnnotation
extends XYTextAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3774229610407585254L;
    public static final double DEFAULT_LABEL_OFFSET = 30.0;
    public static final double DEFAULT_ARROW_LENGTH = 10.0;
    public static final double DEFAULT_ARROW_WIDTH = 5.0;
    private Orientation orientation;
    private double x2;
    private double y2;
    private double arrowLength;
    private double arrowWidth;
    private transient Stroke arrowStroke;
    private transient Paint arrowPaint;
    private transient Stroke measureLineStroke;
    private transient Paint measureLinePaint;
    private double labelOffset;
    private boolean baseCreateEntity;

    public XYMeasurementAnnotation(Orientation orientation, String text, Point2D p1, Point2D p2) {
        this(orientation, text, p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public XYMeasurementAnnotation(Orientation orientation, String text, double x1, double y1, double x2, double y2) {
        super(text, x1, y1);
        this.orientation = orientation;
        this.x2 = x2;
        this.y2 = y2;
        this.arrowLength = 10.0;
        this.arrowWidth = 5.0;
        this.labelOffset = 30.0;
        this.arrowStroke = new BasicStroke(1.0f);
        this.arrowPaint = Color.BLACK;
        this.measureLineStroke = new BasicStroke(2.0f);
        this.measureLinePaint = Color.BLACK;
        this.baseCreateEntity = true;
        this.setPaint(Color.RED);
        this.setFont(this.getFont().deriveFont(1));
        this.setBackgroundPaint(Color.WHITE);
        this.setOutlineVisible(true);
        this.setOutlinePaint(Color.DARK_GRAY);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        Args.nullNotPermitted((Object)orientation, "orientation");
        this.orientation = orientation;
        this.fireAnnotationChanged();
    }

    public double getX2() {
        return this.x2;
    }

    public void setX2(double x) {
        this.x2 = x;
        this.fireAnnotationChanged();
    }

    public double getY2() {
        return this.y2;
    }

    public void setY2(double y) {
        this.y2 = y;
        this.fireAnnotationChanged();
    }

    public double getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(double offset) {
        this.labelOffset = offset;
        this.fireAnnotationChanged();
    }

    public double getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(double length) {
        this.arrowLength = length;
        this.fireAnnotationChanged();
    }

    public double getArrowWidth() {
        return this.arrowWidth;
    }

    public void setArrowWidth(double width) {
        this.arrowWidth = width;
        this.fireAnnotationChanged();
    }

    public Stroke getArrowStroke() {
        return this.arrowStroke;
    }

    public void setArrowStroke(Stroke stroke) {
        Args.nullNotPermitted(stroke, "stroke");
        this.arrowStroke = stroke;
        this.fireAnnotationChanged();
    }

    public Paint getArrowPaint() {
        return this.arrowPaint;
    }

    public void setArrowPaint(Paint paint) {
        Args.nullNotPermitted(paint, "paint");
        this.arrowPaint = paint;
        this.fireAnnotationChanged();
    }

    public Stroke getMeasureLineStroke() {
        return this.measureLineStroke;
    }

    public void setMeasureLineStroke(Stroke stroke) {
        Args.nullNotPermitted(stroke, "stroke");
        this.measureLineStroke = stroke;
        this.fireAnnotationChanged();
    }

    public Paint getMeasureLinePaint() {
        return this.measureLinePaint;
    }

    public void setMeasureLinePaint(Paint paint) {
        Args.nullNotPermitted(paint, "paint");
        this.measureLinePaint = paint;
        this.fireAnnotationChanged();
    }

    public boolean isBaseCreateEntity() {
        return this.baseCreateEntity;
    }

    public void setBaseCreateEntity(boolean createEntity) {
        this.baseCreateEntity = createEntity;
        this.fireAnnotationChanged();
    }

    protected boolean isCreateEntity() {
        return this.isBaseCreateEntity() || this.getToolTipText() != null || this.getURL() != null;
    }

    @Override
    public void draw(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        if (this.orientation == Orientation.HORIZONTAL) {
            this.drawHorizontal(g2, plot, dataArea, domainAxis, rangeAxis, rendererIndex, info);
        } else {
            this.drawVertical(g2, plot, dataArea, domainAxis, rangeAxis, rendererIndex, info);
        }
    }

    protected void drawHorizontal(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(plot.getDomainAxisLocation(), orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation(plot.getRangeAxisLocation(), orientation);
        double j2DX1 = domainAxis.valueToJava2D(this.getX(), dataArea, domainEdge);
        double j2DY1 = rangeAxis.valueToJava2D(this.getY(), dataArea, rangeEdge);
        double j2DX2 = domainAxis.valueToJava2D(this.getX2(), dataArea, domainEdge);
        double j2DY2 = rangeAxis.valueToJava2D(this.getY2(), dataArea, rangeEdge);
        if (orientation == PlotOrientation.HORIZONTAL) {
            double temp = j2DX1;
            j2DX1 = j2DY1;
            j2DY1 = temp;
            temp = j2DX2;
            j2DX2 = j2DY2;
            j2DY2 = temp;
        }
        double j2DXleft = Math.min(j2DX1, j2DX2);
        double j2DXright = Math.max(j2DX1, j2DX2);
        double labelX = (j2DXleft + j2DXright) / 2.0;
        double labelY = j2DY1 - this.labelOffset;
        g2.setStroke(this.measureLineStroke);
        g2.setPaint(this.measureLinePaint);
        g2.draw(new Line2D.Double(j2DX1, Math.min(labelY - this.arrowWidth, j2DY1), j2DX1, Math.max(labelY + this.arrowWidth, j2DY1)));
        g2.draw(new Line2D.Double(j2DX2, Math.min(labelY - this.arrowWidth, j2DY2), j2DX2, Math.max(labelY + this.arrowWidth, j2DY2)));
        String text = this.getText();
        TextAnchor textAnchor = this.getTextAnchor();
        g2.setFont(this.getFont());
        g2.setStroke(this.arrowStroke);
        g2.setPaint(this.arrowPaint);
        Shape hotspot = TextUtils.calculateRotatedStringBounds(text, g2, (float)labelX, (float)labelY, textAnchor, this.getRotationAngle(), this.getRotationAnchor());
        if (hotspot.getBounds2D().getWidth() > j2DXright - j2DXleft - 3.0 * this.arrowLength) {
            labelX = j2DXright + this.arrowLength * 2.0;
            textAnchor = TextAnchor.CENTER_LEFT;
            hotspot = TextUtils.calculateRotatedStringBounds(text, g2, (float)labelX, (float)labelY, textAnchor, this.getRotationAngle(), this.getRotationAnchor());
            g2.draw(new Line2D.Double(j2DXleft - this.arrowLength * 2.0, labelY, j2DXright + this.arrowLength * 2.0, labelY));
            GeneralPath arrowLeft = new GeneralPath();
            arrowLeft.moveTo((float)j2DXleft, (float)labelY);
            arrowLeft.lineTo((double)((float)j2DXleft) - this.arrowLength, (double)((float)labelY) - this.arrowWidth);
            arrowLeft.lineTo((double)((float)j2DXleft) - this.arrowLength, (double)((float)labelY) + this.arrowWidth);
            arrowLeft.closePath();
            g2.fill(arrowLeft);
            GeneralPath arrowRight = new GeneralPath();
            arrowRight.moveTo((float)j2DXright, (float)labelY);
            arrowRight.lineTo((double)((float)j2DXright) + this.arrowLength, (double)((float)labelY) - this.arrowWidth);
            arrowRight.lineTo((double)((float)j2DXright) + this.arrowLength, (double)((float)labelY) + this.arrowWidth);
            arrowRight.closePath();
            g2.fill(arrowRight);
        } else {
            g2.draw(new Line2D.Double(j2DXleft, labelY, j2DXright, labelY));
            GeneralPath arrowLeft = new GeneralPath();
            arrowLeft.moveTo((float)j2DXleft, (float)labelY);
            arrowLeft.lineTo((double)((float)j2DXleft) + this.arrowLength, (double)((float)labelY) - this.arrowWidth);
            arrowLeft.lineTo((double)((float)j2DXleft) + this.arrowLength, (double)((float)labelY) + this.arrowWidth);
            arrowLeft.closePath();
            g2.fill(arrowLeft);
            GeneralPath arrowRight = new GeneralPath();
            arrowRight.moveTo((float)j2DXright, (float)labelY);
            arrowRight.lineTo((double)((float)j2DXright) - this.arrowLength, (double)((float)labelY) - this.arrowWidth);
            arrowRight.lineTo((double)((float)j2DXright) - this.arrowLength, (double)((float)labelY) + this.arrowWidth);
            arrowRight.closePath();
            g2.fill(arrowRight);
        }
        if (text.isEmpty()) {
            return;
        }
        if (this.getBackgroundPaint() != null) {
            g2.setPaint(this.getBackgroundPaint());
            g2.fill(hotspot);
        }
        g2.setPaint(this.getPaint());
        TextUtils.drawRotatedString(this.getText(), g2, (float)labelX, (float)labelY, textAnchor, this.getRotationAngle(), this.getRotationAnchor());
        if (this.isOutlineVisible()) {
            g2.setStroke(this.getOutlineStroke());
            g2.setPaint(this.getOutlinePaint());
            g2.draw(hotspot);
        }
        if (this.isCreateEntity()) {
            this.addEntity(info, hotspot, rendererIndex, this.getToolTipText(), this.getURL());
        }
    }

    protected void drawVertical(Graphics2D g2, XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(plot.getDomainAxisLocation(), orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation(plot.getRangeAxisLocation(), orientation);
        double j2DX1 = domainAxis.valueToJava2D(this.getX(), dataArea, domainEdge);
        double j2DY1 = rangeAxis.valueToJava2D(this.getY(), dataArea, rangeEdge);
        double j2DX2 = domainAxis.valueToJava2D(this.getX2(), dataArea, domainEdge);
        double j2DY2 = rangeAxis.valueToJava2D(this.getY2(), dataArea, rangeEdge);
        if (orientation == PlotOrientation.HORIZONTAL) {
            double temp = j2DX1;
            j2DX1 = j2DY1;
            j2DY1 = temp;
            temp = j2DX2;
            j2DX2 = j2DY2;
            j2DY2 = temp;
        }
        double j2DYtop = Math.min(j2DY1, j2DY2);
        double j2DYbottom = Math.max(j2DY1, j2DY2);
        double labelY = (j2DYtop + j2DYbottom) / 2.0;
        double labelX = j2DX1 + this.labelOffset;
        g2.setStroke(this.measureLineStroke);
        g2.setPaint(this.measureLinePaint);
        g2.draw(new Line2D.Double(Math.min(labelX - this.arrowWidth, j2DX1), j2DY1, Math.max(labelX + this.arrowWidth, j2DX1), j2DY1));
        g2.draw(new Line2D.Double(Math.min(labelX - this.arrowWidth, j2DX2), j2DY2, Math.max(labelX + this.arrowWidth, j2DX2), j2DY2));
        String text = this.getText();
        TextAnchor textAnchor = this.getTextAnchor();
        g2.setFont(this.getFont());
        g2.setStroke(this.arrowStroke);
        g2.setPaint(this.arrowPaint);
        Shape hotspot = TextUtils.calculateRotatedStringBounds(text, g2, (float)labelX, (float)labelY, textAnchor, this.getRotationAngle(), this.getRotationAnchor());
        if (hotspot.getBounds2D().getHeight() > j2DYbottom - j2DYtop - 3.0 * this.arrowLength) {
            labelY = j2DYtop - this.arrowLength * 2.0;
            textAnchor = TextAnchor.BOTTOM_CENTER;
            hotspot = TextUtils.calculateRotatedStringBounds(text, g2, (float)labelX, (float)labelY, textAnchor, this.getRotationAngle(), this.getRotationAnchor());
            g2.draw(new Line2D.Double(labelX, j2DYtop - this.arrowLength * 2.0, labelX, j2DYbottom + this.arrowLength * 2.0));
            GeneralPath arrowTop = new GeneralPath();
            arrowTop.moveTo((float)labelX, (float)j2DYtop);
            arrowTop.lineTo((double)((float)labelX) - this.arrowWidth, (double)((float)j2DYtop) - this.arrowLength);
            arrowTop.lineTo((double)((float)labelX) + this.arrowWidth, (double)((float)j2DYtop) - this.arrowLength);
            arrowTop.closePath();
            g2.fill(arrowTop);
            GeneralPath arrowBottom = new GeneralPath();
            arrowBottom.moveTo((float)labelX, (float)j2DYbottom);
            arrowBottom.lineTo((double)((float)labelX) - this.arrowWidth, (double)((float)j2DYbottom) + this.arrowLength);
            arrowBottom.lineTo((double)((float)labelX) + this.arrowWidth, (double)((float)j2DYbottom) + this.arrowLength);
            arrowBottom.closePath();
            g2.fill(arrowBottom);
        } else {
            g2.draw(new Line2D.Double(labelX, j2DYtop, labelX, j2DYbottom));
            GeneralPath arrowTop = new GeneralPath();
            arrowTop.moveTo((float)labelX, (float)j2DYtop);
            arrowTop.lineTo((double)((float)labelX) - this.arrowWidth, (double)((float)j2DYtop) + this.arrowLength);
            arrowTop.lineTo((double)((float)labelX) + this.arrowWidth, (double)((float)j2DYtop) + this.arrowLength);
            arrowTop.closePath();
            g2.fill(arrowTop);
            GeneralPath arrowBottom = new GeneralPath();
            arrowBottom.moveTo((float)labelX, (float)j2DYbottom);
            arrowBottom.lineTo((double)((float)labelX) - this.arrowWidth, (double)((float)j2DYbottom) - this.arrowLength);
            arrowBottom.lineTo((double)((float)labelX) + this.arrowWidth, (double)((float)j2DYbottom) - this.arrowLength);
            arrowBottom.closePath();
            g2.fill(arrowBottom);
        }
        if (text.isEmpty()) {
            return;
        }
        if (this.getBackgroundPaint() != null) {
            g2.setPaint(this.getBackgroundPaint());
            g2.fill(hotspot);
        }
        g2.setPaint(this.getPaint());
        TextUtils.drawRotatedString(this.getText(), g2, (float)labelX, (float)labelY, textAnchor, this.getRotationAngle(), this.getRotationAnchor());
        if (this.isOutlineVisible()) {
            g2.setStroke(this.getOutlineStroke());
            g2.setPaint(this.getOutlinePaint());
            g2.draw(hotspot);
        }
        if (this.isCreateEntity()) {
            this.addEntity(info, hotspot, rendererIndex, this.getToolTipText(), this.getURL());
        }
    }

    @Override
    protected XYAnnotationEntity createEntity(Shape hotspot, int rendererIndex, String toolTipText, String urlText) {
        return new XYMeasurementAnnotationEntity(hotspot, this, rendererIndex, toolTipText, urlText);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.arrowLength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + HashUtils.hashCodeForPaint(this.arrowPaint);
        result = 31 * result + this.arrowStroke.hashCode();
        temp = Double.doubleToLongBits(this.arrowWidth);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.baseCreateEntity ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.labelOffset);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + HashUtils.hashCodeForPaint(this.measureLinePaint);
        result = 31 * result + this.measureLineStroke.hashCode();
        result = 31 * result + this.orientation.hashCode();
        temp = Double.doubleToLongBits(this.x2);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y2);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XYMeasurementAnnotation other = (XYMeasurementAnnotation)obj;
        if (Double.doubleToLongBits(this.arrowLength) != Double.doubleToLongBits(other.arrowLength)) {
            return false;
        }
        if (!this.arrowPaint.equals(other.arrowPaint)) {
            return false;
        }
        if (!this.arrowStroke.equals(other.arrowStroke)) {
            return false;
        }
        if (Double.doubleToLongBits(this.arrowWidth) != Double.doubleToLongBits(other.arrowWidth)) {
            return false;
        }
        if (this.baseCreateEntity != other.baseCreateEntity) {
            return false;
        }
        if (Double.doubleToLongBits(this.labelOffset) != Double.doubleToLongBits(other.labelOffset)) {
            return false;
        }
        if (!this.measureLinePaint.equals(other.measureLinePaint)) {
            return false;
        }
        if (!this.measureLineStroke.equals(other.measureLineStroke)) {
            return false;
        }
        if (this.orientation != other.orientation) {
            return false;
        }
        if (Double.doubleToLongBits(this.x2) != Double.doubleToLongBits(other.x2)) {
            return false;
        }
        return Double.doubleToLongBits(this.y2) == Double.doubleToLongBits(other.y2);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writePaint(this.arrowPaint, stream);
        SerialUtils.writeStroke(this.arrowStroke, stream);
        SerialUtils.writePaint(this.measureLinePaint, stream);
        SerialUtils.writeStroke(this.measureLineStroke, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.arrowPaint = SerialUtils.readPaint(stream);
        this.arrowStroke = SerialUtils.readStroke(stream);
        this.measureLinePaint = SerialUtils.readPaint(stream);
        this.measureLineStroke = SerialUtils.readStroke(stream);
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

