/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.ui.dialog.AbstractListSelectionWizardPage;
import org.eclipse.trace4cps.ui.view.TraceView;

public class BehaviorWizard
extends Wizard {
    private final TraceView traceView;
    private String idAtt;
    private Set<String> uniquenessAtts = new HashSet<String>();
    private IdPage page1;
    private UniquenessPage page2;

    public BehaviorWizard(TraceView view) {
        this.traceView = view;
        this.setWindowTitle("Behavior settings");
    }

    public String getIdAttribute() {
        return this.idAtt;
    }

    public Set<String> getUniqueness() {
        return this.uniquenessAtts;
    }

    public void addPages() {
        ArrayList<String> input = new ArrayList<String>();
        input.addAll(this.traceView.getAttributeNames(TracePart.CLAIM));
        Collections.sort(input);
        this.page1 = new IdPage(this, input);
        this.page2 = new UniquenessPage(this.page1, (Wizard)this, input);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.page1 && this.page1.hasSelection() && this.page1.getSelection().size() == 1) {
            this.page2.updateInputList();
            return this.page2;
        }
        return null;
    }

    public boolean canFinish() {
        return this.page1.hasSelection() && this.page1.getSelection().size() == 1;
    }

    public boolean performFinish() {
        if (this.validateIdAtt(this.page1.getSelection().get(0))) {
            this.idAtt = this.page1.getSelection().get(0);
            this.uniquenessAtts.addAll(this.page2.getSelection());
            return true;
        }
        MessageBox mb = new MessageBox(this.getShell(), 33);
        mb.setText("Invalid ID attribute");
        mb.setMessage("Some claims have no value for the specified ID attribute, or a non-integer value.");
        mb.open();
        return false;
    }

    private boolean validateIdAtt(String idAtt) {
        for (IClaim claim : this.traceView.getTrace().getClaims()) {
            String val = claim.getAttributeValue(idAtt);
            if (val != null && val.matches("-?\\d+")) continue;
            return false;
        }
        return true;
    }

    private static final class IdPage
    extends AbstractListSelectionWizardPage {
        private final Collection<String> atts;

        public IdPage(Wizard wizard, Collection<String> atts) {
            super("ID selection", wizard, AbstractListSelectionWizardPage.SelectionMode.EXACTLY_ONE);
            this.atts = atts;
        }

        @Override
        protected Collection<String> getInput() {
            return this.atts;
        }

        @Override
        protected String getPageTitle() {
            return "ID attribute (1/2)";
        }

        @Override
        protected String getPageMessage() {
            return "Select behavioral ID attribute (exactly 1)";
        }
    }

    private static final class UniquenessPage
    extends AbstractListSelectionWizardPage {
        private final IdPage idPage;
        private final Collection<String> atts;

        public UniquenessPage(IdPage idPage, Wizard wizard, Collection<String> atts) {
            super("Uniqueness selection", wizard, AbstractListSelectionWizardPage.SelectionMode.ALWAYS);
            this.atts = atts;
            this.idPage = idPage;
        }

        @Override
        protected Collection<String> getInput() {
            ArrayList<String> input = new ArrayList<String>();
            input.addAll(this.atts);
            String idAtt = null;
            if (this.idPage.getSelection() != null && this.idPage.getSelection().size() > 0) {
                idAtt = this.idPage.getSelection().get(0);
            }
            if (idAtt != null) {
                input.remove(idAtt);
            }
            return input;
        }

        @Override
        protected String getPageTitle() {
            return "Uniqueness attributes (2/2)";
        }

        @Override
        protected String getPageMessage() {
            return "Select behavioral uniqueness attributes (0 or more)";
        }
    }
}

