/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui;

import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleUtil {
    public static final String CONSOLE_NAME = "TRACE4CPS";

    private ConsoleUtil() {
    }

    public static void log(final String msg) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageConsole myConsole = ConsoleUtil.findConsole();
                if (myConsole != null) {
                    MessageConsoleStream out = myConsole.newMessageStream();
                    out.println(msg);
                }
            }
        });
    }

    private static MessageConsole findConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        MessageConsole myConsole = null;
        int i = 0;
        while (i < existing.length) {
            if (CONSOLE_NAME.equals(existing[i].getName())) {
                myConsole = (MessageConsole)existing[i];
                break;
            }
            ++i;
        }
        if (myConsole == null) {
            myConsole = new MessageConsole(CONSOLE_NAME, null);
            conMan.addConsoles(new IConsole[]{myConsole});
        }
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String id = "org.eclipse.ui.console.ConsoleView";
            IConsoleView view = (IConsoleView)page.showView(id);
            view.display((IConsole)myConsole);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return myConsole;
    }
}

