/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.launching;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FileExtensionFilter
extends ViewerFilter {
    private final List<String> extensions;

    public FileExtensionFilter(String[] extensions) {
        this.extensions = Arrays.asList(extensions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            return this.isFileValid(((IFile)element).getProjectRelativePath());
        }
        if (!(element instanceof IContainer)) return false;
        try {
            IResource[] resources;
            if (!((IContainer)element).isAccessible()) {
                return false;
            }
            IResource[] iResourceArray = resources = ((IContainer)element).members();
            int n = resources.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource resource = iResourceArray[n2];
                if (this.select(viewer, parent, resource)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private boolean isFileValid(IPath path) {
        String ext = path.getFileExtension();
        return ext != null && !ext.trim().equals("") && this.isProperExtension(ext);
    }

    private boolean isProperExtension(String ext) {
        if (this.extensions != null) {
            return this.extensions.contains(ext);
        }
        return false;
    }
}

