/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.compatibility.state;

import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.compatibility.state.PlatformAdminImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.StateWire;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;

public final class ReadOnlyState
implements State {
    private final PlatformAdminImpl platformAdmin;

    public ReadOnlyState(PlatformAdminImpl platformAdmin) {
        this.platformAdmin = platformAdmin;
    }

    public boolean addBundle(BundleDescription description) {
        throw new UnsupportedOperationException();
    }

    public StateDelta compare(State state) throws BundleException {
        return this.platformAdmin.getSystemState().compare(state);
    }

    public BundleDescription getBundle(long id) {
        return this.platformAdmin.getSystemState().getBundle(id);
    }

    public BundleDescription getBundle(String symbolicName, Version version) {
        return this.platformAdmin.getSystemState().getBundle(symbolicName, version);
    }

    public BundleDescription getBundleByLocation(String location) {
        return this.platformAdmin.getSystemState().getBundleByLocation(location);
    }

    public BundleDescription[] getBundles() {
        return this.platformAdmin.getSystemState().getBundles();
    }

    public BundleDescription[] getBundles(String symbolicName) {
        return this.platformAdmin.getSystemState().getBundles(symbolicName);
    }

    public StateDelta getChanges() {
        return this.platformAdmin.getSystemState().getChanges();
    }

    public ExportPackageDescription[] getExportedPackages() {
        return this.platformAdmin.getSystemState().getExportedPackages();
    }

    public StateObjectFactory getFactory() {
        return this.platformAdmin.getSystemState().getFactory();
    }

    public BundleDescription[] getResolvedBundles() {
        return this.platformAdmin.getSystemState().getResolvedBundles();
    }

    public long getTimeStamp() {
        return this.platformAdmin.getTimeStamp();
    }

    public boolean isEmpty() {
        return this.platformAdmin.getSystemState().isEmpty();
    }

    public boolean isResolved() {
        return this.platformAdmin.getSystemState().isResolved();
    }

    public boolean removeBundle(BundleDescription bundle) {
        throw new UnsupportedOperationException();
    }

    public BundleDescription removeBundle(long bundleId) {
        throw new UnsupportedOperationException();
    }

    public StateDelta resolve() {
        throw new UnsupportedOperationException();
    }

    public StateDelta resolve(boolean incremental) {
        throw new UnsupportedOperationException();
    }

    public StateDelta resolve(BundleDescription[] discard) {
        throw new UnsupportedOperationException();
    }

    public StateDelta resolve(BundleDescription[] resolve, boolean discard) {
        throw new UnsupportedOperationException();
    }

    public void setOverrides(Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean updateBundle(BundleDescription newDescription) {
        throw new UnsupportedOperationException();
    }

    public void resolveConstraint(VersionConstraint constraint, BaseDescription supplier) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void resolveBundle(BundleDescription bundle, boolean status, BundleDescription[] hosts, ExportPackageDescription[] selectedExports, BundleDescription[] resolvedRequires, ExportPackageDescription[] resolvedImports) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void resolveBundle(BundleDescription bundle, boolean status, BundleDescription[] host, ExportPackageDescription[] selectedExports, ExportPackageDescription[] substitutedExports, BundleDescription[] resolvedRequires, ExportPackageDescription[] resolveImports) {
        throw new UnsupportedOperationException();
    }

    public void resolveBundle(BundleDescription bundle, boolean status, BundleDescription[] hosts, ExportPackageDescription[] selectedExports, ExportPackageDescription[] substitutedExports, GenericDescription[] selectedCapabilities, BundleDescription[] resolvedRequires, ExportPackageDescription[] resolvedImports, GenericDescription[] resolvedCapabilities, Map<String, List<StateWire>> resolvedRequirements) {
        throw new UnsupportedOperationException();
    }

    public void removeBundleComplete(BundleDescription bundle) {
        throw new UnsupportedOperationException();
    }

    public Resolver getResolver() {
        return null;
    }

    public void setResolver(Resolver value) {
        throw new UnsupportedOperationException();
    }

    public boolean setPlatformProperties(Dictionary<?, ?> platformProperties) {
        throw new UnsupportedOperationException();
    }

    public boolean setPlatformProperties(Dictionary<?, ?>[] platformProperties) {
        throw new UnsupportedOperationException();
    }

    public Dictionary[] getPlatformProperties() {
        return this.platformAdmin.getSystemState().getPlatformProperties();
    }

    public ExportPackageDescription linkDynamicImport(BundleDescription importingBundle, String requestedPackage) {
        throw new UnsupportedOperationException();
    }

    public void setTimeStamp(long timeStamp) {
        throw new UnsupportedOperationException();
    }

    public ExportPackageDescription[] getSystemPackages() {
        return this.platformAdmin.getSystemState().getSystemPackages();
    }

    public void addResolverError(BundleDescription bundle, int type, String data, VersionConstraint unsatisfied) {
        throw new UnsupportedOperationException();
    }

    public ResolverError[] getResolverErrors(BundleDescription bundle) {
        return this.platformAdmin.getSystemState().getResolverErrors(bundle);
    }

    public void removeResolverErrors(BundleDescription bundle) {
        throw new UnsupportedOperationException();
    }

    public StateHelper getStateHelper() {
        return StateHelperImpl.getInstance();
    }

    public long getHighestBundleId() {
        return this.platformAdmin.getSystemState().getHighestBundleId();
    }

    public void setNativePathsInvalid(NativeCodeDescription nativeCodeDescription, boolean hasInvalidPaths) {
        throw new UnsupportedOperationException();
    }

    public BundleDescription[] getDisabledBundles() {
        return this.platformAdmin.getSystemState().getDisabledBundles();
    }

    public void addDisabledInfo(DisabledInfo disabledInfo) {
        throw new UnsupportedOperationException();
    }

    public DisabledInfo[] getDisabledInfos(BundleDescription bundle) {
        return this.platformAdmin.getSystemState().getDisabledInfos(bundle);
    }

    public DisabledInfo getDisabledInfo(BundleDescription bundle, String policyName) {
        return this.platformAdmin.getSystemState().getDisabledInfo(bundle, policyName);
    }

    public void removeDisabledInfo(DisabledInfo disabledInfo) {
        throw new UnsupportedOperationException();
    }

    public BundleDescription[] getRemovalPending() {
        throw new UnsupportedOperationException();
    }

    public Collection<BundleDescription> getDependencyClosure(Collection<BundleDescription> bundles) {
        return this.platformAdmin.getSystemState().getDependencyClosure(bundles);
    }

    public void addDynamicImportPackages(BundleDescription importingBundle, ImportPackageSpecification[] dynamicImports) {
        throw new UnsupportedOperationException();
    }

    public void setResolverHookFactory(ResolverHookFactory hookFactory) {
    }
}

