/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.debugging.model;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.debugging.DynamicContentEditorInput;
import org.eclipse.ease.debugging.model.EaseDebugLastExecutionResult;
import org.eclipse.ease.debugging.model.EaseDebugVariable;
import org.eclipse.ease.debugging.model.EaseJavaFieldVariable;
import org.eclipse.ease.ui.Activator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractEaseDebugModelPresentation
implements ILabelProvider {
    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image getImage(Object element) {
        if (element instanceof EaseDebugVariable) {
            if (element instanceof EaseDebugLastExecutionResult) {
                if (((EaseDebugLastExecutionResult)element).isException()) {
                    return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/debug_method_return_exception.png", true);
                }
                if (ScriptResult.VOID.equals(((EaseDebugVariable)element).getValue().getValue())) {
                    return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/debug_method_return_null.png", true);
                }
                return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/debug_method_return_value.png", true);
            }
            switch (((EaseDebugVariable)element).getType()) {
                case JAVA_OBJECT: {
                    if (element instanceof EaseJavaFieldVariable) {
                        String imageName = "/icons/eobj16/debug_";
                        imageName = ((EaseJavaFieldVariable)element).isPublic() ? String.valueOf(imageName) + "public" : (((EaseJavaFieldVariable)element).isPrivate() ? String.valueOf(imageName) + "private" : String.valueOf(imageName) + "protected");
                        if (((EaseJavaFieldVariable)element).isFinal()) {
                            imageName = String.valueOf(imageName) + "_final";
                        }
                        imageName = String.valueOf(imageName) + "_field.png";
                        return Activator.getImage("org.eclipse.ease.ui", imageName, true);
                    }
                    return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/debug_java_class.png", true);
                }
                case PRIMITIVE: 
                case NATIVE: {
                    return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/debug_local_variable.png", true);
                }
                case NATIVE_ARRAY: {
                    return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/debug_local_array.png", true);
                }
                case NATIVE_OBJECT: {
                    return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/debug_local_object.png", true);
                }
            }
            return null;
        }
        return null;
    }

    public String getText(Object element) {
        return element.toString();
    }

    public void setAttribute(String attribute, Object value) {
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof Script) {
            Object file = ((Script)element).getFile();
            if (file instanceof IFile) {
                return new FileEditorInput((IFile)file);
            }
            if (file instanceof File) {
                try {
                    return new FileStoreEditorInput(EFS.getStore((URI)((File)file).toURI()));
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return new DynamicContentEditorInput((Script)element);
        }
        return null;
    }
}

