/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDAdvancedPagingProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.util.Messages;
import org.eclipse.ui.IViewPart;

public class PagesDialog
extends Dialog {
    private ISDAdvancedPagingProvider fProvider = null;
    private TextArea fCurrentPage;
    private Label fTotalPageComment;

    public PagesDialog(IViewPart view, ISDAdvancedPagingProvider provider) {
        super(view.getSite().getShell());
        this.fProvider = provider;
        this.setShellStyle(67680);
    }

    public Control createDialogArea(Composite parent) {
        Group ret = new Group(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        ret.setLayoutData((Object)data);
        ret.setText(Messages.SequenceDiagram_PageNavigation);
        FillLayout fillLayout = new FillLayout(512);
        ret.setLayout((Layout)fillLayout);
        Label label = new Label((Composite)ret, 0);
        label.setText(Messages.SequenceDiagram_CurrentPage);
        this.fCurrentPage = new TextArea((Composite)ret);
        this.fCurrentPage.setBounds(1, this.fProvider.pagesCount());
        this.fCurrentPage.setValue(this.fProvider.currentPage() + 1);
        this.fTotalPageComment = new Label((Composite)ret, 0);
        this.fTotalPageComment.setAlignment(131072);
        this.updateComments();
        this.getShell().setText(Messages.SequenceDiagram_SequenceDiagramPages);
        return ret;
    }

    public void okPressed() {
        int currentPageValue = this.fCurrentPage.getValue() - 1;
        super.close();
        this.fProvider.pageNumberChanged(currentPageValue);
    }

    private void updateComments() {
        int pages = Math.max(0, this.fProvider.pagesCount());
        StringBuffer totalPageCommentText = new StringBuffer();
        totalPageCommentText.append(Messages.SequenceDiagram_Total);
        totalPageCommentText.append(pages);
        totalPageCommentText.append(" ");
        if (pages == 0) {
            totalPageCommentText.append(Messages.SequenceDiagram_pages);
        } else if (pages == 1) {
            totalPageCommentText.append(Messages.SequenceDiagram_page);
        } else {
            totalPageCommentText.append(Messages.SequenceDiagram_pages);
        }
        this.fTotalPageComment.setText(totalPageCommentText.toString());
    }

    protected static class TextArea {
        private Text fText;
        private int fMin;
        private int fMax;

        public TextArea(Composite parent) {
            this.fText = new Text(parent, 133124);
            this.fText.setTextLimit(10);
        }

        public void setValue(int page) {
            int value = Math.max(this.fMin, Math.min(this.fMax, page));
            this.fText.setText(Integer.toString(value));
        }

        public int getValue() {
            int res;
            try {
                res = Integer.parseInt(this.fText.getText());
            }
            catch (Exception exception) {
                res = 0;
            }
            return Math.max(this.fMin, Math.min(this.fMax, res));
        }

        public void setBounds(int min, int max) {
            this.fMin = Math.max(0, min);
            this.fMax = Math.max(this.fMin, max);
            Object[] tab = new Integer[]{this.fMin, this.fMax};
            this.fText.setToolTipText(MessageFormat.format(Messages.SequenceDiagram_IsInBetween, tab));
        }
    }
}

