/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.traceeventlogger;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.tracecompass.traceeventlogger.beans.TraceEventLoggerManager;

public final class LogUtils {
    private static final Format FORMAT = new DecimalFormat("#.###");
    private static final String ARGS = "args";
    private static final String NAME = "name";
    private static final String CATEGORY = "cat";
    private static final String ID = "id";
    private static final String TID = "tid";
    private static final String PID = "pid";
    private static final String TIMESTAMP = "ts";
    private static final String PHASE = "ph";
    private static final String ARGS_ERROR_MESSAGE = "Data should be in the form of key, value, key1, value1, ... Trace Event Scope Log was supplied ";
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);

    private LogUtils() {
    }

    public static int traceObjectCreation(Logger logger, Level level, Object item) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        int identityHashCode = System.identityHashCode(item);
        char phase = 'N';
        Supplier<String> msgSupplier = () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            LogUtils.appendCommon(sb, phase, time, threadId);
            LogUtils.appendName(sb, item.getClass().getSimpleName());
            LogUtils.appendId(sb, identityHashCode);
            return sb.append('}').toString();
        };
        logger.log(new TraceEventLogRecord(level, msgSupplier, time, Character.valueOf(phase), threadId));
        return identityHashCode;
    }

    public static void traceObjectDestruction(Logger logger, Level level, Object item) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        char phase = 'D';
        Supplier<String> msgSupplier = () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            LogUtils.appendCommon(sb, phase, time, threadId);
            LogUtils.appendName(sb, item.getClass().getSimpleName());
            LogUtils.appendId(sb, System.identityHashCode(item));
            return sb.append('}').toString();
        };
        logger.log(new TraceEventLogRecord(level, msgSupplier, time, Character.valueOf(phase), threadId));
    }

    public static void traceObjectDestruction(Logger logger, Level level, Object item, int uniqueId) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        char phase = 'D';
        Supplier<String> msgSupplier = () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            LogUtils.appendCommon(sb, phase, time, threadId);
            LogUtils.appendName(sb, item.getClass().getSimpleName());
            LogUtils.appendId(sb, uniqueId);
            return sb.append('}').toString();
        };
        logger.log(new TraceEventLogRecord(level, msgSupplier, time, Character.valueOf(phase), threadId));
    }

    public static void traceAsyncStart(Logger logger, Level level, String name, String category, int id, Object ... args) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        char phase = 'b';
        LogUtils.validateArgs(args);
        Supplier<String> msgSupplier = () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            LogUtils.appendCommon(sb, phase, time, threadId);
            LogUtils.appendName(sb, name);
            LogUtils.appendCategory(sb, category);
            LogUtils.appendId(sb, id);
            return LogUtils.appendArgs(sb, args).append('}').toString();
        };
        logger.log(new TraceEventLogRecord(level, msgSupplier, time, Character.valueOf(phase), threadId));
    }

    public static void traceAsyncNested(Logger logger, Level level, String name, String category, int id, Object ... args) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        char phase = 'n';
        LogUtils.validateArgs(args);
        Supplier<String> msgSupplier = () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            LogUtils.appendCommon(sb, phase, time, threadId);
            LogUtils.appendName(sb, name);
            LogUtils.appendCategory(sb, category);
            LogUtils.appendId(sb, id);
            return LogUtils.appendArgs(sb, args).append('}').toString();
        };
        logger.log(new TraceEventLogRecord(level, msgSupplier, time, Character.valueOf(phase), threadId));
    }

    public static void traceAsyncEnd(Logger logger, Level level, String name, String category, int id, Object ... args) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        char phase = 'e';
        LogUtils.validateArgs(args);
        Supplier<String> msgSupplier = () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            LogUtils.appendCommon(sb, phase, time, threadId);
            LogUtils.appendName(sb, name);
            LogUtils.appendCategory(sb, category);
            LogUtils.appendId(sb, id);
            return LogUtils.appendArgs(sb, args).append('}').toString();
        };
        logger.log(new TraceEventLogRecord(level, msgSupplier, time, Character.valueOf(phase), threadId));
    }

    public static void traceInstant(Logger logger, Level level, String name, Object ... args) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        char phase = 'i';
        LogUtils.validateArgs(args);
        Supplier<String> msgSupplier = () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            LogUtils.appendCommon(sb, phase, time, threadId);
            LogUtils.appendName(sb, name);
            return LogUtils.appendArgs(sb, args).append('}').toString();
        };
        logger.log(new TraceEventLogRecord(level, msgSupplier, time, Character.valueOf(phase), threadId));
    }

    public static void traceCounter(Logger logger, Level level, String name, Object ... args) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        char phase = 'C';
        LogUtils.validateArgs(args);
        Supplier<String> msgSupplier = () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            LogUtils.appendCommon(sb, phase, time, threadId);
            LogUtils.appendName(sb, name);
            return LogUtils.appendArgs(sb, args).append('}').toString();
        };
        logger.log(new TraceEventLogRecord(level, msgSupplier, time, Character.valueOf(phase), threadId));
    }

    public static void traceMarker(Logger logger, Level level, String name, long duration, Object ... args) {
        long time = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        char phase = 'R';
        LogUtils.validateArgs(args);
        Supplier<String> msgSupplier = () -> {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            LogUtils.appendCommon(sb, phase, time, threadId);
            LogUtils.appendName(sb, name);
            sb.append(',');
            LogUtils.writeObject(sb, "dur", duration);
            return LogUtils.appendArgs(sb, args).append('}').toString();
        };
        logger.log(new TraceEventLogRecord(level, msgSupplier, time, Character.valueOf(phase), threadId));
    }

    private static StringBuilder appendCommon(StringBuilder appendTo, char phase, long time, long threadId) {
        LogUtils.writeObject(appendTo, TIMESTAMP, FORMAT.format((double)time / 1000.0)).append(',');
        LogUtils.writeObject(appendTo, PHASE, Character.valueOf(phase)).append(',');
        LogUtils.writeObject(appendTo, TID, threadId).append(',');
        return LogUtils.writeObject(appendTo, PID, threadId);
    }

    private static StringBuilder appendName(StringBuilder sb, String name) {
        if (name != null) {
            sb.append(',');
            LogUtils.writeObject(sb, NAME, name);
        }
        return sb;
    }

    private static StringBuilder appendCategory(StringBuilder sb, String category) {
        if (category != null) {
            sb.append(',');
            LogUtils.writeObject(sb, CATEGORY, category);
        }
        return sb;
    }

    private static StringBuilder appendId(StringBuilder sb, int id) {
        return sb.append(',').append('\"').append(ID).append("\":\"0x").append(Integer.toHexString(id)).append('\"');
    }

    private static StringBuilder appendArgs(StringBuilder sb, Map<String, Object> args) {
        if (!args.isEmpty()) {
            sb.append(',').append('\"').append(ARGS).append('\"').append(':');
            Object[] argsArray = new Object[2 * args.size()];
            Iterator<Map.Entry<String, Object>> entryIter = args.entrySet().iterator();
            for (int i = 0; i < args.size(); ++i) {
                Map.Entry<String, Object> entry = entryIter.next();
                argsArray[i] = entry.getKey();
                argsArray[i + 1] = entry.getValue();
            }
            LogUtils.getArgs(sb, argsArray);
        }
        return sb;
    }

    private static StringBuilder appendArgs(StringBuilder sb, Object ... args) {
        if (args.length > 0) {
            sb.append(',').append('\"').append(ARGS).append('\"').append(':');
            LogUtils.getArgs(sb, args);
        }
        return sb;
    }

    private static void validateArgs(Object[] data) {
        if (data.length == 1) {
            return;
        }
        if (data.length % 2 != 0) {
            throw new IllegalArgumentException("Data should be in the form of key, value, key1, value1, ... Trace Event Scope Log was supplied an odd number of messages" + Arrays.asList(data).toString());
        }
        HashSet<String> tester = new HashSet<String>();
        for (int i = 0; i < data.length - 1; i += 2) {
            String keyVal = String.valueOf(data[i]);
            if (tester.contains(keyVal)) {
                throw new IllegalArgumentException("Data should be in the form of key, value, key1, value1, ... Trace Event Scope Log was supplied an duplicate field names : " + keyVal);
            }
            tester.add(keyVal);
        }
    }

    private static StringBuilder getArgs(StringBuilder appendTo, Object[] data) {
        if (data.length == 0) {
            return appendTo;
        }
        LogUtils.validateArgs(data);
        appendTo.append('{');
        if (data.length == 1) {
            appendTo.append("\"msg\":\"").append(data[0]).append('\"');
        } else {
            for (int i = 0; i < data.length - 1; i += 2) {
                Object value = data[i + 1];
                String keyVal = String.valueOf(data[i]);
                if (i > 0) {
                    appendTo.append(',');
                }
                LogUtils.writeObject(appendTo, keyVal, value);
            }
        }
        return appendTo.append('}');
    }

    private static StringBuilder writeObject(StringBuilder appendTo, Object key, Object value) {
        appendTo.append('\"').append(key).append('\"').append(':');
        if (value instanceof Number) {
            appendTo.append(value);
        } else {
            appendTo.append('\"').append(String.valueOf(value)).append('\"');
        }
        return appendTo;
    }

    public static class TraceEventLogRecord
    extends LogRecord {
        private static final long serialVersionUID = 8970603767997599454L;
        private final transient Supplier<String> fSupplier;
        private String fMessage = null;

        public TraceEventLogRecord(Level level, Supplier<String> supplier, Object ... parameters) {
            super(level, "");
            this.fSupplier = supplier;
            this.setParameters(parameters);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getMessage() {
            TraceEventLogRecord traceEventLogRecord = this;
            synchronized (traceEventLogRecord) {
                String msg = this.fMessage;
                if (msg == null) {
                    this.fMessage = msg = Objects.requireNonNull(this.fSupplier.get());
                }
                return msg;
            }
        }
    }

    public static class FlowScopeLog
    implements IFlowScopeLog,
    AutoCloseable {
        private final long fThreadId;
        private final Logger fLogger;
        private final Level fLevel;
        private final int fId;
        private final String fCategory;
        private final Map<String, Object> fData = new HashMap<String, Object>();
        private final String fLabel;
        private final long fTime = System.nanoTime();

        private FlowScopeLog(Logger log, Level level, String label, String category, int id, boolean startFlow, Object ... args) {
            this.fId = id;
            this.fLogger = log;
            this.fLevel = level;
            this.fCategory = category;
            this.fLabel = label;
            this.fThreadId = Thread.currentThread().getId();
            char phaseB = 'B';
            LogUtils.validateArgs(args);
            Supplier<String> msgSupplier = () -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                LogUtils.appendCommon(sb, phaseB, this.fTime, this.fThreadId);
                LogUtils.appendName(sb, this.fLabel);
                LogUtils.appendArgs(sb, args);
                sb.append('}');
                return sb.toString();
            };
            this.fLogger.log(new TraceEventLogRecord(this.fLevel, msgSupplier, this.fTime, Character.valueOf(phaseB), this.fThreadId));
            char phase = startFlow ? (char)'s' : 't';
            msgSupplier = () -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                LogUtils.appendCommon(sb, phase, this.fTime, this.fThreadId);
                LogUtils.appendName(sb, label);
                LogUtils.appendCategory(sb, category);
                LogUtils.appendId(sb, this.fId);
                LogUtils.appendArgs(sb, args);
                sb.append('}');
                return sb.toString();
            };
            this.fLogger.log(new TraceEventLogRecord(this.fLevel, msgSupplier, this.fTime, Character.valueOf(phase), this.fThreadId));
        }

        public void step(String label, Object ... args) {
            long time = System.nanoTime();
            char phase = 't';
            LogUtils.validateArgs(args);
            Supplier<String> msgSupplier = () -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                LogUtils.appendCommon(sb, phase, time, this.fThreadId);
                LogUtils.appendName(sb, label);
                LogUtils.appendCategory(sb, this.fCategory);
                LogUtils.appendId(sb, this.fId);
                LogUtils.appendArgs(sb, args);
                sb.append('}');
                return sb.toString();
            };
            this.fLogger.log(new TraceEventLogRecord(this.fLevel, msgSupplier, time, Character.valueOf(phase), this.fThreadId));
        }

        public void addData(String name, Object value) {
            this.fData.put(name, value);
        }

        @Override
        public String getCategory() {
            return this.fCategory;
        }

        @Override
        public int getId() {
            return this.fId;
        }

        @Override
        public void close() {
            long time = System.nanoTime();
            char phase = 'E';
            Supplier<String> msgSupplier = () -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                LogUtils.appendCommon(sb, phase, time, this.fThreadId);
                LogUtils.appendArgs(sb, this.fData);
                sb.append('}');
                return sb.toString();
            };
            this.fLogger.log(new TraceEventLogRecord(this.fLevel, msgSupplier, time, Character.valueOf(phase), this.fThreadId));
            TraceEventLoggerManager.getInstance().update(this.fLabel, time - this.fTime);
        }
    }

    public static class FlowScopeLogBuilder {
        private final Logger fLogger;
        private final Level fLevel;
        private final String fLabel;
        private final Object[] fArgs;
        private int fId = Integer.MIN_VALUE;
        private String fCategory = null;
        private IFlowScopeLog fParent = null;
        private boolean fHasParent = false;

        public FlowScopeLogBuilder(Logger logger, Level level, String label, Object ... args) {
            this.fLogger = logger;
            this.fLevel = level;
            this.fLabel = label;
            this.fArgs = args;
            LogUtils.validateArgs(args);
        }

        public FlowScopeLogBuilder setCategory(String category) {
            if (this.fParent != null) {
                throw new IllegalStateException("FlowScopeLogBuilder: Cannot set a category if a parent has already been set");
            }
            this.fCategory = category;
            return this;
        }

        public FlowScopeLogBuilder setCategoryAndId(String category, int id) {
            if (this.fParent != null) {
                throw new IllegalStateException("FlowScopeLogBuilder: Cannot set a category if a parent has already been set");
            }
            this.fCategory = category;
            this.fId = id;
            this.fHasParent = true;
            return this;
        }

        public FlowScopeLogBuilder setParentScope(IFlowScopeLog parent) {
            if (this.fCategory != null) {
                throw new IllegalStateException("FlowScopeLogBuilder: Cannot set a parent scope if a category has already been set");
            }
            this.fParent = parent;
            return this;
        }

        public FlowScopeLog build() {
            IFlowScopeLog parent = this.fParent;
            if (parent != null) {
                return new FlowScopeLog(this.fLogger, this.fLevel, this.fLabel, parent.getCategory(), parent.getId(), false, this.fArgs);
            }
            return new FlowScopeLog(this.fLogger, this.fLevel, this.fLabel, String.valueOf(this.fCategory), this.fId == Integer.MIN_VALUE ? ID_GENERATOR.incrementAndGet() : this.fId, !this.fHasParent, this.fArgs);
        }
    }

    public static class ScopeLog
    implements AutoCloseable {
        private final long fTime;
        private final long fThreadId;
        private final Logger fLogger;
        private final Level fLevel;
        private final String fLabel;
        private final Map<String, Object> fData = new HashMap<String, Object>();

        public ScopeLog(Logger log, Level level, String label, Object ... args) {
            this.fTime = System.nanoTime();
            this.fLogger = log;
            this.fLevel = level;
            this.fThreadId = Thread.currentThread().getId();
            this.fLabel = label;
            char phase = 'B';
            LogUtils.validateArgs(args);
            Supplier<String> msgSupplier = () -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                LogUtils.appendCommon(sb, phase, this.fTime, this.fThreadId);
                LogUtils.appendName(sb, this.fLabel);
                LogUtils.appendArgs(sb, args);
                sb.append('}');
                return sb.toString();
            };
            this.fLogger.log(new TraceEventLogRecord(this.fLevel, msgSupplier, this.fTime, Character.valueOf(phase), this.fThreadId));
        }

        public void addData(String name, Object value) {
            this.fData.put(name, value);
        }

        @Override
        public void close() {
            long time = System.nanoTime();
            char phase = 'E';
            Supplier<String> msgSupplier = () -> {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                LogUtils.appendCommon(sb, phase, time, this.fThreadId);
                return LogUtils.appendArgs(sb, this.fData).append('}').toString();
            };
            this.fLogger.log(new TraceEventLogRecord(this.fLevel, msgSupplier, time, Character.valueOf(phase), this.fThreadId));
            TraceEventLoggerManager.getInstance().update(this.fLabel, time - this.fTime);
        }
    }

    public static interface IFlowScopeLog {
        public String getCategory();

        public int getId();
    }
}

