/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.project.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.tests.shared.ProjectModelTestData;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitTimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectModelTraceTest {
    private TmfProjectElement fixture;

    @Before
    public void setUp() {
        try {
            this.fixture = ProjectModelTestData.getFilledProject();
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void cleanUp() {
        ProjectModelTestData.deleteProject(this.fixture);
    }

    @Test
    public void testOpenTrace() {
        Assert.assertNotNull((Object)this.fixture);
        TmfTraceFolder tracesFolder = this.fixture.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        TmfTraceElement traceElement = (TmfTraceElement)tracesFolder.getTraces().get(0);
        ITmfTrace trace = traceElement.getTrace();
        Assert.assertNull((Object)trace);
        TmfOpenTraceHelper.openFromElement((TmfCommonProjectElement)traceElement);
        try {
            ProjectModelTestData.delayUntilTraceOpened((TmfCommonProjectElement)traceElement);
        }
        catch (WaitTimeoutException e) {
            Assert.fail((String)"The trace did not open in a reasonable delay");
        }
        trace = traceElement.getTrace();
        Assert.assertNotNull((Object)trace);
        TmfOpenTraceHelper.openFromElement((TmfCommonProjectElement)traceElement);
        try {
            ProjectModelTestData.delayUntilTraceOpened((TmfCommonProjectElement)traceElement);
        }
        catch (WaitTimeoutException e) {
            Assert.fail((String)"The trace did not open in a reasonable delay");
        }
        ITmfTrace trace2 = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertTrue((trace2 == trace ? 1 : 0) != 0);
        trace = traceElement.getTrace();
        Assert.assertTrue((trace2 == trace ? 1 : 0) != 0);
        traceElement.closeEditors();
    }
}

