/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Polygon;

public class CubicCurve
extends BezierCurve {
    private static final long serialVersionUID = 1L;

    public CubicCurve(double ... coordinates) {
        this(coordinates[0], coordinates[1], coordinates[2], coordinates[3], coordinates[4], coordinates[5], coordinates[6], coordinates[7]);
        if (coordinates.length != 8) {
            throw new IllegalArgumentException("A CubicCurve may only be defined by 8 coordinates (4 points), while " + coordinates.length + " were passed in.");
        }
    }

    public CubicCurve(double x1, double y1, double ctrl1X, double ctrl1Y, double ctrl2X, double ctrl2Y, double x2, double y2) {
        super(x1, y1, ctrl1X, ctrl1Y, ctrl2X, ctrl2Y, x2, y2);
    }

    public CubicCurve(Point ... points) {
        this(points[0].x, points[0].y, points[1].x, points[1].y, points[2].x, points[2].y, points[3].x, points[3].y);
        if (points.length != 4) {
            throw new IllegalArgumentException("A CubicCurve may only be defined by 4 points, while " + points.length + " were passed in.");
        }
    }

    public CubicCurve(Point start, Point ctrl1, Point ctrl2, Point end) {
        this(start.x, start.y, ctrl1.x, ctrl1.y, ctrl2.x, ctrl2.y, end.x, end.y);
    }

    @Override
    public boolean equals(Object other) {
        CubicCurve o = (CubicCurve)other;
        Polygon myPoly = this.getControlPolygon();
        Polygon otherPoly = o.getControlPolygon();
        return myPoly.equals(otherPoly);
    }

    private Polygon getControlPolygon() {
        return new Polygon(this.getP1(), this.getCtrl1(), this.getCtrl2(), this.getP2());
    }

    @Override
    public CubicCurve getCopy() {
        return new CubicCurve(this.getP1(), this.getCtrl1(), this.getCtrl2(), this.getP2());
    }

    public Point getCtrl1() {
        return new Point(this.getCtrlX1(), this.getCtrlY1());
    }

    public Point getCtrl2() {
        return new Point(this.getCtrlX2(), this.getCtrlY2());
    }

    public double getCtrlX1() {
        return this.getPoint((int)1).x;
    }

    public double getCtrlX2() {
        return this.getPoint((int)2).x;
    }

    public double getCtrlY1() {
        return this.getPoint((int)1).y;
    }

    public double getCtrlY2() {
        return this.getPoint((int)2).y;
    }

    @Override
    public CubicCurve getTransformed(AffineTransform t) {
        return new CubicCurve(t.getTransformed(this.getPoints()));
    }

    public CubicCurve setCtrl1(Point ctrl1) {
        this.setCtrl1X(ctrl1.x);
        this.setCtrl1Y(ctrl1.y);
        return this;
    }

    public CubicCurve setCtrl1X(double ctrl1x) {
        this.setPoint(1, new Point(ctrl1x, this.getCtrlY1()));
        return this;
    }

    public CubicCurve setCtrl1Y(double ctrl1y) {
        this.setPoint(1, new Point(this.getCtrlX1(), ctrl1y));
        return this;
    }

    public CubicCurve setCtrl2(Point ctrl2) {
        this.setCtrl2X(ctrl2.x);
        this.setCtrl2Y(ctrl2.y);
        return this;
    }

    public CubicCurve setCtrl2X(double ctrl2x) {
        this.setPoint(2, new Point(ctrl2x, this.getCtrlY2()));
        return this;
    }

    public CubicCurve setCtrl2Y(double ctrl2y) {
        this.setPoint(2, new Point(this.getCtrlX2(), ctrl2y));
        return this;
    }

    public CubicCurve setCurve(Point p1, Point ctrl1, Point ctrl2, Point p2) {
        this.setP1(p1);
        this.setCtrl1(ctrl1);
        this.setCtrl2(ctrl2);
        this.setP2(p2);
        return this;
    }

    public CubicCurve[] split(double t) {
        BezierCurve[] split = super.split(t);
        return new CubicCurve[]{split[0].toCubic(), split[1].toCubic()};
    }

    @Override
    public Path toPath() {
        Path p = new Path();
        p.moveTo(this.getX1(), this.getY1());
        p.cubicTo(this.getCtrlX1(), this.getCtrlY1(), this.getCtrlX2(), this.getCtrlY2(), this.getX2(), this.getY2());
        return p;
    }

    @Override
    public String toString() {
        return "CubicCurve(x1 = " + this.getX1() + ", y1 = " + this.getY1() + ", ctrl1X = " + this.getCtrlX1() + ", ctrl1Y = " + this.getCtrlY1() + ", ctrl2X = " + this.getCtrlX2() + ", ctrl2Y = " + this.getCtrlY2() + ", x2 = " + this.getX2() + ", y2 = " + this.getY2();
    }
}

