/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.CubicCurve;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IMultiShape;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.QuadraticCurve;

class CurveUtils {
    public static BezierCurve[] getCopy(BezierCurve ... curves) {
        BezierCurve[] copies = new BezierCurve[curves.length];
        int i = 0;
        while (i < curves.length) {
            copies[i] = curves[i].getCopy();
            ++i;
        }
        return copies;
    }

    public static Point[] getIntersections(ICurve curve1, ICurve curve2) {
        HashSet<Point> intersections = new HashSet<Point>();
        BezierCurve[] bezierCurveArray = curve1.toBezier();
        int n = bezierCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve bezier = bezierCurveArray[n2];
            intersections.addAll(Arrays.asList(bezier.getIntersections(curve2)));
            ++n2;
        }
        return intersections.toArray(new Point[0]);
    }

    public static Point[] getIntersections(ICurve curve, IGeometry geom) {
        if (geom instanceof ICurve) {
            return CurveUtils.getIntersections(curve, (ICurve)geom);
        }
        if (geom instanceof IShape) {
            return CurveUtils.getIntersections(curve, (IShape)geom);
        }
        if (geom instanceof IMultiShape) {
            return CurveUtils.getIntersections(curve, (IMultiShape)geom);
        }
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public static Point[] getIntersections(ICurve curve, IMultiShape multiShape) {
        HashSet<Point> intersections = new HashSet<Point>();
        IShape[] iShapeArray = multiShape.getShapes();
        int n = iShapeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IShape shape = iShapeArray[n2];
            intersections.addAll(Arrays.asList(CurveUtils.getIntersections(curve, shape)));
            ++n2;
        }
        return intersections.toArray(new Point[0]);
    }

    public static Point[] getIntersections(ICurve curve, IShape shape) {
        HashSet<Point> intersections = new HashSet<Point>();
        ICurve[] iCurveArray = shape.getOutlineSegments();
        int n = iCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICurve curve2 = iCurveArray[n2];
            intersections.addAll(Arrays.asList(CurveUtils.getIntersections(curve, curve2)));
            ++n2;
        }
        return intersections.toArray(new Point[0]);
    }

    public static Point[] getIntersections(IGeometry geom1, IGeometry geom2) {
        if (geom1 instanceof ICurve) {
            return CurveUtils.getIntersections((ICurve)geom1, geom2);
        }
        HashSet<Point> intersections = new HashSet<Point>();
        if (geom1 instanceof IShape) {
            ICurve[] iCurveArray = ((IShape)geom1).getOutlineSegments();
            int n = iCurveArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICurve curve = iCurveArray[n2];
                intersections.addAll(Arrays.asList(CurveUtils.getIntersections(curve, geom2)));
                ++n2;
            }
        } else if (geom1 instanceof IMultiShape) {
            IShape[] iShapeArray = ((IMultiShape)geom1).getShapes();
            int n = iShapeArray.length;
            int n3 = 0;
            while (n3 < n) {
                IShape shape = iShapeArray[n3];
                ICurve[] iCurveArray = shape.getOutlineSegments();
                int n4 = iCurveArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    ICurve curve = iCurveArray[n5];
                    intersections.addAll(Arrays.asList(CurveUtils.getIntersections(curve, geom2)));
                    ++n5;
                }
                ++n3;
            }
        } else {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        return intersections.toArray(new Point[0]);
    }

    public static boolean intersects(ICurve c1, ICurve c2) {
        return CurveUtils.getIntersections(c1, c2).length > 0;
    }

    public static boolean overlaps(ICurve c1, ICurve c2) {
        BezierCurve[] bezierCurveArray = c1.toBezier();
        int n = bezierCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve seg1 = bezierCurveArray[n2];
            BezierCurve[] bezierCurveArray2 = c2.toBezier();
            int n3 = bezierCurveArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                BezierCurve seg2 = bezierCurveArray2[n4];
                if (seg1.overlaps(seg2)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Path toPath(ICurve ... curves) {
        Path p = new Path();
        int i = 0;
        while (i < curves.length) {
            ICurve c = curves[i];
            if (i == 0) {
                p.moveTo(c.getX1(), c.getY1());
            }
            if (c instanceof Line) {
                p.lineTo(c.getX2(), c.getY2());
            } else if (c instanceof QuadraticCurve) {
                p.quadTo(((QuadraticCurve)c).getCtrlX(), ((QuadraticCurve)c).getCtrlY(), c.getX2(), c.getY2());
            } else if (c instanceof CubicCurve) {
                p.cubicTo(((CubicCurve)c).getCtrlX1(), ((CubicCurve)c).getCtrlY1(), ((CubicCurve)c).getCtrlX2(), ((CubicCurve)c).getCtrlY2(), ((CubicCurve)c).getX2(), ((CubicCurve)c).getY2());
            } else {
                if (!(c instanceof BezierCurve)) throw new UnsupportedOperationException("This type of ICurve is not yet implemented: toPath(" + curves + ")");
                Point[] points = ((BezierCurve)c).getPoints();
                int length = points.length;
                if (length == 1) {
                    p.moveTo(c.getX1(), c.getY1());
                } else if (length == 2) {
                    p.lineTo(c.getX2(), c.getY2());
                } else if (length == 3) {
                    p.quadTo(points[1].x, points[1].y, points[2].x, points[2].y);
                } else {
                    if (length != 4) throw new UnsupportedOperationException("A BezierCurve with more than 4 control points cannot be integrated in a Path. Only singular, linear, quadratic, or cubic BezierCurves can be integrated in a Path.");
                    p.cubicTo(points[1].x, points[1].y, points[2].x, points[2].y, points[3].x, points[3].y);
                }
            }
            ++i;
        }
        return p;
    }

    public static Line[] toSegmentsArray(Point[] points, boolean close) {
        int segmentCount = close ? points.length : points.length - 1;
        Line[] segments = new Line[segmentCount];
        int i = 0;
        while (i < segmentCount) {
            segments[i] = new Line(points[i], points[i + 1 < points.length ? i + 1 : 0]);
            ++i;
        }
        return segments;
    }

    private CurveUtils() {
    }
}

