/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.CubicCurve;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IMultiShape;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.PolyBezier;
import org.eclipse.gef4.geometry.utils.PrecisionUtils;

class ShapeUtils {
    public static CubicCurve computeEllipticalArcApproximation(double x, double y, double width, double height, Angle start, Angle end) {
        if (!PrecisionUtils.smallerEqual(end.getAdded(start.getOppositeFull()).deg(), 90.0)) {
            throw new IllegalArgumentException("Only angular extents of up to 90 degrees are allowed.");
        }
        double a = width / 2.0;
        double b = height / 2.0;
        double srad = start.rad();
        double erad = end.rad();
        Point startPoint = new Point(x + a + a * Math.cos(srad), y + b - b * Math.sin(srad));
        Point endPoint = new Point(x + a + a * Math.cos(erad), y + b - b * Math.sin(erad));
        double t = Math.tan((erad - srad) / 2.0);
        double alpha = Math.sin(erad - srad) * (Math.sqrt(4.0 + 3.0 * t * t) - 1.0) / 3.0;
        Point controlPoint1 = new Point(startPoint.x + alpha * -a * Math.sin(srad), startPoint.y - alpha * b * Math.cos(srad));
        Point controlPoint2 = new Point(endPoint.x - alpha * -a * Math.sin(erad), endPoint.y + alpha * b * Math.cos(erad));
        Point[] points = new Point[]{startPoint, controlPoint1, controlPoint2, endPoint};
        return new CubicCurve(points);
    }

    public static boolean contains(IGeometry geom1, IGeometry geom2) {
        if (geom1 instanceof IShape) {
            return ShapeUtils.contains((IShape)geom1, geom2);
        }
        if (geom1 instanceof IMultiShape) {
            return ShapeUtils.contains((IMultiShape)geom1, geom2);
        }
        return false;
    }

    public static boolean contains(IMultiShape multiShape, BezierCurve c) {
        if (!multiShape.contains(c.getP1()) || !multiShape.contains(c.getP2())) {
            return false;
        }
        HashSet<Double> intersectionParams = new HashSet<Double>();
        ICurve[] iCurveArray = multiShape.getOutlineSegments();
        int n = iCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICurve segC = iCurveArray[n2];
            BezierCurve[] bezierCurveArray = segC.toBezier();
            int n3 = bezierCurveArray.length;
            int n4 = 0;
            while (n4 < n3) {
                BezierCurve seg = bezierCurveArray[n4];
                HashSet<Point> inters = new HashSet<Point>();
                Set<BezierCurve.IntervalPair> ips = c.getIntersectionIntervalPairs(seg, inters);
                for (BezierCurve.IntervalPair ip : ips) {
                    intersectionParams.add(ip.p == c ? ip.pi.getMid() : ip.qi.getMid());
                }
                for (Point poi : inters) {
                    intersectionParams.add(c.getParameterAt(poi));
                }
                ++n4;
            }
            ++n2;
        }
        if (intersectionParams.size() <= 1) {
            return true;
        }
        Double[] poiParams = intersectionParams.toArray(new Double[0]);
        Arrays.sort(poiParams, new Comparator<Double>(){

            @Override
            public int compare(Double t, Double u) {
                double d = t - u;
                return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
            }
        });
        if (!multiShape.contains(c.get(poiParams[0] / 2.0))) {
            return false;
        }
        int i = 0;
        while (i < poiParams.length - 1) {
            if (!multiShape.contains(c.get((poiParams[i] + poiParams[i + 1]) / 2.0))) {
                return false;
            }
            ++i;
        }
        return multiShape.contains(c.get((poiParams[poiParams.length - 1] + 1.0) / 2.0));
    }

    public static boolean contains(IMultiShape ps, ICurve c) {
        BezierCurve[] bezierCurveArray = c.toBezier();
        int n = bezierCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve bc = bezierCurveArray[n2];
            if (!ShapeUtils.contains(ps, bc)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean contains(IMultiShape ps, IGeometry g) {
        if (g instanceof ICurve) {
            return ShapeUtils.contains(ps, (ICurve)g);
        }
        if (g instanceof IShape) {
            return ShapeUtils.contains(ps, (IShape)g);
        }
        if (g instanceof IMultiShape) {
            return ShapeUtils.contains(ps, (IMultiShape)g);
        }
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public static boolean contains(IMultiShape ps, IMultiShape ps2) {
        IShape[] iShapeArray = ps2.getShapes();
        int n = iShapeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IShape s = iShapeArray[n2];
            if (!ShapeUtils.contains(ps, s)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean contains(IMultiShape ps, IShape s) {
        ICurve[] iCurveArray = s.getOutlineSegments();
        int n = iCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICurve c = iCurveArray[n2];
            if (!ShapeUtils.contains(ps, c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean contains(IShape shape, BezierCurve c) {
        if (!shape.contains(c.getP1()) || !shape.contains(c.getP2())) {
            return false;
        }
        HashSet<Double> intersectionParams = new HashSet<Double>();
        ICurve[] iCurveArray = shape.getOutlineSegments();
        int n = iCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICurve segC = iCurveArray[n2];
            BezierCurve[] bezierCurveArray = segC.toBezier();
            int n3 = bezierCurveArray.length;
            int n4 = 0;
            while (n4 < n3) {
                BezierCurve seg = bezierCurveArray[n4];
                HashSet<Point> inters = new HashSet<Point>();
                c.getIntersectionIntervalPairs(seg, inters);
                for (Point poi : inters) {
                    intersectionParams.add(c.getParameterAt(poi));
                }
                ++n4;
            }
            ++n2;
        }
        if (intersectionParams.size() <= 1) {
            return true;
        }
        Double[] poiParams = intersectionParams.toArray(new Double[0]);
        Arrays.sort(poiParams, new Comparator<Double>(){

            @Override
            public int compare(Double t, Double u) {
                double d = t - u;
                return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
            }
        });
        if (!shape.contains(c.get(poiParams[0] / 2.0))) {
            return false;
        }
        int i = 0;
        while (i < poiParams.length - 1) {
            if (!shape.contains(c.get((poiParams[i] + poiParams[i + 1]) / 2.0))) {
                return false;
            }
            ++i;
        }
        return shape.contains(c.get((poiParams[poiParams.length - 1] + 1.0) / 2.0));
    }

    public static boolean contains(IShape shape, ICurve curve) {
        BezierCurve[] bezierCurveArray = curve.toBezier();
        int n = bezierCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve seg = bezierCurveArray[n2];
            if (!ShapeUtils.contains(shape, seg)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean contains(IShape shape, IGeometry geom) {
        if (geom instanceof ICurve) {
            return ShapeUtils.contains(shape, (ICurve)geom);
        }
        if (geom instanceof IShape) {
            return ShapeUtils.contains(shape, (IShape)geom);
        }
        if (geom instanceof IMultiShape) {
            return ShapeUtils.contains(shape, (IMultiShape)geom);
        }
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public static boolean contains(IShape shape, IMultiShape multiShape) {
        IShape[] iShapeArray = multiShape.getShapes();
        int n = iShapeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IShape seg = iShapeArray[n2];
            if (!ShapeUtils.contains(shape, seg)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean contains(IShape shape1, IShape shape2) {
        ICurve[] iCurveArray = shape2.getOutlineSegments();
        int n = iCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICurve seg = iCurveArray[n2];
            if (!ShapeUtils.contains(shape1, seg)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static PolyBezier getOutline(IShape shape) {
        ICurve[] curves = shape.getOutlineSegments();
        ArrayList<BezierCurve> beziers = new ArrayList<BezierCurve>(curves.length);
        ICurve[] iCurveArray = curves;
        int n = curves.length;
        int n2 = 0;
        while (n2 < n) {
            ICurve c = iCurveArray[n2];
            BezierCurve[] bezierCurveArray = c.toBezier();
            int n3 = bezierCurveArray.length;
            int n4 = 0;
            while (n4 < n3) {
                BezierCurve b = bezierCurveArray[n4];
                beziers.add(b);
                ++n4;
            }
            ++n2;
        }
        return new PolyBezier(beziers.toArray(new BezierCurve[0]));
    }

    private ShapeUtils() {
    }
}

