/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.objectives.impl;

import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.objectives.IObjective;
import org.eclipse.viatra.dse.objectives.impl.BaseObjective;

public class DepthHardObjective
extends BaseObjective {
    private static final String DEFAULT_NAME = "DepthHardObjective";
    protected int minDepth;
    protected int maxDepth;
    private ThreadContext context;

    public DepthHardObjective() {
        this(DEFAULT_NAME, 0, Integer.MAX_VALUE);
    }

    public DepthHardObjective(String name) {
        this(name, 0, Integer.MAX_VALUE);
    }

    public DepthHardObjective(int minDepth) {
        this(DEFAULT_NAME, minDepth, Integer.MAX_VALUE);
    }

    public DepthHardObjective(String name, int minDepth) {
        this(name, minDepth, Integer.MAX_VALUE);
    }

    public DepthHardObjective(int minDepth, int maxDepth) {
        this(DEFAULT_NAME, minDepth, maxDepth);
    }

    public DepthHardObjective(String name, int minDepth, int maxDepth) {
        super(name);
        this.minDepth = minDepth;
        this.maxDepth = maxDepth;
    }

    public DepthHardObjective withMinDepth(int minDepth) {
        this.minDepth = minDepth;
        return this;
    }

    public DepthHardObjective withMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    @Override
    public void init(ThreadContext context) {
        super.init(context);
        this.context = context;
    }

    @Override
    public Double getFitness(ThreadContext context) {
        return 0.0;
    }

    @Override
    public boolean isHardObjective() {
        return true;
    }

    @Override
    public boolean satisifiesHardObjective(Double fitness) {
        return this.minDepth <= this.context.getDepth() && this.context.getDepth() <= this.maxDepth;
    }

    @Override
    public IObjective createNew() {
        return new DepthHardObjective(this.name, this.minDepth, this.maxDepth);
    }
}

