/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.eval;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.TimelyMemory;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.rete.eval.AbstractEvaluatorNode;
import org.eclipse.viatra.query.runtime.rete.eval.EvaluatorCore;
import org.eclipse.viatra.query.runtime.rete.matcher.TimelyConfiguration;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.ResumableNode;

public class OutputCachingEvaluatorNode
extends AbstractEvaluatorNode
implements Clearable,
ResumableNode {
    protected NetworkStructureChangeSensitiveLogic logic;
    protected Map<Tuple, Iterable<Tuple>> outputCache;
    protected TimelyMemory<Timestamp> memory;
    protected CommunicationGroup group;
    private final NetworkStructureChangeSensitiveLogic TIMELESS = new NetworkStructureChangeSensitiveLogic(){

        @Override
        public void resumeAt(Timestamp timestamp) {
        }

        @Override
        public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void pullInto(Collection<Tuple> collector, boolean flush) {
            for (Iterable<Tuple> output : OutputCachingEvaluatorNode.this.outputCache.values()) {
                if (output == NORESULT) continue;
                Iterator<Tuple> itr = output.iterator();
                while (itr.hasNext()) {
                    collector.add(itr.next());
                }
            }
        }

        @Override
        public void update(Direction direction, Tuple input, Timestamp timestamp) {
            if (direction == Direction.INSERT) {
                Iterable<Tuple> output = OutputCachingEvaluatorNode.this.core.performEvaluation(input);
                if (output != null) {
                    Iterable<Tuple> previous = OutputCachingEvaluatorNode.this.outputCache.put(input, output);
                    if (previous != null) {
                        throw new IllegalStateException(String.format("Duplicate insertion of tuple %s into node %s", input, this));
                    }
                    OutputCachingEvaluatorNode.this.propagateIterableUpdate(direction, output, timestamp);
                }
            } else {
                Iterable<Tuple> output = OutputCachingEvaluatorNode.this.outputCache.remove(input);
                if (output != null) {
                    OutputCachingEvaluatorNode.this.propagateIterableUpdate(direction, output, timestamp);
                }
            }
        }
    };
    private final NetworkStructureChangeSensitiveLogic TIMELY = new NetworkStructureChangeSensitiveLogic(){

        @Override
        public void resumeAt(Timestamp timestamp) {
            Map diffMap = OutputCachingEvaluatorNode.this.memory.resumeAt((Comparable)timestamp);
            for (Map.Entry entry : diffMap.entrySet()) {
                Tuple input = (Tuple)entry.getKey();
                Iterable<Tuple> output = OutputCachingEvaluatorNode.this.outputCache.get(input);
                if (output != NORESULT) {
                    for (Signed signed : (Diff)entry.getValue()) {
                        OutputCachingEvaluatorNode.this.propagateIterableUpdate(signed.getDirection(), output, (Timestamp)signed.getPayload());
                    }
                }
                if (OutputCachingEvaluatorNode.this.memory.get((ITuple)input) != null) continue;
                OutputCachingEvaluatorNode.this.outputCache.remove(input);
            }
            Timestamp nextTimestamp = (Timestamp)OutputCachingEvaluatorNode.this.memory.getResumableTimestamp();
            if (nextTimestamp != null) {
                OutputCachingEvaluatorNode.this.group.notifyHasMessage(OutputCachingEvaluatorNode.this.mailbox, nextTimestamp);
            }
        }

        @Override
        public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
            for (Map.Entry entry : OutputCachingEvaluatorNode.this.memory.asMap().entrySet()) {
                Tuple input = (Tuple)entry.getKey();
                Iterable<Tuple> output = OutputCachingEvaluatorNode.this.outputCache.get(input);
                if (output == NORESULT) continue;
                Timeline timestamp = (Timeline)entry.getValue();
                Iterator<Tuple> itr = output.iterator();
                while (itr.hasNext()) {
                    collector.put(itr.next(), (Timeline<Timestamp>)timestamp);
                }
            }
        }

        @Override
        public void pullInto(Collection<Tuple> collector, boolean flush) {
            OutputCachingEvaluatorNode.this.TIMELESS.pullInto(collector, flush);
        }

        @Override
        public void update(Direction direction, Tuple input, Timestamp timestamp) {
            block7: {
                block6: {
                    if (direction != Direction.INSERT) break block6;
                    Iterable<Tuple> output = OutputCachingEvaluatorNode.this.outputCache.get(input);
                    if (output == null) {
                        output = OutputCachingEvaluatorNode.this.core.performEvaluation(input);
                        if (output == null) {
                            output = NORESULT;
                        }
                        OutputCachingEvaluatorNode.this.outputCache.put(input, output);
                    }
                    Diff diff = OutputCachingEvaluatorNode.this.memory.put(input, (Comparable)timestamp);
                    if (output == NORESULT) break block7;
                    for (Signed signed : diff) {
                        OutputCachingEvaluatorNode.this.propagateIterableUpdate(signed.getDirection(), output, (Timestamp)signed.getPayload());
                    }
                    break block7;
                }
                Iterable<Tuple> output = OutputCachingEvaluatorNode.this.outputCache.get(input);
                Diff diff = OutputCachingEvaluatorNode.this.memory.remove(input, (Comparable)timestamp);
                if (OutputCachingEvaluatorNode.this.memory.get((ITuple)input) == null) {
                    OutputCachingEvaluatorNode.this.outputCache.remove(input);
                }
                if (output != NORESULT) {
                    for (Signed signed : diff) {
                        OutputCachingEvaluatorNode.this.propagateIterableUpdate(signed.getDirection(), output, (Timestamp)signed.getPayload());
                    }
                }
            }
        }
    };
    private static final Iterable<Tuple> NORESULT = Collections.singleton(Tuples.staticArityFlatTupleOf((Object)((Object)NoResult.INSTANCE)));

    public OutputCachingEvaluatorNode(ReteContainer reteContainer, EvaluatorCore core) {
        super(reteContainer, core);
        reteContainer.registerClearable(this);
        this.outputCache = CollectionsFactory.createMap();
        this.logic = this.createLogic();
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.group;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup group) {
        this.group = group;
    }

    @Override
    public void networkStructureChanged() {
        super.networkStructureChanged();
        this.logic = this.createLogic();
    }

    public void clear() {
        this.outputCache.clear();
        if (this.memory != null) {
            this.memory.clear();
        }
    }

    protected NetworkStructureChangeSensitiveLogic createLogic() {
        if (this.reteContainer.isTimelyEvaluation() && this.reteContainer.getCommunicationTracker().isInRecursiveGroup(this)) {
            if (this.memory == null) {
                this.memory = new TimelyMemory(this.reteContainer.isTimelyEvaluation() && this.reteContainer.getTimelyConfiguration().getTimelineRepresentation() == TimelyConfiguration.TimelineRepresentation.FAITHFUL);
            }
            return this.TIMELY;
        }
        return this.TIMELESS;
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        this.logic.pullInto(collector, flush);
    }

    @Override
    public void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> collector, boolean flush) {
        this.logic.pullIntoWithTimeline(collector, flush);
    }

    @Override
    public void update(Direction direction, Tuple input, Timestamp timestamp) {
        this.logic.update(direction, input, timestamp);
    }

    @Override
    public Timestamp getResumableTimestamp() {
        if (this.memory == null) {
            return null;
        }
        return (Timestamp)this.memory.getResumableTimestamp();
    }

    @Override
    public void resumeAt(Timestamp timestamp) {
        this.logic.resumeAt(timestamp);
    }

    protected static abstract class NetworkStructureChangeSensitiveLogic {
        protected NetworkStructureChangeSensitiveLogic() {
        }

        public abstract void update(Direction var1, Tuple var2, Timestamp var3);

        public abstract void pullInto(Collection<Tuple> var1, boolean var2);

        public abstract void pullIntoWithTimeline(Map<Tuple, Timeline<Timestamp>> var1, boolean var2);

        public abstract void resumeAt(Timestamp var1);
    }

    private static enum NoResult {
        INSTANCE;

    }
}

