/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.contributors.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.virgo.bundlor.support.contributors.xml.ValueAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.XmlArtifactAnalyzer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class StandardXmlArtifactAnalyzer
implements XmlArtifactAnalyzer {
    private final Document document;
    private final NamespaceContext namespaceContext;

    StandardXmlArtifactAnalyzer(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        this(inputStream, null, null);
    }

    StandardXmlArtifactAnalyzer(InputStream inputStream, EntityResolver entityResolver) throws ParserConfigurationException, SAXException, IOException {
        this(inputStream, null, entityResolver);
    }

    StandardXmlArtifactAnalyzer(InputStream inputStream, Map<String, String> namespaceMappings) throws ParserConfigurationException, SAXException, IOException {
        this(inputStream, namespaceMappings, null);
    }

    StandardXmlArtifactAnalyzer(InputStream inputStream, Map<String, String> namespaceMapping, EntityResolver entityResolver) throws ParserConfigurationException, SAXException, IOException {
        this.namespaceContext = this.getNamespaceContext(namespaceMapping);
        this.document = this.getDocument(inputStream, entityResolver);
    }

    @Override
    public void analyzeValues(String expression, ValueAnalyzer analyzer) throws Exception {
        NodeList nodes = (NodeList)this.getXPathExpression(expression).evaluate(this.document, XPathConstants.NODESET);
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 2) {
                this.analyzeRawValue(((Attr)node).getValue(), analyzer);
            } else if (node.getNodeType() == 1) {
                this.analyzeRawValue(((Element)node).getTextContent(), analyzer);
            }
            ++i;
        }
    }

    private void analyzeRawValue(String rawValue, ValueAnalyzer analyzer) {
        if (rawValue.contains(",")) {
            String[] stringArray = rawValue.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String componentValue = stringArray[n2];
                analyzer.analyse(componentValue.trim());
                ++n2;
            }
        } else {
            analyzer.analyse(rawValue.trim());
        }
    }

    private final XPathExpression getXPathExpression(String expressionString) throws XPathExpressionException {
        XPathFactory newInstance = XPathFactory.newInstance();
        XPath xpath = newInstance.newXPath();
        if (this.namespaceContext != null) {
            xpath.setNamespaceContext(this.namespaceContext);
        }
        return xpath.compile(expressionString);
    }

    private NamespaceContext getNamespaceContext(Map<String, String> namespaceMapping) {
        if (namespaceMapping != null) {
            return new MapNamespaceContext(namespaceMapping);
        }
        return null;
    }

    private boolean isNamespaceAware() {
        return this.namespaceContext != null;
    }

    private Document getDocument(InputStream inputStream, EntityResolver entityResolver) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory xmlFact = DocumentBuilderFactory.newInstance();
        xmlFact.setNamespaceAware(this.isNamespaceAware());
        DocumentBuilder builder = xmlFact.newDocumentBuilder();
        if (entityResolver != null) {
            builder.setEntityResolver(entityResolver);
        }
        return builder.parse(new InputSource(inputStream));
    }

    private static final class MapNamespaceContext
    implements NamespaceContext {
        private final Map<String, String> namespaceMapping;

        public MapNamespaceContext(Map<String, String> namespaceMapping) {
            this.namespaceMapping = namespaceMapping;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (this.namespaceMapping != null && this.namespaceMapping.containsKey(prefix)) {
                return this.namespaceMapping.get(prefix);
            }
            return "";
        }

        @Override
        public String getPrefix(String namespace) {
            if (this.namespaceMapping != null && this.namespaceMapping.containsValue(namespace)) {
                for (Map.Entry<String, String> entry : this.namespaceMapping.entrySet()) {
                    if (!namespace.equals(entry.getValue())) continue;
                    return entry.getKey();
                }
            }
            return null;
        }

        public Iterator getPrefixes(String namespace) {
            return null;
        }
    }
}

