/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.virgo.ide.runtime.core.IServerRuntimeWorkingCopy;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiImages;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiPlugin;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class ServerRuntimeComposite
extends Composite {
    protected IRuntimeWorkingCopy runtimeWC;
    protected IServerRuntimeWorkingCopy runtime;
    protected IWizardHandle wizard;
    protected Text installDir;
    protected Text name;
    protected Combo vmCombo;
    protected List<IVMInstall> installedJREs;
    protected String[] jreNames;
    protected IInstallableRuntime ir;
    protected Label installLabel;
    protected Button install;

    protected ServerRuntimeComposite(Composite parent, IWizardHandle wizard, String wizardTitle, String wizardDescription) {
        this(parent, wizard, wizardTitle, wizardDescription, ServerUiImages.DESC_WIZB_SERVER);
    }

    protected ServerRuntimeComposite(Composite parent, IWizardHandle wizard, String wizardTitle, String wizardDescription, ImageDescriptor imageDescriptor) {
        super(parent, 0);
        this.wizard = wizard;
        wizard.setTitle(wizardTitle);
        wizard.setDescription(wizardDescription);
        wizard.setImageDescriptor(imageDescriptor);
        this.createControl();
    }

    protected void setRuntime(IRuntimeWorkingCopy newRuntime) {
        if (newRuntime == null) {
            this.runtimeWC = null;
            this.runtime = null;
        } else {
            this.runtimeWC = newRuntime;
            this.runtime = (IServerRuntimeWorkingCopy)newRuntime.loadAdapter(IServerRuntimeWorkingCopy.class, null);
        }
        if (this.runtimeWC == null) {
            this.ir = null;
            this.install.setEnabled(false);
            this.installLabel.setText("");
        } else {
            this.ir = ServerPlugin.findInstallableRuntime((String)this.runtimeWC.getRuntimeType().getId());
        }
        this.init();
        this.validate();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 0);
        label.setText(ServerUiPlugin.getResourceString("runtimeName"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.name = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerRuntimeComposite.this.runtimeWC.setName(ServerRuntimeComposite.this.name.getText());
                ServerRuntimeComposite.this.validate();
            }
        });
        label = new Label((Composite)this, 0);
        label.setText(ServerUiPlugin.getResourceString("installDir"));
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.installDir = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.installDir.setLayoutData((Object)data);
        this.installDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerRuntimeComposite.this.runtimeWC.setLocation((IPath)new Path(ServerRuntimeComposite.this.installDir.getText()));
                ServerRuntimeComposite.this.validate();
            }
        });
        Button browse = SWTUtil.createButton((Composite)this, (String)ServerUiPlugin.getResourceString("browse"));
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(ServerRuntimeComposite.this.getShell());
                dialog.setMessage(ServerUiPlugin.getResourceString("selectInstallDir"));
                dialog.setFilterPath(ServerRuntimeComposite.this.installDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    ServerRuntimeComposite.this.installDir.setText(selectedDirectory);
                }
            }
        });
        this.updateJREs();
        label = new Label((Composite)this, 0);
        label.setText(ServerUiPlugin.getResourceString("installedJRE"));
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.vmCombo = new Combo((Composite)this, 12);
        this.vmCombo.setItems(this.jreNames);
        data = new GridData(256);
        this.vmCombo.setLayoutData((Object)data);
        this.vmCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int sel = ServerRuntimeComposite.this.vmCombo.getSelectionIndex();
                IVMInstall vmInstall = null;
                if (sel > 0) {
                    vmInstall = ServerRuntimeComposite.this.installedJREs.get(sel - 1);
                }
                ServerRuntimeComposite.this.runtime.setVMInstall(vmInstall);
                ServerRuntimeComposite.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button button = SWTUtil.createButton((Composite)this, (String)ServerUiPlugin.getResourceString("installedJREs"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentVM = ServerRuntimeComposite.this.vmCombo.getText();
                if (ServerRuntimeComposite.this.showPreferencePage()) {
                    ServerRuntimeComposite.this.updateJREs();
                    ServerRuntimeComposite.this.vmCombo.setItems(ServerRuntimeComposite.this.jreNames);
                    ServerRuntimeComposite.this.vmCombo.setText(currentVM);
                    if (ServerRuntimeComposite.this.vmCombo.getSelectionIndex() == -1) {
                        ServerRuntimeComposite.this.vmCombo.select(0);
                    }
                    ServerRuntimeComposite.this.validate();
                }
            }
        });
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    protected void updateJREs() {
        this.installedJREs = new ArrayList<IVMInstall>();
        IVMInstallType[] vmInstallTypes = JavaRuntime.getVMInstallTypes();
        int size = vmInstallTypes.length;
        int i = 0;
        while (i < size) {
            IVMInstall[] vmInstalls = vmInstallTypes[i].getVMInstalls();
            int size2 = vmInstalls.length;
            int j = 0;
            while (j < size2) {
                this.installedJREs.add(vmInstalls[j]);
                ++j;
            }
            ++i;
        }
        size = this.installedJREs.size();
        this.jreNames = new String[size + 1];
        this.jreNames[0] = ServerUiPlugin.getResourceString("runtimeDefaultJRE");
        i = 0;
        while (i < size) {
            IVMInstall vmInstall = this.installedJREs.get(i);
            this.jreNames[i + 1] = vmInstall.getName();
            ++i;
        }
    }

    protected boolean showPreferencePage() {
        String id = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage").findSubNode(id);
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager2);
        dialog.create();
        return dialog.open() == 0;
    }

    protected void init() {
        if (this.name == null || this.runtime == null) {
            return;
        }
        if (this.runtimeWC.getName() != null) {
            this.name.setText(this.runtimeWC.getName());
        } else {
            this.name.setText("");
        }
        if (this.runtimeWC.getLocation() != null) {
            this.installDir.setText(this.runtimeWC.getLocation().toOSString());
        } else {
            this.installDir.setText("");
        }
        if (this.runtime.isUsingDefaultJRE()) {
            this.vmCombo.select(0);
        } else {
            boolean found = false;
            int size = this.installedJREs.size();
            int i = 0;
            while (i < size) {
                IVMInstall vmInstall = this.installedJREs.get(i);
                if (vmInstall.equals(this.runtime.getVMInstall())) {
                    this.vmCombo.select(i + 1);
                    found = true;
                }
                ++i;
            }
            if (!found) {
                this.vmCombo.select(0);
            }
        }
    }

    protected void validate() {
        if (this.runtime == null) {
            this.wizard.setMessage("", 3);
            return;
        }
        IStatus status = this.runtimeWC.validate(null);
        if (status == null) {
            this.wizard.setMessage(null, 0);
        } else if (status.isOK()) {
            this.wizard.setMessage(status.getMessage(), 1);
        } else if (status.getSeverity() == 2) {
            this.wizard.setMessage(status.getMessage(), 2);
        } else {
            this.wizard.setMessage(status.getMessage(), 3);
        }
        this.wizard.update();
    }
}

