/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.internal.actions;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.ui.internal.actions.AbstractConvertAction;
import org.eclipse.virgo.ide.ui.internal.actions.Messages;

public class ConvertPDE2VirgoProject
extends AbstractConvertAction
implements IObjectActionDelegate {
    private static final String PDE2_VIRGO_NATURE = "org.github.pde2virgo.PDE2VirgoNature";

    protected String getNature() {
        return PDE2_VIRGO_NATURE;
    }

    protected void migrate(IProgressMonitor monitor, IProject project) {
        monitor.beginTask("", 1);
        try {
            try {
                IProjectDescription description = project.getDescription();
                String[] natures = description.getNatureIds();
                int i = 0;
                while (i < natures.length) {
                    if (PDE2_VIRGO_NATURE.equals(natures[i])) {
                        natures[i] = "org.eclipse.virgo.ide.pde.core.nature";
                        break;
                    }
                    ++i;
                }
                description.setNatureIds(natures);
                project.setDescription(description, monitor);
            }
            catch (CoreException e) {
                Status s = new Status(4, "org.eclipse.virgo.ide.ui", e.getMessage());
                StatusManager.getManager().handle((IStatus)s, 2);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean showConfirmationDialog() {
        MessageDialog dlg = new MessageDialog(this.part.getSite().getShell(), Messages.ConvertPDE2VirgoProject_title, null, "", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0){

            protected Control createMessageArea(Composite composite) {
                composite.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).hint(200, -1).create());
                FormText text = new FormText(composite, 524288);
                text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        try {
                            PlatformUI.getWorkbench().getBrowserSupport().createBrowser("PDE2Virgo").openURL(new URL(e.getHref().toString()));
                        }
                        catch (Exception exception) {}
                    }
                });
                String xml = Messages.ConvertPDE2VirgoProject_message;
                text.setText(xml, true, false);
                return composite;
            }
        };
        int rc = dlg.open();
        return rc == 0;
    }
}

