/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.editor;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.virgo.ide.runtime.core.ServerCorePlugin;
import org.eclipse.virgo.ide.runtime.core.artefacts.ArtefactRepository;
import org.eclipse.virgo.ide.runtime.core.artefacts.ArtefactRepositoryManager;
import org.eclipse.virgo.ide.runtime.core.artefacts.IArtefactTyped;
import org.eclipse.virgo.ide.runtime.core.artefacts.LocalBundleArtefact;
import org.eclipse.virgo.ide.runtime.core.provisioning.IBundleRepositoryChangeListener;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositoryProvisioningJob;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositorySourceProvisiongJob;
import org.eclipse.virgo.ide.runtime.core.provisioning.RepositoryUtils;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiImages;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.Messages;
import org.eclipse.virgo.ide.runtime.internal.ui.repository.RefreshBundleJob;
import org.eclipse.virgo.ide.runtime.internal.ui.sorters.RepositoryViewerSorter;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;

public class RepositoryBrowserEditorPage
extends ServerEditorPart
implements ISelectionChangedListener {
    private static final DateFormat dateFormat = DateFormat.getDateInstance(1, Locale.getDefault());
    private final IJobChangeListener jobListener = new ArtefactOperationJobListener();
    private Button refreshButton;
    private CommonViewer repositoryTableViewer;
    private Button downloadSourcesButton;
    private Tree searchResultTable;
    private Shell shell;
    private Link update;
    private IBundleRepositoryChangeListener repositoryListener;

    public void createPartControl(Composite parent) {
        this.shell = parent.getShell();
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        toolkit.decorateFormHeading(form.getForm());
        form.setText(Messages.RepositoryBrowserEditorPage_BundleBrowserLabel);
        form.setImage(this.getFormImage());
        GridLayout layout = GridLayoutFactory.swtDefaults().numColumns(1).create();
        form.getBody().setLayout((Layout)layout);
        Section section = this.createSection(toolkit, form);
        form.setContent((Control)section);
        this.initialize();
    }

    protected Image getFormImage() {
        return ServerUiImages.getImage("org.eclipse.virgo.ide.runtime.ui.virgo_obj.png");
    }

    public void dispose() {
        super.dispose();
        Job.getJobManager().removeJobChangeListener(this.jobListener);
        ServerCorePlugin.getArtefactRepositoryManager().removeBundleRepositoryChangeListener(this.repositoryListener);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.addListeners();
        this.initialize();
    }

    public void setFocus() {
        if (this.searchResultTable != null) {
            this.searchResultTable.setFocus();
        }
    }

    private void setRepositoryDateString() {
        Date date = ServerCorePlugin.getArtefactRepositoryManager().getArtefactRepositoryDate();
        String dateString = dateFormat.format(date);
        this.update.setText(String.valueOf(Messages.RepositoryBrowserEditorPage_UpdateURL) + dateString + ")");
    }

    protected String getServerName() {
        return Messages.RepositoryBrowserEditorPage_ServerName;
    }

    private Section createSection(FormToolkit toolkit, ScrolledForm form) {
        Section section = toolkit.createSection(form.getBody(), 384);
        section.setText(Messages.RepositoryBrowserEditorPage_BundlesAndLibraries);
        section.setDescription(String.valueOf(Messages.RepositoryBrowserEditorPage_BundlesAndLibrariesMessage) + this.getServerName() + ". " + Messages.RepositoryBrowserEditorPage_BundlesAndLibrariesProviso);
        section.setLayoutData((Object)new GridData(1808));
        Composite leftComposite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        leftComposite.setLayout((Layout)layout);
        leftComposite.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(leftComposite);
        section.setClient((Control)leftComposite);
        GridData data = new GridData(768);
        Composite composite2 = toolkit.createComposite(leftComposite);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        composite2.setLayout((Layout)layout);
        composite2.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(composite2);
        this.repositoryTableViewer = new CommonViewer("org.eclipse.virgo.ide.runtime.ui.ArtefactsBrowserView", composite2, 2052);
        this.repositoryTableViewer.setSorter((ViewerSorter)new RepositoryViewerSorter());
        data = new GridData(1808);
        this.repositoryTableViewer.getControl().setLayoutData((Object)data);
        Composite buttonComposite = new Composite(composite2, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(2);
        buttonComposite.setLayoutData((Object)data);
        data = new GridData(768);
        this.refreshButton = toolkit.createButton(buttonComposite, Messages.RepositoryBrowserEditorPage_Refresh, 8);
        this.refreshButton.setLayoutData((Object)data);
        this.refreshButton.setToolTipText(Messages.RepositoryBrowserEditorPage_RefreshMessage);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RepositoryBrowserEditorPage.this.refreshBundleRepository();
            }
        });
        this.downloadSourcesButton = toolkit.createButton(buttonComposite, Messages.RepositoryBrowserEditorPage_InstallSources, 8);
        this.downloadSourcesButton.setLayoutData((Object)data);
        this.downloadSourcesButton.setToolTipText(Messages.RepositoryBrowserEditorPage_InstallSourcesMessage);
        this.downloadSourcesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RepositoryBrowserEditorPage.this.downloadSources();
            }
        });
        toolkit.createLabel(buttonComposite, Messages.RepositoryBrowserEditorPage_40);
        TableWrapLayout twLayout = new TableWrapLayout();
        twLayout.bottomMargin = 0;
        twLayout.topMargin = 0;
        twLayout.leftMargin = 0;
        twLayout.rightMargin = 0;
        Composite wrappedComposite = toolkit.createComposite(leftComposite);
        wrappedComposite.setLayout((Layout)twLayout);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)wrappedComposite);
        Link repoLink = new Link(wrappedComposite, 64);
        repoLink.setText(Messages.RepositoryBrowserEditorPage_NewBundlesMessage);
        repoLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryBrowserEditorPage.this.refreshBundleRepository();
            }
        });
        repoLink.setLayoutData((Object)new TableWrapData(2, 16));
        return section;
    }

    private void refreshBundleRepository() {
        RefreshBundleJob.execute(this.shell, this.getServer().getRuntime());
    }

    protected void downloadSources() {
        LinkedHashSet<LocalBundleArtefact> artifacts = new LinkedHashSet<LocalBundleArtefact>();
        ArtefactRepository repository = RepositoryUtils.getRepositoryContents((IRuntime)this.server.getRuntime());
        for (IArtefactTyped bundle : repository.getBundles()) {
            if (!(bundle instanceof LocalBundleArtefact) || ((LocalBundleArtefact)bundle).isSourceDownloaded()) continue;
            artifacts.add((LocalBundleArtefact)bundle);
        }
        HashSet<IRuntime> runtimes = new HashSet<IRuntime>();
        runtimes.add(this.getServer().getRuntime());
        RepositorySourceProvisiongJob operation = new RepositorySourceProvisiongJob(runtimes, artifacts);
        operation.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ServerUiImages.DESC_OBJ_BUNDLE);
        operation.schedule();
    }

    protected void addListeners() {
        Job.getJobManager().addJobChangeListener(this.jobListener);
        this.repositoryListener = new IBundleRepositoryChangeListener(){

            public void bundleRepositoryChanged(IRuntime runtime) {
                RepositoryBrowserEditorPage.this.refreshViewers();
            }
        };
        ServerCorePlugin.getArtefactRepositoryManager().addBundleRepositoryChangeListener(this.repositoryListener);
    }

    protected void initialize() {
        if (this.repositoryTableViewer == null) {
            return;
        }
        this.setErrorMessage(null);
        this.initializeViewers();
    }

    protected void initializeViewers() {
        this.shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (RepositoryBrowserEditorPage.this.repositoryTableViewer.getControl() != null && !RepositoryBrowserEditorPage.this.repositoryTableViewer.getControl().isDisposed()) {
                    RepositoryBrowserEditorPage.this.repositoryTableViewer.setInput((Object)RepositoryBrowserEditorPage.this.getServer());
                    RepositoryBrowserEditorPage.this.repositoryTableViewer.expandToLevel(2);
                }
            }
        });
    }

    protected void refreshViewers() {
        this.shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (RepositoryBrowserEditorPage.this.repositoryTableViewer.getControl() != null && !RepositoryBrowserEditorPage.this.repositoryTableViewer.getControl().isDisposed()) {
                    ISelection selection = RepositoryBrowserEditorPage.this.repositoryTableViewer.getSelection();
                    RepositoryBrowserEditorPage.this.repositoryTableViewer.refresh();
                    RepositoryBrowserEditorPage.this.repositoryTableViewer.setSelection(selection);
                }
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionChangedListener.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.repositoryTableViewer.setSelection((ISelection)sel, true);
        this.repositoryTableViewer.expandToLevel(sel.getFirstElement(), -1);
    }

    private final class ArtefactOperationJobListener
    extends JobChangeAdapter {
        private ArtefactOperationJobListener() {
        }

        public void done(IJobChangeEvent event) {
            if (event.getJob() instanceof RepositoryProvisioningJob) {
                if (((RepositoryProvisioningJob)event.getJob()).getRuntimes().contains(RepositoryBrowserEditorPage.this.getServer().getRuntime())) {
                    RepositoryBrowserEditorPage.this.refreshViewers();
                }
            } else if (event.getJob() instanceof ArtefactRepositoryManager.ArtefactRepositoryUpdateJob) {
                RepositoryBrowserEditorPage.this.shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (RepositoryBrowserEditorPage.this.update != null && !RepositoryBrowserEditorPage.this.update.isDisposed()) {
                            RepositoryBrowserEditorPage.this.setRepositoryDateString();
                        }
                    }
                });
            }
        }
    }
}

