/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.virgo.ide.runtime.core.IServerWorkingCopy;
import org.eclipse.virgo.ide.runtime.internal.core.actions.ModifyStaticResourcesCommand;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiImages;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.Messages;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class StaticResourcesEditorSection
extends ServerEditorSection {
    protected IServerWorkingCopy serverWorkingCopy;
    private Table filenameTable;
    private TableViewer filenamesTableViewer;
    private Button addButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    protected boolean updating;
    protected PropertyChangeListener listener;
    private StaticFilenamesContentProvider contentProvider;

    protected void addConfigurationChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.virgo.ide.runtime.corefilenames.static".equals(event.getPropertyName())) {
                    StaticResourcesEditorSection.this.filenamesTableViewer.setInput((Object)StaticResourcesEditorSection.this.server);
                }
            }
        };
        this.serverWorkingCopy.addConfigurationChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 458);
        section.setText(Messages.StaticResourcesEditorSection_title);
        section.setDescription(Messages.StaticResourcesEditorSection_description);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.filenameTable = toolkit.createTable(composite, 66052);
        GridData data = new GridData(4, 128, true, true);
        data.heightHint = this.filenameTable.getItemHeight() * 5 + this.filenameTable.getBorderWidth() * 2;
        data.heightHint = Math.min(150, data.heightHint);
        this.filenameTable.setLayoutData((Object)data);
        this.filenamesTableViewer = new TableViewer(this.filenameTable);
        this.contentProvider = new StaticFilenamesContentProvider();
        this.filenamesTableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.filenamesTableViewer.setLabelProvider((IBaseLabelProvider)new FilenameLabelProvider());
        this.filenamesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                StaticResourcesEditorSection.this.deleteButton.setEnabled(obj != null);
                StaticResourcesEditorSection.this.updateButtons(obj);
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout buttonLayout = new GridLayout(1, true);
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        this.addButton = toolkit.createButton(buttonComposite, Messages.StaticResourcesEditorSection_add_button, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.addButton);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StaticResourcesEditorSection.this.updating) {
                    return;
                }
                InputDialog dialog = new InputDialog(StaticResourcesEditorSection.this.getShell(), Messages.StaticResourcesEditorSection_new_filename_dialog_title, Messages.StaticResourcesEditorSection_new_filename_dialog_message, "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (!StringUtils.isNotBlank((String)newText)) {
                            return Messages.StaticResourcesEditorSection_empty_filename_error;
                        }
                        if ("*".equals(newText)) {
                            return Messages.StaticResourcesEditorSection_wildcard_too_greedy;
                        }
                        String replaceWildcards = newText.replaceAll("\\?", "a").replaceAll("\\*", "b");
                        if (!Path.isValidWindowsSegment((String)replaceWildcards) || !Path.isValidWindowsSegment((String)replaceWildcards)) {
                            return Messages.StaticResourcesEditorSection_invalid_path;
                        }
                        return null;
                    }
                });
                if (dialog.open() == 0) {
                    StaticResourcesEditorSection.this.updating = true;
                    ArrayList<Object> filenames = new ArrayList<Object>(Arrays.asList(StaticResourcesEditorSection.this.contentProvider.getElements(StaticResourcesEditorSection.this.server)));
                    filenames.add(dialog.getValue());
                    StaticResourcesEditorSection.this.execute((IUndoableOperation)new ModifyStaticResourcesCommand(StaticResourcesEditorSection.this.serverWorkingCopy, StringUtils.join(filenames, (String)",")));
                    StaticResourcesEditorSection.this.filenamesTableViewer.setInput((Object)StaticResourcesEditorSection.this.server);
                    StaticResourcesEditorSection.this.filenamesTableViewer.setSelection((ISelection)new StructuredSelection((Object)dialog.getValue()));
                    StaticResourcesEditorSection.this.updating = false;
                }
            }
        });
        this.deleteButton = toolkit.createButton(buttonComposite, Messages.StaticResourcesEditorSection_delete_button, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteButton);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedArtefact = ((IStructuredSelection)StaticResourcesEditorSection.this.filenamesTableViewer.getSelection()).getFirstElement();
                if (StaticResourcesEditorSection.this.updating) {
                    return;
                }
                StaticResourcesEditorSection.this.updating = true;
                ArrayList<Object> filenames = new ArrayList<Object>(Arrays.asList(StaticResourcesEditorSection.this.contentProvider.getElements(StaticResourcesEditorSection.this.server)));
                filenames.remove(selectedArtefact);
                StaticResourcesEditorSection.this.execute((IUndoableOperation)new ModifyStaticResourcesCommand(StaticResourcesEditorSection.this.serverWorkingCopy, StringUtils.join(filenames, (String)",")));
                StaticResourcesEditorSection.this.filenamesTableViewer.setInput((Object)StaticResourcesEditorSection.this.server);
                StaticResourcesEditorSection.this.updating = false;
            }
        });
        this.upButton = toolkit.createButton(buttonComposite, Messages.StaticResourcesEditorSection_up_button, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.upButton);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedArtefact = ((IStructuredSelection)StaticResourcesEditorSection.this.filenamesTableViewer.getSelection()).getFirstElement();
                ArrayList<Object> modules = new ArrayList<Object>();
                modules.addAll(Arrays.asList(StaticResourcesEditorSection.this.contentProvider.getElements(StaticResourcesEditorSection.this.server)));
                int index = modules.indexOf(selectedArtefact);
                modules.remove(selectedArtefact);
                modules.add(index - 1, selectedArtefact);
                if (StaticResourcesEditorSection.this.updating) {
                    return;
                }
                StaticResourcesEditorSection.this.updating = true;
                StaticResourcesEditorSection.this.execute((IUndoableOperation)new ModifyStaticResourcesCommand(StaticResourcesEditorSection.this.serverWorkingCopy, StringUtils.join(modules, (String)",")));
                StaticResourcesEditorSection.this.filenamesTableViewer.setInput((Object)StaticResourcesEditorSection.this.server);
                StaticResourcesEditorSection.this.updateButtons(selectedArtefact);
                StaticResourcesEditorSection.this.updating = false;
            }
        });
        this.downButton = toolkit.createButton(buttonComposite, Messages.StaticResourcesEditorSection_down_button, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.downButton);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedArtefact = ((IStructuredSelection)StaticResourcesEditorSection.this.filenamesTableViewer.getSelection()).getFirstElement();
                ArrayList<Object> modules = new ArrayList<Object>();
                modules.addAll(Arrays.asList(StaticResourcesEditorSection.this.contentProvider.getElements(StaticResourcesEditorSection.this.server)));
                int index = modules.indexOf(selectedArtefact);
                modules.remove(selectedArtefact);
                modules.add(index + 1, selectedArtefact);
                if (StaticResourcesEditorSection.this.updating) {
                    return;
                }
                StaticResourcesEditorSection.this.updating = true;
                StaticResourcesEditorSection.this.execute((IUndoableOperation)new ModifyStaticResourcesCommand(StaticResourcesEditorSection.this.serverWorkingCopy, StringUtils.join(modules, (String)",")));
                StaticResourcesEditorSection.this.filenamesTableViewer.setInput((Object)StaticResourcesEditorSection.this.server);
                StaticResourcesEditorSection.this.updateButtons(selectedArtefact);
                StaticResourcesEditorSection.this.updating = false;
            }
        });
        FormText restoreDefault = toolkit.createFormText(composite, true);
        restoreDefault.setText(Messages.StaticResourcesEditorSection_14, true, false);
        restoreDefault.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                StaticResourcesEditorSection.this.updating = true;
                StaticResourcesEditorSection.this.execute((IUndoableOperation)new ModifyStaticResourcesCommand(StaticResourcesEditorSection.this.serverWorkingCopy, "*.html,*.xhtml,*.css,*.js,*.jspx,*.jsp,*.gif,*.jpg,*.png,*.swf,*-flow.xml,*.properties,*.xml,!tiles.xml,!web.xml"));
                StaticResourcesEditorSection.this.filenamesTableViewer.setInput((Object)StaticResourcesEditorSection.this.server);
                StaticResourcesEditorSection.this.updating = false;
            }
        });
        this.updateEnablement();
        this.initialize();
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.filenamesTableViewer.getSelection();
        Object selectedArtefact = selection.getFirstElement();
        this.updateButtons(selectedArtefact);
    }

    private void updateButtons(Object obj) {
        if (obj instanceof String) {
            List<Object> modules = Arrays.asList(this.contentProvider.getElements(this.server));
            int index = modules.indexOf(obj);
            this.upButton.setEnabled(index > 0);
            this.downButton.setEnabled(index < modules.size() - 1);
            this.deleteButton.setEnabled(true);
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    private void updateEnablement() {
        this.addButton.setEnabled(true);
        this.updateButtons();
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.serverWorkingCopy = (IServerWorkingCopy)this.server.loadAdapter(IServerWorkingCopy.class, (IProgressMonitor)new NullProgressMonitor());
        this.addConfigurationChangeListener();
    }

    protected void initialize() {
        this.updating = true;
        this.filenamesTableViewer.setInput((Object)this.server);
        this.deleteButton.setEnabled(false);
        this.updating = false;
    }

    class FilenameLabelProvider
    extends LabelProvider {
        FilenameLabelProvider() {
        }

        public Image getImage(Object element) {
            return ServerUiImages.getImage("org.eclipse.virgo.ide.runtime.ui.file_obj.gif");
        }

        public String getText(Object element) {
            return element.toString();
        }
    }

    class StaticFilenamesContentProvider
    implements ITreeContentProvider {
        StaticFilenamesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IServer) {
                IServer server = (IServer)inputElement;
                IServerWorkingCopy dmServer = (IServerWorkingCopy)server.loadAdapter(IServerWorkingCopy.class, null);
                Object[] filenames = StringUtils.split((String)dmServer.getStaticFilenamePatterns(), (String)",");
                return filenames;
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }
}

