/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.policy.PolicyBlock;
import org.eclipse.jetty.policy.PolicyContext;
import org.eclipse.jetty.policy.PolicyException;
import org.eclipse.jetty.policy.PolicyMonitor;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.security.CertificateValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyPolicy
extends Policy {
    private static boolean __DEBUG = false;
    private static boolean __RELOAD = false;
    private boolean _STARTED = false;
    private String _policyDirectory;
    private final Set<PolicyBlock> _grants = new HashSet<PolicyBlock>();
    private final Map<Object, PermissionCollection> _cache = new ConcurrentHashMap<Object, PermissionCollection>();
    private static final PolicyContext _context = new PolicyContext();
    private CertificateValidator _validator = null;
    private PolicyMonitor _policyMonitor = new PolicyMonitor(){

        public void onPolicyChange(PolicyBlock grant) {
            boolean setGrant = true;
            if (JettyPolicy.this._validator != null && grant.getCertificates() != null) {
                for (Certificate cert : grant.getCertificates()) {
                    try {
                        JettyPolicy.this._validator.validate(_context.getKeystore(), cert);
                    }
                    catch (CertificateException ce) {
                        setGrant = false;
                    }
                }
            }
            if (setGrant) {
                JettyPolicy.this._grants.add(grant);
                JettyPolicy.this._cache.clear();
            }
        }
    };

    public JettyPolicy(String policyDirectory, Map<String, String> properties) {
        try {
            __RELOAD = Boolean.getBoolean("org.eclipse.jetty.policy.RELOAD");
            __DEBUG = Boolean.getBoolean("org.eclipse.jetty.policy.DEBUG");
        }
        catch (AccessControlException ace) {
            __RELOAD = false;
            __DEBUG = false;
        }
        this._policyDirectory = policyDirectory;
        _context.setProperties(properties);
        try {
            this._policyMonitor.setPolicyDirectory(this._policyDirectory);
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
    }

    @Override
    public void refresh() {
        if (!this._STARTED) {
            this.initialize();
        }
    }

    public void initialize() {
        if (this._STARTED) {
            return;
        }
        try {
            this._policyMonitor.start();
            this._policyMonitor.waitForScan();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PolicyException(e);
        }
        this._STARTED = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (!this._STARTED) {
            throw new PolicyException("JettyPolicy must be started.");
        }
        Map<Object, PermissionCollection> map = this._cache;
        synchronized (map) {
            if (this._cache.containsKey(domain)) {
                return this.copyOf(this._cache.get(domain));
            }
            Permissions perms = new Permissions();
            for (PolicyBlock policyBlock : this._grants) {
                ProtectionDomain grantPD = policyBlock.toProtectionDomain();
                if (__DEBUG) {
                    this.debug("----START----");
                    this.debug("PDCS: " + policyBlock.getCodeSource());
                    this.debug("CS: " + domain.getCodeSource());
                }
                if (grantPD.getCodeSource() == null || grantPD.getCodeSource().implies(domain.getCodeSource()) && grantPD.getPrincipals() == null || grantPD.getCodeSource().implies(domain.getCodeSource()) && JettyPolicy.validate(grantPD.getPrincipals(), domain.getPrincipals())) {
                    Enumeration<Permission> e = policyBlock.getPermissions().elements();
                    while (e.hasMoreElements()) {
                        Permission perm = e.nextElement();
                        if (__DEBUG) {
                            this.debug("D: " + perm);
                        }
                        ((PermissionCollection)perms).add(perm);
                    }
                }
                if (!__DEBUG) continue;
                this.debug("----STOP----");
            }
            this._cache.put(domain, perms);
            return this.copyOf(perms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        if (!this._STARTED) {
            throw new PolicyException("JettyPolicy must be started.");
        }
        Map<Object, PermissionCollection> map = this._cache;
        synchronized (map) {
            if (this._cache.containsKey(codesource)) {
                return this.copyOf(this._cache.get(codesource));
            }
            Permissions perms = new Permissions();
            for (PolicyBlock policyBlock : this._grants) {
                ProtectionDomain grantPD = policyBlock.toProtectionDomain();
                if (grantPD.getCodeSource() != null && !grantPD.getCodeSource().implies(codesource)) continue;
                if (__DEBUG) {
                    this.debug("----START----");
                    this.debug("PDCS: " + grantPD.getCodeSource());
                    this.debug("CS: " + codesource);
                }
                Enumeration<Permission> e = policyBlock.getPermissions().elements();
                while (e.hasMoreElements()) {
                    Permission perm = e.nextElement();
                    if (__DEBUG) {
                        this.debug("D: " + perm);
                    }
                    ((PermissionCollection)perms).add(perm);
                }
                if (!__DEBUG) continue;
                this.debug("----STOP----");
            }
            this._cache.put(codesource, perms);
            return this.copyOf(perms);
        }
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (!this._STARTED) {
            throw new PolicyException("JettyPolicy must be started.");
        }
        PermissionCollection pc = this.getPermissions(domain);
        return pc == null ? false : pc.implies(permission);
    }

    private static boolean validate(Principal[] permCerts, Principal[] classCerts) {
        if (classCerts == null) {
            return false;
        }
        for (int i = 0; i < permCerts.length; ++i) {
            boolean found = false;
            for (int j = 0; j < classCerts.length; ++j) {
                if (!((Object)permCerts[i]).equals(classCerts[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static PolicyContext getContext() {
        return _context;
    }

    private void debug(String message) {
        try {
            Log.info((String)message);
        }
        catch (AccessControlException ace) {
            System.out.println("[DEBUG] " + message);
        }
        catch (NoClassDefFoundError ace) {
            System.out.println("[DEBUG] " + message);
        }
    }

    private void log(String message) {
        this.log(message, null);
    }

    private void log(String message, Throwable t) {
        try {
            Log.info((String)message, (Object)t);
        }
        catch (AccessControlException ace) {
            System.out.println(message);
            t.printStackTrace();
        }
        catch (NoClassDefFoundError ace) {
            System.out.println(message);
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintStream out) {
        PrintWriter write = new PrintWriter(out);
        write.println("JettyPolicy: policy settings dump");
        Map<Object, PermissionCollection> map = this._cache;
        synchronized (map) {
            for (Object o : this._cache.keySet()) {
                write.println(o.toString());
            }
        }
        write.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection copyOf(PermissionCollection in) {
        Permissions out = new Permissions();
        PermissionCollection permissionCollection = in;
        synchronized (permissionCollection) {
            Enumeration<Permission> el = in.elements();
            while (el.hasMoreElements()) {
                ((PermissionCollection)out).add(el.nextElement());
            }
        }
        return out;
    }

    public CertificateValidator getCertificateValidator() {
        return this._validator;
    }

    public void setCertificateValidator(CertificateValidator validator) {
        if (this._STARTED) {
            throw new PolicyException("JettyPolicy already started, unable to set validator on running policy");
        }
        this._validator = validator;
    }
}

