/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ajp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.eclipse.jetty.http.AbstractGenerator;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.log.Log;

public class Ajp13Generator
extends AbstractGenerator {
    private static HashMap __headerHash = new HashMap();
    private static final byte[] AJP13_CPONG_RESPONSE;
    private static final byte[] AJP13_END_RESPONSE;
    private static final byte[] AJP13_MORE_CONTENT;
    private static String SERVER;
    private boolean _expectMore = false;
    private boolean _needMore = false;
    private boolean _needEOC = false;
    private boolean _bufferPrepared = false;

    public static void setServerVersion(String version) {
        SERVER = "Jetty(" + version + ")";
    }

    public Ajp13Generator(Buffers buffers, EndPoint io) {
        super(buffers, io);
    }

    public boolean isRequest() {
        return false;
    }

    public boolean isResponse() {
        return true;
    }

    public void reset(boolean returnBuffers) {
        super.reset(returnBuffers);
        this._needEOC = false;
        this._needMore = false;
        this._expectMore = false;
        this._bufferPrepared = false;
        this._last = false;
        this._state = 0;
        this._status = 0;
        this._version = 11;
        this._reason = null;
        this._method = null;
        this._uri = null;
        this._contentWritten = 0L;
        this._contentLength = -3L;
        this._last = false;
        this._head = false;
        this._noContent = false;
        this._persistent = true;
        this._header = null;
        this._buffer = null;
        this._content = null;
    }

    public int getContentBufferSize() {
        try {
            this.initContent();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return super.getContentBufferSize() - 7;
    }

    public void increaseContentBufferSize(int contentBufferSize) {
    }

    public void addContent(Buffer content, boolean last) throws IOException {
        if (this._noContent) {
            content.clear();
            return;
        }
        if (content.isImmutable()) {
            throw new IllegalArgumentException("immutable");
        }
        if (this._last || this._state == 4) {
            Log.debug((String)"Ignoring extra content {}", (Object)content);
            content.clear();
            return;
        }
        this._last = last;
        if (!this._endp.isOpen()) {
            this._state = 4;
            return;
        }
        if (this._content != null && this._content.length() > 0) {
            this.flushBuffer();
            if (this._content != null && this._content.length() > 0) {
                throw new IllegalStateException("FULL");
            }
        }
        this._content = content;
        this._contentWritten += (long)content.length();
        if (this._head) {
            content.clear();
            this._content = null;
        } else {
            this.initContent();
            int len = 0;
            len = this._buffer.put(this._content);
            if (len > 0 && this._buffer.space() == 0) {
                --len;
                this._buffer.setPutIndex(this._buffer.putIndex() - 1);
            }
            this._content.skip(len);
            if (this._content.length() == 0) {
                this._content = null;
            }
        }
    }

    public boolean addContent(byte b) throws IOException {
        if (this._noContent) {
            return false;
        }
        if (this._last || this._state == 4) {
            throw new IllegalStateException("Closed");
        }
        if (!this._endp.isOpen()) {
            this._state = 4;
            return false;
        }
        if (this._content != null && this._content.length() > 0) {
            this.flushBuffer();
            if (this._content != null && this._content.length() > 0) {
                throw new IllegalStateException("FULL");
            }
        }
        ++this._contentWritten;
        if (this._head) {
            return false;
        }
        this.initContent();
        this._buffer.put(b);
        return this._buffer.space() <= 1;
    }

    public int prepareUncheckedAddContent() throws IOException {
        if (this._noContent) {
            return -1;
        }
        if (this._last || this._state == 4) {
            throw new IllegalStateException("Closed");
        }
        if (!this._endp.isOpen()) {
            this._state = 4;
            return -1;
        }
        Buffer content = this._content;
        if (content != null && content.length() > 0) {
            this.flushBuffer();
            if (content != null && content.length() > 0) {
                throw new IllegalStateException("FULL");
            }
        }
        this.initContent();
        this._contentWritten -= (long)this._buffer.length();
        if (this._head) {
            return Integer.MAX_VALUE;
        }
        return this._buffer.space() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeHeader(HttpFields fields, boolean allContentAdded) throws IOException {
        if (this._state != 0) {
            return;
        }
        if (this._last && !allContentAdded) {
            throw new IllegalStateException("last?");
        }
        this._last |= allContentAdded;
        boolean has_server = false;
        if (this._persistent == null) {
            this._persistent = this._version > 10;
        }
        if (this._header == null) {
            this._header = this._buffers.getHeader();
        }
        Buffer tmpbuf = this._buffer;
        this._buffer = this._header;
        try {
            this._buffer.put((byte)65);
            this._buffer.put((byte)66);
            this.addInt(0);
            this._buffer.put((byte)4);
            this.addInt(this._status);
            if (this._reason == null) {
                this._reason = HttpGenerator.getReasonBuffer((int)this._status);
            }
            if (this._reason == null) {
                this._reason = new ByteArrayBuffer(Integer.toString(this._status));
            }
            this.addBuffer(this._reason);
            if (this._status == 100 || this._status == 204 || this._status == 304) {
                this._noContent = true;
                this._content = null;
            }
            int field_index = this._buffer.putIndex();
            this.addInt(0);
            int num_fields = 0;
            if (fields != null) {
                int s = fields.size();
                for (int f = 0; f < s; ++f) {
                    HttpFields.Field field = fields.getField(f);
                    if (field == null) continue;
                    ++num_fields;
                    byte[] codes = (byte[])__headerHash.get(field.getName());
                    if (codes != null) {
                        this._buffer.put(codes);
                    } else {
                        this.addString(field.getName());
                    }
                    this.addString(field.getValue());
                }
            }
            if (!has_server && this._status > 100 && this.getSendServerVersion()) {
                ++num_fields;
                this.addString("Server");
                this.addString(SERVER);
            }
            int tmp = this._buffer.putIndex();
            this._buffer.setPutIndex(field_index);
            this.addInt(num_fields);
            this._buffer.setPutIndex(tmp);
            int payloadSize = this._buffer.length() - 4;
            this.addInt(2, payloadSize);
        }
        finally {
            this._buffer = tmpbuf;
        }
        this._state = 2;
    }

    public void complete() throws IOException {
        if (this._state == 4) {
            return;
        }
        super.complete();
        if (this._state < 3) {
            this._state = 3;
            this._needEOC = true;
        }
        this.flushBuffer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long flushBuffer() throws IOException {
        try {
            if (this._state == 0 && !this._expectMore) {
                throw new IllegalStateException("State==HEADER");
            }
            this.prepareBuffers();
            if (this._endp == null) {
                if (!this._expectMore && this._needEOC && this._buffer != null) {
                    this._buffer.put(AJP13_END_RESPONSE);
                }
                this._needEOC = false;
                return 0L;
            }
            int total = 0;
            long last_len = -1L;
            while (true) {
                int len = -1;
                int to_flush = (this._header != null && this._header.length() > 0 ? 4 : 0) | (this._buffer != null && this._buffer.length() > 0 ? 2 : 0);
                switch (to_flush) {
                    case 7: {
                        throw new IllegalStateException();
                    }
                    case 6: {
                        len = this._endp.flush(this._header, this._buffer, null);
                        break;
                    }
                    case 5: {
                        throw new IllegalStateException();
                    }
                    case 4: {
                        len = this._endp.flush(this._header);
                        break;
                    }
                    case 3: {
                        throw new IllegalStateException();
                    }
                    case 2: {
                        len = this._endp.flush(this._buffer);
                        break;
                    }
                    case 1: {
                        throw new IllegalStateException();
                    }
                    case 0: {
                        if (this._header != null) {
                            this._header.clear();
                        }
                        this._bufferPrepared = false;
                        if (this._buffer != null) {
                            this._buffer.clear();
                            this._buffer.setPutIndex(7);
                            this._buffer.setGetIndex(7);
                            if (this._content != null && this._content.length() < this._buffer.space() && this._state != 3) {
                                this._buffer.put(this._content);
                                this._content.clear();
                                this._content = null;
                                return total;
                            }
                        }
                        if (!(this._expectMore || this._needEOC || this._content != null && this._content.length() != 0)) {
                            if (this._state != 3) return total;
                            this._state = 4;
                            return total;
                        }
                        this.prepareBuffers();
                    }
                }
                if (len <= 0) {
                    if (last_len > 0L) return total;
                    return total;
                }
                last_len = len;
                total += len;
            }
        }
        catch (IOException e) {
            IOException iOException;
            Log.ignore((Throwable)e);
            if (e instanceof EofException) {
                iOException = e;
                throw iOException;
            }
            iOException = new EofException((Throwable)e);
            throw iOException;
        }
    }

    private void prepareBuffers() {
        if (!this._bufferPrepared) {
            int payloadSize;
            if (this._content != null && this._content.length() > 0 && this._buffer != null && this._buffer.space() > 0) {
                int len = this._buffer.put(this._content);
                if (len > 0 && this._buffer.space() == 0) {
                    --len;
                    this._buffer.setPutIndex(this._buffer.putIndex() - 1);
                }
                this._content.skip(len);
                if (this._content.length() == 0) {
                    this._content = null;
                }
                if (this._buffer.length() == 0) {
                    this._content = null;
                }
            }
            if (this._buffer != null && (payloadSize = this._buffer.length()) > 0) {
                this._bufferPrepared = true;
                this._buffer.put((byte)0);
                int put = this._buffer.putIndex();
                this._buffer.setGetIndex(0);
                this._buffer.setPutIndex(0);
                this._buffer.put((byte)65);
                this._buffer.put((byte)66);
                this.addInt(payloadSize + 4);
                this._buffer.put((byte)3);
                this.addInt(payloadSize);
                this._buffer.setPutIndex(put);
            }
            if (this._needMore) {
                if (this._header == null) {
                    this._header = this._buffers.getHeader();
                }
                if (this._buffer == null && this._header != null && this._header.space() >= AJP13_MORE_CONTENT.length) {
                    this._header.put(AJP13_MORE_CONTENT);
                    this._needMore = false;
                } else if (this._buffer != null && this._buffer.space() >= AJP13_MORE_CONTENT.length) {
                    this._buffer.put(AJP13_MORE_CONTENT);
                    this._needMore = false;
                    this._bufferPrepared = true;
                }
            }
            if (!this._expectMore && this._needEOC) {
                if (this._buffer == null && this._header.space() >= AJP13_END_RESPONSE.length) {
                    this._header.put(AJP13_END_RESPONSE);
                    this._needEOC = false;
                } else if (this._buffer != null && this._buffer.space() >= AJP13_END_RESPONSE.length) {
                    this._buffer.put(AJP13_END_RESPONSE);
                    this._needEOC = false;
                    this._bufferPrepared = true;
                }
            }
        }
    }

    public boolean isComplete() {
        return !this._expectMore && this._state == 4;
    }

    private void initContent() throws IOException {
        if (this._buffer == null) {
            this._buffer = this._buffers.getBuffer();
            this._buffer.setPutIndex(7);
            this._buffer.setGetIndex(7);
        }
    }

    private void addInt(int i) {
        this._buffer.put((byte)(i >> 8 & 0xFF));
        this._buffer.put((byte)(i & 0xFF));
    }

    private void addInt(int startIndex, int i) {
        this._buffer.poke(startIndex, (byte)(i >> 8 & 0xFF));
        this._buffer.poke(startIndex + 1, (byte)(i & 0xFF));
    }

    private void addString(String str) throws UnsupportedEncodingException {
        if (str == null) {
            this.addInt(65535);
            return;
        }
        byte[] b = str.getBytes("ISO-8859-1");
        this.addInt(b.length);
        this._buffer.put(b);
        this._buffer.put((byte)0);
    }

    private void addBuffer(Buffer b) {
        if (b == null) {
            this.addInt(65535);
            return;
        }
        this.addInt(b.length());
        this._buffer.put(b);
        this._buffer.put((byte)0);
    }

    public void getBodyChunk() throws IOException {
        this._needMore = true;
        this._expectMore = true;
        this.flushBuffer();
    }

    public void gotBody() {
        this._needMore = false;
        this._expectMore = false;
    }

    public void sendCPong() throws IOException {
        Buffer buff = this._buffers.getBuffer();
        buff.put(AJP13_CPONG_RESPONSE);
        do {
            this._endp.flush(buff);
        } while (buff.length() > 0);
        this._buffers.returnBuffer(buff);
        this.reset(true);
    }

    static {
        byte[] xA001 = new byte[]{-96, 1};
        byte[] xA002 = new byte[]{-96, 2};
        byte[] xA003 = new byte[]{-96, 3};
        byte[] xA004 = new byte[]{-96, 4};
        byte[] xA005 = new byte[]{-96, 5};
        byte[] xA006 = new byte[]{-96, 6};
        byte[] xA007 = new byte[]{-96, 7};
        byte[] xA008 = new byte[]{-96, 8};
        byte[] xA009 = new byte[]{-96, 9};
        byte[] xA00A = new byte[]{-96, 10};
        byte[] xA00B = new byte[]{-96, 11};
        __headerHash.put("Content-Type", xA001);
        __headerHash.put("Content-Language", xA002);
        __headerHash.put("Content-Length", xA003);
        __headerHash.put("Date", xA004);
        __headerHash.put("Last-Modified", xA005);
        __headerHash.put("Location", xA006);
        __headerHash.put("Set-Cookie", xA007);
        __headerHash.put("Set-Cookie2", xA008);
        __headerHash.put("Servlet-Engine", xA009);
        __headerHash.put("Status", xA00A);
        __headerHash.put("WWW-Authenticate", xA00B);
        AJP13_CPONG_RESPONSE = new byte[]{65, 66, 0, 1, 9};
        AJP13_END_RESPONSE = new byte[]{65, 66, 0, 2, 5, 1};
        AJP13_MORE_CONTENT = new byte[]{65, 66, 0, 3, 6, 31, -7};
        SERVER = "Server: Jetty(7.x.x)";
    }
}

