/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.core.AbortableSignal;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AbortableSignalJunction {
    private static final Logger LOGGER;
    private final AbortableSignal signal;
    private final List<AbortableSignal> subSignals;
    private final AtomicInteger incompleteCount;
    private final AtomicBoolean failureSignalled;
    private final AtomicBoolean abortionSignalled;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        Factory factory = new Factory("AbortableSignalJunction.java", Class.forName("org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "failed", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction", "", "", "", "boolean"), 82);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "aborted", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction", "", "", "", "boolean"), 86);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "subSignalFailed", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction", "java.lang.Throwable:", "cause:", "", "void"), 91);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "subSignalAborted", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction", "", "", "", "void"), 111);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "subSignalSucceeded", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction", "", "", "", "void"), 131);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$0", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction", "", "", "", "org.slf4j.Logger"), 39);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$1", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction:java.lang.Throwable:", "arg0:arg1:", "", "void"), 89);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$2", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction:", "arg0:", "", "void"), 129);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$3", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction:", "arg0:", "", "void"), 109);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction");
        LOGGER = LoggerFactory.getLogger(AbortableSignalJunction.class);
    }

    public AbortableSignalJunction(AbortableSignal signal, int size) {
        try {
            this.failureSignalled = new AtomicBoolean(false);
            this.abortionSignalled = new AtomicBoolean(false);
            this.signal = signal;
            ArrayList<SubSignal> s = new ArrayList<SubSignal>();
            int i = 0;
            while (i < size) {
                s.add(new SubSignal(this, null));
                ++i;
            }
            this.subSignals = Collections.unmodifiableList(s);
            this.incompleteCount = new AtomicInteger(size);
            if (size <= 0 && this.signal != null) {
                this.signal.signalSuccessfulCompletion();
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public List<AbortableSignal> getSignals() {
        try {
            return this.subSignals;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public boolean failed() {
        try {
            try {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                boolean bl = this.failureSignalled.get();
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return bl;
            }
            catch (Throwable throwable) {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public boolean aborted() {
        try {
            try {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                boolean bl = this.abortionSignalled.get();
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return bl;
            }
            catch (Throwable throwable) {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void subSignalFailed(Throwable cause) {
        try {
            try {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                int i = this.incompleteCount.get();
                LOGGER.debug("SubSignal failed. {} has {} incomplete signals", (Object)this, (Object)i);
                while (i > 0 && !this.incompleteCount.compareAndSet(i, 0)) {
                    i = this.incompleteCount.get();
                }
                if (i > 0 && this.signal != null) {
                    LOGGER.debug("{} signalling failure", (Object)this);
                    this.signal.signalFailure(cause);
                    this.failureSignalled.set(true);
                }
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void subSignalAborted() {
        try {
            try {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                int i = this.incompleteCount.get();
                LOGGER.debug("SubSignal aborted. {} has {} incomplete signals", (Object)this, (Object)i);
                while (i > 0 && !this.incompleteCount.compareAndSet(i, 0)) {
                    i = this.incompleteCount.get();
                }
                if (i > 0 && this.signal != null) {
                    LOGGER.debug("{} signalling aborted", (Object)this);
                    this.signal.signalAborted();
                    this.abortionSignalled.set(true);
                }
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void subSignalSucceeded() {
        try {
            try {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                int incomplete = this.incompleteCount.decrementAndGet();
                LOGGER.debug("SubSignal succeeded. {} now has {} incomplete signals", (Object)this, (Object)incomplete);
                if (incomplete == 0 && this.signal != null) {
                    LOGGER.debug("{} has no incomplete signals. Signalling success", (Object)this);
                    this.signal.signalSuccessfulCompletion();
                }
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ Logger access$0() {
        try {
            try {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                Logger logger = LOGGER;
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return logger;
            }
            catch (Throwable throwable) {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$1(AbortableSignalJunction arg0, Throwable arg1) {
        try {
            try {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                arg0.subSignalFailed(arg1);
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return;
            }
            catch (Throwable throwable) {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$2(AbortableSignalJunction arg0) {
        try {
            try {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
                arg0.subSignalSucceeded();
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
                return;
            }
            catch (Throwable throwable) {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$3(AbortableSignalJunction arg0) {
        try {
            try {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
                arg0.subSignalAborted();
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
                return;
            }
            catch (Throwable throwable) {
                AbortableSignalJunction.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private class SubSignal
    implements AbortableSignal {
        private final AtomicBoolean complete;
        final /* synthetic */ AbortableSignalJunction this$0;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private SubSignal(AbortableSignalJunction abortableSignalJunction) {
            this.this$0 = abortableSignalJunction;
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                this.complete = new AtomicBoolean(false);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public void signalFailure(Throwable cause) {
            try {
                try {
                    SubSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                    if (this.complete.compareAndSet(false, true)) {
                        AbortableSignalJunction.access$0().debug("SubSignal {} signalling failure", (Object)this);
                        AbortableSignalJunction.access$1(this.this$0, cause);
                    }
                    SubSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                    return;
                }
                catch (Throwable throwable) {
                    SubSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                    throw throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public void signalSuccessfulCompletion() {
            try {
                try {
                    SubSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                    if (this.complete.compareAndSet(false, true)) {
                        AbortableSignalJunction.access$0().debug("SubSignal {} signalling success", (Object)this);
                        AbortableSignalJunction.access$2(this.this$0);
                    }
                    SubSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                    return;
                }
                catch (Throwable throwable) {
                    SubSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                    throw throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public void signalAborted() {
            try {
                try {
                    SubSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                    if (this.complete.compareAndSet(false, true)) {
                        AbortableSignalJunction.access$0().debug("SubSignal {} signalling abortion", (Object)this);
                        AbortableSignalJunction.access$3(this.this$0);
                    }
                    SubSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                    return;
                }
                catch (Throwable throwable) {
                    SubSignal.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                    throw throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /* synthetic */ SubSignal(AbortableSignalJunction abortableSignalJunction, SubSignal subSignal) {
            AbortableSignalJunction abortableSignalJunction2 = abortableSignalJunction;
            SubSignal ajc$aspectInstance = this;
            ajc$aspectInstance.this$0 = abortableSignalJunction2;
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                ajc$aspectInstance.complete = new AtomicBoolean(false);
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        static {
            Factory factory = new Factory("AbortableSignalJunction.java", Class.forName("org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction$SubSignal"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "signalFailure", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction$SubSignal", "java.lang.Throwable:", "cause:", "", "void"), 153);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "signalSuccessfulCompletion", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction$SubSignal", "", "", "", "void"), 160);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "signalAborted", "org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction$SubSignal", "", "", "", "void"), 167);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.core.internal.AbortableSignalJunction$SubSignal");
        }
    }
}

