/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal.bundle;

import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.math.ConcurrentHashSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleDriverBundleListener
implements SynchronousBundleListener {
    private final Logger logger;
    private final StandardBundleInstallArtifact installArtifact;
    private final Bundle bundle;
    private final ArtifactStateMonitor artifactStateMonitor;
    private final Set<Bundle> solicitedStartBundleSet;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public BundleDriverBundleListener(@NonNull StandardBundleInstallArtifact installArtifact, @NonNull Bundle bundle, @NonNull ArtifactStateMonitor artifactStateMonitor) {
        ArtifactStateMonitor artifactStateMonitor2 = artifactStateMonitor;
        Bundle bundle2 = bundle;
        StandardBundleInstallArtifact standardBundleInstallArtifact = installArtifact;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)standardBundleInstallArtifact);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)bundle2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)artifactStateMonitor2);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.solicitedStartBundleSet = new ConcurrentHashSet();
            this.installArtifact = installArtifact;
            this.bundle = bundle;
            this.artifactStateMonitor = artifactStateMonitor;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void addSolicitedStart(Bundle bundle) {
        try {
            try {
                BundleDriverBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                this.solicitedStartBundleSet.add(bundle);
                BundleDriverBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                BundleDriverBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void removeSolicitedStart(Bundle bundle) {
        try {
            try {
                BundleDriverBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                this.solicitedStartBundleSet.remove(bundle);
                BundleDriverBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                BundleDriverBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void bundleChanged(BundleEvent event) {
        try {
            try {
                BundleDriverBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                if (event.getBundle() == this.bundle) {
                    try {
                        switch (event.getType()) {
                            case 32: {
                                this.artifactStateMonitor.onResolved(this.installArtifact);
                                break;
                            }
                            case 128: 
                            case 512: {
                                this.artifactStateMonitor.onStarting(this.installArtifact);
                                break;
                            }
                            case 2: {
                                if (!this.solicitedStartBundleSet.contains(this.bundle)) {
                                    this.installArtifact.trackStart();
                                }
                                break;
                            }
                            case 256: {
                                this.artifactStateMonitor.onStopping(this.installArtifact);
                                break;
                            }
                            case 4: {
                                this.artifactStateMonitor.onStopped(this.installArtifact);
                                break;
                            }
                            case 64: {
                                this.artifactStateMonitor.onUnresolved(this.installArtifact);
                                break;
                            }
                            case 16: {
                                this.artifactStateMonitor.onUninstalled(this.installArtifact);
                                break;
                            }
                        }
                    }
                    catch (DeploymentException e) {
                        this.logger.error(String.format("listener for bundle %s threw DeploymentException", this.bundle), (Throwable)e);
                        throw new RuntimeException("percolated listener exception", e);
                    }
                }
                BundleDriverBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                BundleDriverBundleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("BundleDriverBundleListener.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleDriverBundleListener"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "addSolicitedStart", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleDriverBundleListener", "org.osgi.framework.Bundle:", "bundle:", "", "void"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "removeSolicitedStart", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleDriverBundleListener", "org.osgi.framework.Bundle:", "bundle:", "", "void"), 61);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "bundleChanged", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleDriverBundleListener", "org.osgi.framework.BundleEvent:", "event:", "", "void"), 68);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleDriverBundleListener");
    }
}

