/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.formatting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.shell.internal.formatting.PropertyFormatter;
import org.eclipse.virgo.medic.log.EntryExitTrace;

public final class PackageCommandFormatter {
    private static final int MAX_LINE_LENGTH = 80;
    private static final String NAME = "Name";
    private static final String VERSION = "Version";
    private static final String PROVIDER = "Providing Bundle";
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public List<String> formatList(List<QuasiExportPackage> packages) {
        try {
            PackageCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            Collections.sort(packages, new QuasiExportPackageComparator());
            int maxNameLength = NAME.length();
            int maxVersionLength = VERSION.length();
            for (QuasiExportPackage exportPackage : packages) {
                int nameLength = exportPackage.getPackageName().length();
                maxNameLength = nameLength > maxNameLength ? nameLength : maxNameLength;
                int versionLength = exportPackage.getVersion().toString().length();
                int n = maxVersionLength = versionLength > maxVersionLength ? versionLength : maxVersionLength;
            }
            ArrayList<String> lines = new ArrayList<String>();
            String format = String.format("%%-%ds %%-%ds %%%ds", maxNameLength, maxVersionLength, 80 - (2 + maxNameLength + maxVersionLength));
            lines.add(String.format(format, NAME, VERSION, PROVIDER));
            for (QuasiExportPackage exportPackage : packages) {
                lines.add(String.format(format, exportPackage.getPackageName(), exportPackage.getVersion().toString(), exportPackage.getExportingBundle().getBundleId()));
            }
            ArrayList<String> arrayList = lines;
            PackageCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return arrayList;
        }
        catch (Throwable throwable) {
            PackageCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public List<String> formatExamine(List<QuasiExportPackage> exportPackages) {
        try {
            PackageCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            ArrayList<String> lines = new ArrayList<String>();
            boolean first = true;
            for (QuasiExportPackage exportPackage : exportPackages) {
                if (!first) {
                    lines.add("");
                    lines.add("");
                }
                QuasiBundle exportingBundle = exportPackage.getExportingBundle();
                lines.add(String.format("Exporter: %s %s [%s]", exportingBundle.getSymbolicName(), exportingBundle.getVersion().toString(), exportingBundle.getBundleId()));
                lines.add("");
                lines.add(String.format("Attributes:", new Object[0]));
                lines.addAll(this.formatProperties(exportPackage.getAttributes()));
                lines.add("");
                lines.add(String.format("Directives:", new Object[0]));
                lines.addAll(this.formatProperties(exportPackage.getDirectives()));
                lines.add("");
                lines.add(String.format("Importer(s):", new Object[0]));
                if (exportPackage.getConsumers().isEmpty()) {
                    lines.add(String.format("    %s", "None"));
                } else {
                    for (QuasiImportPackage importPackage : exportPackage.getConsumers()) {
                        QuasiBundle importingBundle = importPackage.getImportingBundle();
                        lines.add(String.format("    %s %s [%s]", importingBundle.getSymbolicName(), importingBundle.getVersion().toString(), importingBundle.getBundleId()));
                        lines.add(String.format("        Import-Package attributes:", new Object[0]));
                        lines.addAll(this.formatProperties(importPackage.getAttributes(), "            "));
                        lines.add(String.format("        Import-Package directives:", new Object[0]));
                        lines.addAll(this.formatProperties(importPackage.getDirectives(), "            "));
                    }
                }
                first = false;
            }
            ArrayList<String> arrayList = lines;
            PackageCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return arrayList;
        }
        catch (Throwable throwable) {
            PackageCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private List<String> formatProperties(Map<String, Object> properties) {
        try {
            PackageCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            List<String> list = this.formatProperties(properties, "    ");
            PackageCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return list;
        }
        catch (Throwable throwable) {
            PackageCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private List<String> formatProperties(Map<String, Object> properties, String indent) {
        try {
            PackageCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            ArrayList<String> lines = new ArrayList<String>();
            ArrayList<String> keys = new ArrayList<String>(properties.keySet());
            if (keys.isEmpty()) {
                lines.add(String.format("%s%s", indent, "None"));
            } else {
                Collections.sort(keys);
                for (String key : keys) {
                    lines.add(String.format("%s%s:", indent, key));
                    Object value = properties.get(key);
                    if (value instanceof Object[]) {
                        List<String> propertyLines = PropertyFormatter.formatPropertyValue(value, 72);
                        for (String propertyLine : propertyLines) {
                            lines.add(String.format("%s    %s", indent, propertyLine));
                        }
                        continue;
                    }
                    lines.add(String.format("%s    %s", indent, value));
                }
            }
            ArrayList<String> arrayList = lines;
            PackageCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return arrayList;
        }
        catch (Throwable throwable) {
            PackageCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("PackageCommandFormatter.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.formatting.PackageCommandFormatter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "formatList", "org.eclipse.virgo.kernel.shell.internal.formatting.PackageCommandFormatter", "java.util.List:", "packages:", "", "java.util.List"), 35);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "formatExamine", "org.eclipse.virgo.kernel.shell.internal.formatting.PackageCommandFormatter", "java.util.List:", "exportPackages:", "", "java.util.List"), 60);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatProperties", "org.eclipse.virgo.kernel.shell.internal.formatting.PackageCommandFormatter", "java.util.Map:", "properties:", "", "java.util.List"), 103);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatProperties", "org.eclipse.virgo.kernel.shell.internal.formatting.PackageCommandFormatter", "java.util.Map:java.lang.String:", "properties:indent:", "", "java.util.List"), 107);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.formatting.PackageCommandFormatter");
    }

    private static class QuasiExportPackageComparator
    implements Comparator<QuasiExportPackage> {
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private QuasiExportPackageComparator() {
        }

        @Override
        public int compare(QuasiExportPackage package1, QuasiExportPackage package2) {
            try {
                QuasiExportPackageComparator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                int value = package1.getPackageName().compareTo(package2.getPackageName());
                int n = value != 0 ? value : package1.getVersion().compareTo(package2.getVersion());
                QuasiExportPackageComparator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return n;
            }
            catch (Throwable throwable) {
                QuasiExportPackageComparator.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("PackageCommandFormatter.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.formatting.PackageCommandFormatter$QuasiExportPackageComparator"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compare", "org.eclipse.virgo.kernel.shell.internal.formatting.PackageCommandFormatter$QuasiExportPackageComparator", "org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage:org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage:", "package1:package2:", "", "int"), 133);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.formatting.PackageCommandFormatter$QuasiExportPackageComparator");
        }
    }
}

