/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.virgo.snaps.core.SnapRegistry;
import org.eclipse.virgo.snaps.core.internal.Snap;
import org.eclipse.virgo.snaps.core.internal.SnapUtils;

public final class RequestRouter {
    private final SnapRegistry snapRegistry;
    private final ServletContext servletContext;

    public RequestRouter(SnapRegistry snapRegistry, ServletContext servletContext) {
        this.snapRegistry = snapRegistry;
        this.servletContext = servletContext;
    }

    void service(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        Snap snap = this.findSnap(request);
        if (snap != null) {
            snap.handleRequest(request, response);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void forward(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contextPath = SnapUtils.determineSnapContextPath(request);
        this.servletContext.getRequestDispatcher(String.valueOf(contextPath) + path).forward((ServletRequest)request, (ServletResponse)response);
    }

    public void include(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contextPath = SnapUtils.determineSnapContextPath(request);
        this.servletContext.getRequestDispatcher(String.valueOf(contextPath) + path).include((ServletRequest)request, (ServletResponse)response);
    }

    private Snap findSnap(HttpServletRequest request) {
        String contextPath = SnapUtils.determineSnapContextPath(request);
        return this.snapRegistry.findSnapByContextPath(contextPath);
    }

    void destroy() {
        this.snapRegistry.destroy();
    }
}

