/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.dump.impl.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.helpers.CyclicBuffer;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.List;
import org.eclipse.virgo.medic.dump.Dump;
import org.eclipse.virgo.medic.dump.DumpContributionFailedException;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.medic.impl.config.ConfigurationProvider;
import org.eclipse.virgo.medic.log.impl.logback.LoggingListener;
import org.slf4j.Marker;

public final class LogDumpContributor
implements DumpContributor,
LoggingListener {
    private static final String DEFAULT_LEVEL = Level.OFF.levelStr;
    private static final String DEFAULT_BUFFER_SIZE = "10000";
    private static final String DEFAULT_PATTERN = "%message%n";
    private static final String FILE_NAME = "log.log";
    private static final String NAME = "log";
    private final CyclicBuffer<LoggingEvent> buffer;
    private final ConfigurationProvider configurationProvider;
    private final Object monitor = new Object();

    public LogDumpContributor(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        Dictionary configDictionary = this.configurationProvider.getConfiguration();
        this.buffer = new CyclicBuffer(this.getBufferSize(configDictionary));
    }

    public String getName() {
        return NAME;
    }

    public void contribute(Dump dump) throws DumpContributionFailedException {
        Level configuredLevel = this.getLevel();
        if (Level.OFF.levelInt > configuredLevel.levelInt) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(dump.createFileWriter(FILE_NAME));
                List loggingEvents = this.buffer.asList();
                PatternLayout layout = this.createLayout();
                for (LoggingEvent event : loggingEvents) {
                    writer.print(layout.doLayout((ILoggingEvent)event));
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    private PatternLayout createLayout() {
        PatternLayout layout = new PatternLayout();
        layout.setPattern(this.getPattern(this.configurationProvider.getConfiguration()));
        layout.setContext((Context)new LoggerContext());
        layout.start();
        return layout;
    }

    private Level getLevel() {
        Dictionary configDictionary = this.configurationProvider.getConfiguration();
        String level = this.getLevel(configDictionary);
        return Level.valueOf((String)level);
    }

    private int getBufferSize(Dictionary configuration) {
        String bufferSizeString = this.getStringFromConfiguration(configuration, "log.dump.bufferSize", DEFAULT_BUFFER_SIZE);
        return Integer.parseInt(bufferSizeString);
    }

    private String getLevel(Dictionary configuration) {
        return this.getStringFromConfiguration(configuration, "log.dump.level", DEFAULT_LEVEL);
    }

    private String getPattern(Dictionary configuration) {
        return this.getStringFromConfiguration(configuration, "log.dump.pattern", DEFAULT_PATTERN);
    }

    private String getStringFromConfiguration(Dictionary configuration, String key, String defaultValue) {
        String value = (String)configuration.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLogging(Logger logger, String fqcn, Marker marker, Level level, String message, Object param, Throwable throwable) {
        if (level.isGreaterOrEqual(this.getLevel())) {
            LoggingEvent event = new LoggingEvent(fqcn, logger, level, message, throwable, new Object[]{param});
            event.setMarker(marker);
            event.setThreadName(Thread.currentThread().getName());
            Object object = this.monitor;
            synchronized (object) {
                this.buffer.add((Object)event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLogging(Logger logger, String fqcn, Marker marker, Level level, String message, Object param1, Object param2, Throwable throwable) {
        if (level.isGreaterOrEqual(this.getLevel())) {
            LoggingEvent event = new LoggingEvent(fqcn, logger, level, message, throwable, new Object[]{param1, param2});
            event.setMarker(marker);
            event.setThreadName(Thread.currentThread().getName());
            Object object = this.monitor;
            synchronized (object) {
                this.buffer.add((Object)event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLogging(Logger logger, String fqcn, Marker marker, Level level, String message, Object[] params, Throwable throwable) {
        if (level.isGreaterOrEqual(this.getLevel())) {
            LoggingEvent event = new LoggingEvent(fqcn, logger, level, message, throwable, params);
            event.setMarker(marker);
            event.setThreadName(Thread.currentThread().getName());
            Object object = this.monitor;
            synchronized (object) {
                this.buffer.add((Object)event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.monitor;
        synchronized (object) {
            this.buffer.clear();
        }
    }
}

