/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.portlet.context.PortletRequestAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletWebRequest
extends PortletRequestAttributes
implements NativeWebRequest {
    private PortletResponse response;

    public PortletWebRequest(PortletRequest request) {
        super(request);
    }

    public PortletWebRequest(PortletRequest request, PortletResponse response) {
        this(request);
        this.response = response;
    }

    public final PortletResponse getResponse() {
        return this.response;
    }

    public Object getNativeRequest() {
        return this.getRequest();
    }

    public Object getNativeResponse() {
        return this.getResponse();
    }

    public String getHeader(String headerName) {
        return this.getRequest().getProperty(headerName);
    }

    public String[] getHeaderValues(String headerName) {
        Object[] headerValues = StringUtils.toStringArray((Enumeration)this.getRequest().getProperties(headerName));
        return !ObjectUtils.isEmpty((Object[])headerValues) ? headerValues : null;
    }

    public Iterator<String> getHeaderNames() {
        return CollectionUtils.toIterator((Enumeration)this.getRequest().getPropertyNames());
    }

    public String getParameter(String paramName) {
        return this.getRequest().getParameter(paramName);
    }

    public String[] getParameterValues(String paramName) {
        return this.getRequest().getParameterValues(paramName);
    }

    public Iterator<String> getParameterNames() {
        return CollectionUtils.toIterator((Enumeration)this.getRequest().getParameterNames());
    }

    public Map<String, String[]> getParameterMap() {
        return this.getRequest().getParameterMap();
    }

    public Locale getLocale() {
        return this.getRequest().getLocale();
    }

    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    public String getRemoteUser() {
        return this.getRequest().getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this.getRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.getRequest().isUserInRole(role);
    }

    public boolean isSecure() {
        return this.getRequest().isSecure();
    }

    public boolean checkNotModified(long lastModifiedTimestamp) {
        return false;
    }

    public String getDescription(boolean includeClientInfo) {
        PortletRequest request = this.getRequest();
        StringBuilder result = new StringBuilder();
        result.append("context=").append(request.getContextPath());
        if (includeClientInfo) {
            String user;
            PortletSession session = request.getPortletSession(false);
            if (session != null) {
                result.append(";session=").append(session.getId());
            }
            if (StringUtils.hasLength((String)(user = this.getRequest().getRemoteUser()))) {
                result.append(";user=").append(user);
            }
        }
        return result.toString();
    }

    @Override
    public String toString() {
        return "PortletWebRequest: " + this.getDescription(true);
    }
}

