/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.ClientDataRequest;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.Mapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.portlet.bind.PortletRequestBindingException;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.handler.AbstractMapBasedHandlerMapping;
import org.springframework.web.portlet.handler.PortletRequestMethodNotSupportedException;
import org.springframework.web.portlet.mvc.annotation.PortletAnnotationMappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationHandlerMapping
extends AbstractMapBasedHandlerMapping<PortletMode> {
    private final Map<Class, RequestMapping> cachedMappings = new HashMap<Class, RequestMapping>();

    @Override
    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.detectHandlers();
    }

    protected void detectHandlers() throws BeansException {
        String[] beanNames;
        ApplicationContext context = this.getApplicationContext();
        String[] stringArray = beanNames = context.getBeanNamesForType(Object.class);
        int n = beanNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            Class handlerType = context.getType(beanName);
            RequestMapping mapping = (RequestMapping)context.findAnnotationOnBean(beanName, RequestMapping.class);
            if (mapping != null) {
                this.cachedMappings.put(handlerType, mapping);
                String[] modeKeys = mapping.value();
                String[] params = mapping.params();
                boolean registerHandlerType = true;
                if (modeKeys.length == 0 || params.length == 0) {
                    boolean bl = registerHandlerType = !this.detectHandlerMethods(handlerType, beanName, mapping);
                }
                if (registerHandlerType) {
                    ParameterMappingPredicate predicate = new ParameterMappingPredicate(params, mapping.headers(), mapping.method());
                    String[] stringArray2 = modeKeys;
                    int n3 = modeKeys.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String modeKey = stringArray2[n4];
                        this.registerHandler(new PortletMode(modeKey), beanName, predicate);
                        ++n4;
                    }
                }
            } else if (AnnotationUtils.findAnnotation((Class)handlerType, Controller.class) != null) {
                this.detectHandlerMethods(handlerType, beanName, mapping);
            }
            ++n2;
        }
    }

    protected boolean detectHandlerMethods(Class handlerType, final String beanName, final RequestMapping typeMapping) {
        final HashSet handlersRegistered = new HashSet(1);
        ReflectionUtils.doWithMethods((Class)handlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                boolean mappingFound = false;
                String[] modeKeys = new String[]{};
                String[] params = new String[]{};
                String resourceId = null;
                String eventName = null;
                Annotation[] annotationArray = method.getAnnotations();
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation ann = annotationArray[n2];
                    if (AnnotationUtils.findAnnotation(ann.getClass(), Mapping.class) != null) {
                        Object rm;
                        mappingFound = true;
                        if (ann instanceof RequestMapping) {
                            rm = (RequestMapping)ann;
                            modeKeys = rm.value();
                            params = StringUtils.mergeStringArrays((String[])params, (String[])rm.params());
                        } else if (ann instanceof ResourceMapping) {
                            rm = (ResourceMapping)ann;
                            resourceId = rm.value();
                        } else if (ann instanceof EventMapping) {
                            EventMapping em = (EventMapping)ann;
                            eventName = em.value();
                        } else {
                            String[] specificParams = (String[])AnnotationUtils.getValue((Annotation)ann, (String)"params");
                            params = StringUtils.mergeStringArrays((String[])params, (String[])specificParams);
                        }
                    }
                    ++n2;
                }
                if (mappingFound) {
                    if (modeKeys.length == 0) {
                        if (typeMapping != null) {
                            modeKeys = typeMapping.value();
                        } else {
                            throw new IllegalStateException("No portlet mode mappings specified - neither at type nor at method level");
                        }
                    }
                    if (typeMapping != null) {
                        if (!PortletAnnotationMappingUtils.validateModeMapping(modeKeys, typeMapping.value())) {
                            throw new IllegalStateException("Mode mappings conflict between method and type level: " + Arrays.asList(modeKeys) + " versus " + Arrays.asList(typeMapping.value()));
                        }
                        params = StringUtils.mergeStringArrays((String[])typeMapping.params(), (String[])params);
                    }
                    AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate predicate = resourceId != null ? new ResourceMappingPredicate(resourceId) : (eventName != null ? new EventMappingPredicate(eventName) : new ParameterMappingPredicate(params));
                    String[] stringArray = modeKeys;
                    int n3 = modeKeys.length;
                    n = 0;
                    while (n < n3) {
                        String modeKey = stringArray[n];
                        DefaultAnnotationHandlerMapping.this.registerHandler(new PortletMode(modeKey), beanName, predicate);
                        handlersRegistered.add(Boolean.TRUE);
                        ++n;
                    }
                }
            }
        });
        return !handlersRegistered.isEmpty();
    }

    @Override
    protected PortletMode getLookupKey(PortletRequest request) throws Exception {
        return request.getPortletMode();
    }

    protected void validateHandler(Object handler, PortletRequest request) throws Exception {
        RequestMapping mapping = this.cachedMappings.get(handler.getClass());
        if (mapping == null) {
            mapping = (RequestMapping)AnnotationUtils.findAnnotation(handler.getClass(), RequestMapping.class);
        }
        if (mapping != null) {
            this.validateMapping(mapping, request);
        }
    }

    protected void validateMapping(RequestMapping mapping, PortletRequest request) throws Exception {
        RequestMethod[] mappedMethods = mapping.method();
        if (!PortletAnnotationMappingUtils.checkRequestMethod(mappedMethods, request)) {
            String[] supportedMethods = new String[mappedMethods.length];
            int i = 0;
            while (i < mappedMethods.length) {
                supportedMethods[i] = mappedMethods[i].name();
                ++i;
            }
            if (request instanceof ClientDataRequest) {
                throw new PortletRequestMethodNotSupportedException(((ClientDataRequest)request).getMethod(), supportedMethods);
            }
            throw new PortletRequestMethodNotSupportedException(supportedMethods);
        }
        Object[] mappedHeaders = mapping.headers();
        if (!PortletAnnotationMappingUtils.checkHeaders((String[])mappedHeaders, request)) {
            throw new PortletRequestBindingException("Header conditions \"" + StringUtils.arrayToDelimitedString((Object[])mappedHeaders, (String)", ") + "\" not met for actual request");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EventMappingPredicate
    implements AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate {
        private final String eventName;

        public EventMappingPredicate(String eventName) {
            this.eventName = eventName;
        }

        @Override
        public boolean match(PortletRequest request) {
            if (!"EVENT_PHASE".equals(request.getAttribute("javax.portlet.lifecycle_phase"))) {
                return false;
            }
            if ("".equals(this.eventName)) {
                return true;
            }
            Event event = ((EventRequest)request).getEvent();
            return this.eventName.equals(event.getName()) || this.eventName.equals(event.getQName().toString());
        }

        @Override
        public void validate(PortletRequest request) {
        }

        public int compareTo(Object o) {
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterMappingPredicate
    implements AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate {
        private final String[] params;
        private final String[] headers;
        private final Set<String> methods = new HashSet<String>();

        public ParameterMappingPredicate(String[] params) {
            this(params, null, null);
        }

        public ParameterMappingPredicate(String[] params, String[] headers, RequestMethod[] methods) {
            this.params = params;
            this.headers = headers;
            if (methods != null) {
                RequestMethod[] requestMethodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    RequestMethod method = requestMethodArray[n2];
                    this.methods.add(method.name());
                    ++n2;
                }
            }
        }

        @Override
        public boolean match(PortletRequest request) {
            return PortletAnnotationMappingUtils.checkParameters(this.params, request);
        }

        @Override
        public void validate(PortletRequest request) throws PortletException {
            if (!PortletAnnotationMappingUtils.checkHeaders(this.headers, request)) {
                throw new PortletRequestBindingException("Header conditions \"" + StringUtils.arrayToDelimitedString((Object[])this.headers, (String)", ") + "\" not met for actual request");
            }
            if (!this.methods.isEmpty()) {
                if (!(request instanceof ClientDataRequest)) {
                    throw new PortletRequestMethodNotSupportedException(StringUtils.toStringArray(this.methods));
                }
                String method = ((ClientDataRequest)request).getMethod();
                if (!this.methods.contains(method)) {
                    throw new PortletRequestMethodNotSupportedException(method, StringUtils.toStringArray(this.methods));
                }
            }
        }

        public int compareTo(Object other) {
            if (other instanceof ParameterMappingPredicate) {
                return new Integer(((ParameterMappingPredicate)other).params.length).compareTo(this.params.length);
            }
            return 1;
        }

        public String toString() {
            return StringUtils.arrayToCommaDelimitedString((Object[])this.params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceMappingPredicate
    implements AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate {
        private final String resourceId;

        public ResourceMappingPredicate(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public boolean match(PortletRequest request) {
            return "RESOURCE_PHASE".equals(request.getAttribute("javax.portlet.lifecycle_phase")) && ("".equals(this.resourceId) || this.resourceId.equals(((ResourceRequest)request).getResourceID()));
        }

        @Override
        public void validate(PortletRequest request) {
        }

        public int compareTo(Object o) {
            return -1;
        }
    }
}

