/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class AbstractListenerContainerParser
implements BeanDefinitionParser {
    protected static final String LISTENER_ELEMENT = "listener";
    protected static final String ID_ATTRIBUTE = "id";
    protected static final String DESTINATION_ATTRIBUTE = "destination";
    protected static final String SUBSCRIPTION_ATTRIBUTE = "subscription";
    protected static final String SELECTOR_ATTRIBUTE = "selector";
    protected static final String REF_ATTRIBUTE = "ref";
    protected static final String METHOD_ATTRIBUTE = "method";
    protected static final String DESTINATION_RESOLVER_ATTRIBUTE = "destination-resolver";
    protected static final String MESSAGE_CONVERTER_ATTRIBUTE = "message-converter";
    protected static final String RESPONSE_DESTINATION_ATTRIBUTE = "response-destination";
    protected static final String DESTINATION_TYPE_ATTRIBUTE = "destination-type";
    protected static final String DESTINATION_TYPE_QUEUE = "queue";
    protected static final String DESTINATION_TYPE_TOPIC = "topic";
    protected static final String DESTINATION_TYPE_DURABLE_TOPIC = "durableTopic";
    protected static final String CLIENT_ID_ATTRIBUTE = "client-id";
    protected static final String ACKNOWLEDGE_ATTRIBUTE = "acknowledge";
    protected static final String ACKNOWLEDGE_AUTO = "auto";
    protected static final String ACKNOWLEDGE_CLIENT = "client";
    protected static final String ACKNOWLEDGE_DUPS_OK = "dups-ok";
    protected static final String ACKNOWLEDGE_TRANSACTED = "transacted";
    protected static final String TRANSACTION_MANAGER_ATTRIBUTE = "transaction-manager";
    protected static final String CONCURRENCY_ATTRIBUTE = "concurrency";
    protected static final String PHASE_ATTRIBUTE = "phase";
    protected static final String PREFETCH_ATTRIBUTE = "prefetch";

    AbstractListenerContainerParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compositeDef);
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            String localName;
            Node child = childNodes.item(i);
            if (child.getNodeType() == 1 && LISTENER_ELEMENT.equals(localName = parserContext.getDelegate().getLocalName(child))) {
                this.parseListener((Element)child, element, parserContext);
            }
            ++i;
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private void parseListener(Element listenerEle, Element containerEle, ParserContext parserContext) {
        RootBeanDefinition listenerDef = new RootBeanDefinition();
        listenerDef.setSource(parserContext.extractSource((Object)listenerEle));
        String ref = listenerEle.getAttribute(REF_ATTRIBUTE);
        if (!StringUtils.hasText((String)ref)) {
            parserContext.getReaderContext().error("Listener 'ref' attribute contains empty value.", (Object)listenerEle);
        } else {
            listenerDef.getPropertyValues().add("delegate", (Object)new RuntimeBeanReference(ref));
        }
        String method = null;
        if (listenerEle.hasAttribute(METHOD_ATTRIBUTE) && !StringUtils.hasText((String)(method = listenerEle.getAttribute(METHOD_ATTRIBUTE)))) {
            parserContext.getReaderContext().error("Listener 'method' attribute contains empty value.", (Object)listenerEle);
        }
        listenerDef.getPropertyValues().add("defaultListenerMethod", (Object)method);
        if (containerEle.hasAttribute(MESSAGE_CONVERTER_ATTRIBUTE)) {
            String messageConverter = containerEle.getAttribute(MESSAGE_CONVERTER_ATTRIBUTE);
            if (!StringUtils.hasText((String)messageConverter)) {
                parserContext.getReaderContext().error("Listener container 'message-converter' attribute contains empty value.", (Object)containerEle);
            } else {
                listenerDef.getPropertyValues().add("messageConverter", (Object)new RuntimeBeanReference(messageConverter));
            }
        }
        BeanDefinition containerDef = this.parseContainer(listenerEle, containerEle, parserContext);
        if (listenerEle.hasAttribute(RESPONSE_DESTINATION_ATTRIBUTE)) {
            String responseDestination = listenerEle.getAttribute(RESPONSE_DESTINATION_ATTRIBUTE);
            boolean pubSubDomain = this.indicatesPubSub(containerDef);
            listenerDef.getPropertyValues().add(pubSubDomain ? "defaultResponseTopicName" : "defaultResponseQueueName", (Object)responseDestination);
            if (containerDef.getPropertyValues().contains("destinationResolver")) {
                listenerDef.getPropertyValues().add("destinationResolver", containerDef.getPropertyValues().getPropertyValue("destinationResolver").getValue());
            }
        }
        boolean jms102 = this.indicatesJms102(containerDef);
        listenerDef.setBeanClassName("org.springframework.jms.listener.adapter.MessageListenerAdapter" + (jms102 ? "102" : ""));
        containerDef.getPropertyValues().add("messageListener", (Object)listenerDef);
        String containerBeanName = listenerEle.getAttribute(ID_ATTRIBUTE);
        if (!StringUtils.hasText((String)containerBeanName)) {
            containerBeanName = parserContext.getReaderContext().generateBeanName(containerDef);
        }
        parserContext.registerBeanComponent(new BeanComponentDefinition(containerDef, containerBeanName));
    }

    protected abstract BeanDefinition parseContainer(Element var1, Element var2, ParserContext var3);

    protected boolean indicatesPubSub(BeanDefinition containerDef) {
        return false;
    }

    protected boolean indicatesJms102(BeanDefinition containerDef) {
        return false;
    }

    protected void parseListenerConfiguration(Element ele, ParserContext parserContext, BeanDefinition configDef) {
        String destination = ele.getAttribute(DESTINATION_ATTRIBUTE);
        if (!StringUtils.hasText((String)destination)) {
            parserContext.getReaderContext().error("Listener 'destination' attribute contains empty value.", (Object)ele);
        }
        configDef.getPropertyValues().add("destinationName", (Object)destination);
        if (ele.hasAttribute(SUBSCRIPTION_ATTRIBUTE)) {
            String subscription = ele.getAttribute(SUBSCRIPTION_ATTRIBUTE);
            if (!StringUtils.hasText((String)subscription)) {
                parserContext.getReaderContext().error("Listener 'subscription' attribute contains empty value.", (Object)ele);
            }
            configDef.getPropertyValues().add("durableSubscriptionName", (Object)subscription);
        }
        if (ele.hasAttribute(SELECTOR_ATTRIBUTE)) {
            String selector = ele.getAttribute(SELECTOR_ATTRIBUTE);
            if (!StringUtils.hasText((String)selector)) {
                parserContext.getReaderContext().error("Listener 'selector' attribute contains empty value.", (Object)ele);
            }
            configDef.getPropertyValues().add("messageSelector", (Object)selector);
        }
    }

    protected void parseContainerConfiguration(Element ele, ParserContext parserContext, BeanDefinition configDef) {
        String destinationType = ele.getAttribute(DESTINATION_TYPE_ATTRIBUTE);
        boolean pubSubDomain = false;
        boolean subscriptionDurable = false;
        if (DESTINATION_TYPE_DURABLE_TOPIC.equals(destinationType)) {
            pubSubDomain = true;
            subscriptionDurable = true;
        } else if (DESTINATION_TYPE_TOPIC.equals(destinationType)) {
            pubSubDomain = true;
        } else if (!"".equals(destinationType) && !DESTINATION_TYPE_QUEUE.equals(destinationType)) {
            parserContext.getReaderContext().error("Invalid listener container 'destination-type': only \"queue\", \"topic\" and \"durableTopic\" supported.", (Object)ele);
        }
        configDef.getPropertyValues().add("pubSubDomain", (Object)pubSubDomain);
        configDef.getPropertyValues().add("subscriptionDurable", (Object)subscriptionDurable);
        if (ele.hasAttribute(CLIENT_ID_ATTRIBUTE)) {
            String clientId = ele.getAttribute(CLIENT_ID_ATTRIBUTE);
            if (!StringUtils.hasText((String)clientId)) {
                parserContext.getReaderContext().error("Listener 'client-id' attribute contains empty value.", (Object)ele);
            }
            configDef.getPropertyValues().add("clientId", (Object)clientId);
        }
    }

    protected Integer parseAcknowledgeMode(Element ele, ParserContext parserContext) {
        String acknowledge = ele.getAttribute(ACKNOWLEDGE_ATTRIBUTE);
        if (StringUtils.hasText((String)acknowledge)) {
            int acknowledgeMode = 1;
            if (ACKNOWLEDGE_TRANSACTED.equals(acknowledge)) {
                acknowledgeMode = 0;
            } else if (ACKNOWLEDGE_DUPS_OK.equals(acknowledge)) {
                acknowledgeMode = 3;
            } else if (ACKNOWLEDGE_CLIENT.equals(acknowledge)) {
                acknowledgeMode = 2;
            } else if (!ACKNOWLEDGE_AUTO.equals(acknowledge)) {
                parserContext.getReaderContext().error("Invalid listener container 'acknowledge' setting [" + acknowledge + "]: only \"auto\", \"client\", \"dups-ok\" and \"transacted\" supported.", (Object)ele);
            }
            return acknowledgeMode;
        }
        return null;
    }

    protected boolean indicatesPubSubConfig(BeanDefinition configDef) {
        return (Boolean)configDef.getPropertyValues().getPropertyValue("pubSubDomain").getValue();
    }

    protected int[] parseConcurrency(Element ele, ParserContext parserContext) {
        String concurrency = ele.getAttribute(CONCURRENCY_ATTRIBUTE);
        if (!StringUtils.hasText((String)concurrency)) {
            return null;
        }
        try {
            int separatorIndex = concurrency.indexOf(45);
            if (separatorIndex != -1) {
                int[] result = new int[]{Integer.parseInt(concurrency.substring(0, separatorIndex)), Integer.parseInt(concurrency.substring(separatorIndex + 1, concurrency.length()))};
                return result;
            }
            return new int[]{1, Integer.parseInt(concurrency)};
        }
        catch (NumberFormatException ex) {
            parserContext.getReaderContext().error("Invalid concurrency value [" + concurrency + "]: only " + "single maximum integer (e.g. \"5\") and minimum-maximum combo (e.g. \"3-5\") supported.", (Object)ele, (Throwable)ex);
            return null;
        }
    }
}

