/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StringUtils;

final class SimpleClientHttpResponse
implements ClientHttpResponse {
    private final HttpURLConnection connection;
    private HttpHeaders headers;

    SimpleClientHttpResponse(HttpURLConnection connection) {
        this.connection = connection;
    }

    public HttpStatus getStatusCode() throws IOException {
        return HttpStatus.valueOf(this.connection.getResponseCode());
    }

    public String getStatusText() throws IOException {
        return this.connection.getResponseMessage();
    }

    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            String name;
            this.headers = new HttpHeaders();
            int i = 1;
            while (StringUtils.hasLength((String)(name = this.connection.getHeaderFieldKey(i)))) {
                this.headers.add(name, this.connection.getHeaderField(i));
                ++i;
            }
        }
        return this.headers;
    }

    public InputStream getBody() throws IOException {
        InputStream errorStream = this.connection.getErrorStream();
        return errorStream != null ? errorStream : this.connection.getInputStream();
    }

    public void close() {
        this.connection.disconnect();
    }
}

